/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.admin;

import fish.payara.nucleus.microprofile.config.admin.SetConfigProperty;
import fish.payara.nucleus.microprofile.config.source.ApplicationConfigSource;
import fish.payara.nucleus.microprofile.config.source.ClusterConfigSource;
import fish.payara.nucleus.microprofile.config.source.ConfigConfigSource;
import fish.payara.nucleus.microprofile.config.source.DomainConfigSource;
import fish.payara.nucleus.microprofile.config.source.JNDIConfigSource;
import fish.payara.nucleus.microprofile.config.source.ModuleConfigSource;
import fish.payara.nucleus.microprofile.config.source.ServerConfigSource;
import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSourceService;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-config-property")
@PerLookup
@ExecuteOn
@TargetType
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="delete-config-property", description="Deletes a configuration property")})
public class DeleteConfigProperty
implements AdminCommand {
    @Param(optional=true, acceptableValues="domain,config,server,application,module,cluster,jndi,cloud", defaultValue="domain")
    String source;
    @Param(optional=true, defaultValue="server")
    String target;
    @Param
    String propertyName;
    @Param(optional=true)
    String sourceName;
    @Param(optional=true)
    String moduleName;
    @Inject
    private ExtensionConfigSourceService extensionService;

    public void execute(AdminCommandContext context) {
        try {
            switch (this.source) {
                case "domain": {
                    DomainConfigSource csource = new DomainConfigSource();
                    csource.deleteValue(this.propertyName);
                    break;
                }
                case "config": {
                    if (this.sourceName == null) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "sourceName is a required parameter and the name of the configuration if config is the source");
                        break;
                    }
                    ConfigConfigSource csource = new ConfigConfigSource(this.sourceName);
                    if (!csource.deleteValue(this.propertyName)) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "Failed to delete the Microprofile Config Value. Please check the configuration named " + this.sourceName + " is in your domain");
                    }
                    break;
                }
                case "server": {
                    if (this.sourceName == null) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "sourceName is a required parameter and the name of the server if server is the source");
                        break;
                    }
                    ServerConfigSource csource = new ServerConfigSource(this.sourceName);
                    if (!csource.deleteValue(this.propertyName)) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "Failed to delete the Microprofile Config Value. Please check the server named " + this.sourceName + " is in your domain");
                    }
                    break;
                }
                case "application": {
                    if (this.sourceName == null) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "sourceName is a required parameter and the name of the application if application is the source");
                        break;
                    }
                    ApplicationConfigSource csource = new ApplicationConfigSource(this.sourceName);
                    if (!csource.deleteValue(this.propertyName)) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "Failed to delete the Microprofile Config Value. Please check the application named " + this.sourceName + " is in your domain");
                    }
                    break;
                }
                case "module": {
                    if (this.sourceName == null || this.moduleName == null) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "sourceName and moduleName are required parameters if module is the source. The sourceName should be the name of the application where the module is deployed.");
                        break;
                    }
                    ModuleConfigSource csource = new ModuleConfigSource(this.sourceName, this.moduleName);
                    if (!csource.deleteValue(this.propertyName)) {
                        context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getName()), "Failed to delete the Microprofile Config Value. Please check the application named " + this.sourceName + " with the module " + this.moduleName + " is in your domain");
                    }
                    break;
                }
                case "cluster": {
                    ClusterConfigSource csource = new ClusterConfigSource();
                    csource.deleteValue(this.propertyName);
                    break;
                }
                case "jndi": {
                    JNDIConfigSource jsource = new JNDIConfigSource();
                    jsource.deleteValue(this.propertyName, this.target);
                    break;
                }
                case "cloud": {
                    Set<ExtensionConfigSource> extensionSources = this.extensionService.getExtensionSources();
                    for (ExtensionConfigSource extension : extensionSources) {
                        if (!extension.getName().equals(this.sourceName)) continue;
                        extension.deleteValue(this.propertyName);
                    }
                    break;
                }
            }
        }
        catch (TransactionFailure txFailure) {
            context.getActionReport().failure(Logger.getLogger(SetConfigProperty.class.getCanonicalName()), "Failed to set config property", (Throwable)txFailure);
        }
    }
}

