/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.stream.Stream;
import org.glassfish.hk2.classmodel.reflect.util.ResourceLocator;

class ClassloaderResourceLocatorAdapter
implements ResourceLocator {
    private static String[] BLACKLIST = new String[]{"java/", "com/sun"};
    private ClassLoader delegate;

    ClassloaderResourceLocatorAdapter(ClassLoader delegate) {
        this.delegate = delegate;
    }

    public InputStream openResourceStream(String name) throws IOException {
        return ClassloaderResourceLocatorAdapter.isAllowed(name) ? this.delegate.getResourceAsStream(name) : null;
    }

    public URL getResource(String name) {
        return ClassloaderResourceLocatorAdapter.isAllowed(name) ? this.delegate.getResource(name) : null;
    }

    private static boolean isAllowed(String name) {
        return Stream.of(BLACKLIST).noneMatch(p -> name.startsWith((String)p));
    }
}

