/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.v3.admin.commands.ClassReporter;
import com.sun.enterprise.v3.admin.commands.LogReporter;
import com.sun.enterprise.v3.admin.commands.MemoryReporter;
import com.sun.enterprise.v3.admin.commands.SummaryReporter;
import com.sun.enterprise.v3.admin.commands.ThreadMonitor;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="generate-jvm-report")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="generate.jvm.report")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.DEPLOYMENT_GROUP})
@ExecuteOn(value={RuntimeType.INSTANCE}, ifNeverStarted=FailurePolicy.Error)
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.GET, path="generate-jvm-report", description="Generate Report", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.GET, path="generate-jvm-report", description="Generate Report", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.GET, path="generate-jvm-report", description="Generate Report", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=JavaConfig.class, opType=RestEndpoint.OpType.GET, path="generate-jvm-report", description="Generate Report", params={@RestParam(name="target", value="$grandparent")})})
@AccessRequired(resource={"domain/jvm"}, action={"read"})
public class GenerateJvmReportCommand
implements AdminCommand {
    @Param(name="target", optional=true)
    String target;
    @Param(name="type", optional=true, defaultValue="summary", acceptableValues="summary, thread, class, memory, log")
    String type;
    private MBeanServer mbs = null;

    @Override
    public void execute(AdminCommandContext ctx) {
        this.prepare();
        String result = this.getResult();
        ActionReport report = ctx.getActionReport();
        report.setMessage(result);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private synchronized void prepare() {
        this.mbs = ManagementFactory.getPlatformMBeanServer();
    }

    private String getResult() {
        if (this.type.equals("summary")) {
            return new SummaryReporter(this.mbs).getSummaryReport();
        }
        if (this.type.equals("thread")) {
            return new ThreadMonitor(this.mbs).getThreadDump();
        }
        if (this.type.equals("class")) {
            return new ClassReporter(this.mbs).getClassReport();
        }
        if (this.type.equals("memory")) {
            return new MemoryReporter(this.mbs).getMemoryReport();
        }
        if (this.type.equals("log")) {
            return new LogReporter().getLoggingReport();
        }
        throw new IllegalArgumentException("Unsupported Option: " + this.type);
    }
}

