/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.admin.remote.AdminCommandStateImpl;
import com.sun.enterprise.v3.admin.CheckpointHelper;
import com.sun.enterprise.v3.admin.JobManagerService;
import com.sun.enterprise.v3.admin.JobPersistenceService;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobPersistence;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.services.common.SubjectUtil;

public class AdminCommandInstanceImpl
extends AdminCommandStateImpl
implements Job {
    private static final long serialVersionUID = 1L;
    private CommandProgress commandProgress;
    private transient Payload.Outbound payload;
    private transient AdminCommandEventBroker broker = new AdminCommandEventBrokerImpl();
    private final long executionDate = new Date().getTime();
    private final String commandName;
    private List<String> subjectUsernames;
    private final String scope;
    private boolean isManagedJob;
    private File jobsFile;
    private long completionDate;
    private ParameterMap parameters;
    private boolean failToRetryable;

    protected AdminCommandInstanceImpl(String id, String name, String commandScope, Subject sub, boolean managedJob, ParameterMap parameters) {
        super(id);
        this.commandName = name;
        this.scope = commandScope;
        this.isManagedJob = managedJob;
        this.subjectUsernames = SubjectUtil.getUsernamesFromSubject((Subject)sub);
        this.parameters = parameters;
    }

    protected AdminCommandInstanceImpl(String name, String scope, Subject sub, boolean managedJob, ParameterMap parameters) {
        this(null, name, scope, sub, managedJob, parameters);
    }

    @Override
    public CommandProgress getCommandProgress() {
        return this.commandProgress;
    }

    @Override
    public void setCommandProgress(CommandProgress commandProgress) {
        this.commandProgress = commandProgress;
        commandProgress.setEventBroker(this.broker);
    }

    @Override
    public AdminCommandEventBroker getEventBroker() {
        return this.broker;
    }

    public void setEventBroker(AdminCommandEventBroker eventBroker) {
        this.broker = eventBroker;
    }

    @Override
    public File getJobsFile() {
        return this.jobsFile;
    }

    @Override
    public void setJobsFile(File jobsFile) {
        this.jobsFile = jobsFile;
    }

    @Override
    public List<String> getSubjectUsernames() {
        return this.subjectUsernames;
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    protected void setState(AdminCommandState.State state) {
        if (state != null && state != this.getState()) {
            super.setState(state);
            this.getEventBroker().fireEvent("AdminCommandInstance/stateChanged", this);
        }
    }

    @Override
    public boolean isOutboundPayloadEmpty() {
        return this.payload == null || this.payload.size() == 0;
    }

    @Override
    public void complete(ActionReport report, Payload.Outbound outbound) {
        if (this.commandProgress != null && report != null && report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            this.commandProgress.complete();
        }
        this.actionReport = report;
        this.payload = outbound;
        this.completionDate = System.currentTimeMillis();
        if (this.isManagedJob) {
            if (this.getState().equals((Object)AdminCommandState.State.RUNNING_RETRYABLE) && this.failToRetryable) {
                JobManagerService jobManager = (JobManagerService)Globals.getDefaultHabitat().getService(JobManagerService.class, new Annotation[0]);
                jobManager.getRetryableJobsInfo().put(this.id, CheckpointHelper.CheckpointFilename.createBasic(this));
                jobManager.purgeJob(this.id);
                this.setState(AdminCommandState.State.FAILED_RETRYABLE);
            } else {
                JobPersistence jobPersistenceService = this.scope != null ? (JobPersistence)Globals.getDefaultHabitat().getService(JobPersistence.class, this.scope + "job-persistence", new Annotation[0]) : (JobPersistence)Globals.getDefaultHabitat().getService(JobPersistenceService.class, new Annotation[0]);
                AdminCommandState.State finalState = AdminCommandState.State.COMPLETED;
                if (this.getState().equals((Object)AdminCommandState.State.REVERTING)) {
                    finalState = AdminCommandState.State.REVERTED;
                }
                String user = null;
                if (this.subjectUsernames.size() > 0) {
                    user = this.subjectUsernames.get(0);
                }
                jobPersistenceService.persist(new JobInfo(this.id, this.commandName, this.executionDate, report.getActionExitCode().name(), user, report.getMessage(), this.getJobsFile(), finalState.name(), this.completionDate));
                if (this.getState().equals((Object)AdminCommandState.State.RUNNING_RETRYABLE) || this.getState().equals((Object)AdminCommandState.State.REVERTING)) {
                    JobManagerService jobManager = (JobManagerService)Globals.getDefaultHabitat().getService(JobManagerService.class, new Annotation[0]);
                    File jobFile = this.getJobsFile();
                    if (jobFile == null) {
                        jobFile = jobManager.getJobsFile();
                    }
                    jobManager.deleteCheckpoint(jobFile.getParentFile(), this.getId());
                }
                this.setState(finalState);
            }
        } else {
            this.setState(AdminCommandState.State.COMPLETED);
        }
    }

    @Override
    public void revert() {
        this.setState(AdminCommandState.State.REVERTING);
    }

    @Override
    public long getCommandExecutionDate() {
        return this.executionDate;
    }

    @Override
    public Payload.Outbound getPayload() {
        return this.payload;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public long getCommandCompletionDate() {
        return this.completionDate;
    }

    @Override
    public void setFailToRetryable(boolean value) {
        this.failToRetryable = value;
    }

    @Override
    public ParameterMap getParameters() {
        return this.parameters;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.payload = null;
        this.broker = null;
    }
}

