/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.http.WebConnection;
import javax.websocket.server.ServerContainer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.wsadl.model.Application;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.servlet.TyrusServletWriter;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

class TyrusServletFilter
implements Filter,
HttpSessionListener {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletFilter.class.getName());
    private TyrusWebSocketEngine engine;
    private final boolean wsadlEnabled;
    private final Map<HttpSession, TyrusHttpUpgradeHandler> sessionToHandler = new ConcurrentHashMap<HttpSession, TyrusHttpUpgradeHandler>();
    private TyrusServerContainer serverContainer = null;
    private JAXBContext wsadlJaxbContext;

    TyrusServletFilter(TyrusWebSocketEngine engine) {
        this(engine, false);
    }

    TyrusServletFilter(TyrusWebSocketEngine engine, boolean wsadlEnabled) {
        this.engine = engine;
        this.wsadlEnabled = wsadlEnabled;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.serverContainer = (TyrusServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
        try {
            this.serverContainer.start(servletContext.getContextPath(), 0);
        }
        catch (Exception e) {
            throw new ServletException("Web socket server initialization failed.", (Throwable)e);
        }
        finally {
            this.serverContainer.doneDeployment();
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        TyrusHttpUpgradeHandler upgradeHandler = this.sessionToHandler.get(se.getSession());
        if (upgradeHandler != null) {
            this.sessionToHandler.remove(se.getSession());
            upgradeHandler.sessionDestroyed();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        final HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String header = httpServletRequest.getHeader("Sec-WebSocket-Key");
        if (header != null) {
            LOGGER.fine("Setting up WebSocket protocol handler");
            TyrusHttpUpgradeHandlerProxy handler = new TyrusHttpUpgradeHandlerProxy();
            TyrusServletWriter webSocketConnection = new TyrusServletWriter(handler);
            RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(httpServletRequest.getRequestURI())).queryString(httpServletRequest.getQueryString()).httpSession((Object)httpServletRequest.getSession(false)).secure(httpServletRequest.isSecure()).userPrincipal(httpServletRequest.getUserPrincipal()).isUserInRoleDelegate(new RequestContext.Builder.IsUserInRoleDelegate(){

                public boolean isUserInRole(String role) {
                    return httpServletRequest.isUserInRole(role);
                }
            }).parameterMap(httpServletRequest.getParameterMap()).remoteAddr(httpServletRequest.getRemoteAddr()).build();
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration headerValues = httpServletRequest.getHeaders(name);
                while (headerValues.hasMoreElements()) {
                    List values = (List)requestContext.getHeaders().get(name);
                    if (values == null) {
                        requestContext.getHeaders().put(name, Utils.parseHeaderValue((String)((String)headerValues.nextElement()).trim()));
                        continue;
                    }
                    values.addAll(Utils.parseHeaderValue((String)((String)headerValues.nextElement()).trim()));
                }
            }
            TyrusUpgradeResponse tyrusUpgradeResponse = new TyrusUpgradeResponse();
            WebSocketEngine.UpgradeInfo upgradeInfo = this.engine.upgrade((UpgradeRequest)requestContext, (UpgradeResponse)tyrusUpgradeResponse);
            switch (upgradeInfo.getStatus()) {
                case HANDSHAKE_FAILED: {
                    this.appendTraceHeaders(httpServletResponse, tyrusUpgradeResponse);
                    httpServletResponse.sendError(tyrusUpgradeResponse.getStatus());
                    break;
                }
                case NOT_APPLICABLE: {
                    this.appendTraceHeaders(httpServletResponse, tyrusUpgradeResponse);
                    filterChain.doFilter(request, response);
                    break;
                }
                case SUCCESS: {
                    LOGGER.fine("Upgrading Servlet request");
                    handler.setHandler((TyrusHttpUpgradeHandler)httpServletRequest.upgrade(TyrusHttpUpgradeHandler.class));
                    String frameBufferSize = request.getServletContext().getInitParameter("org.glassfish.tyrus.servlet.incoming-buffer-size");
                    if (frameBufferSize != null) {
                        handler.setIncomingBufferSize(Integer.parseInt(frameBufferSize));
                    }
                    handler.preInit(upgradeInfo, webSocketConnection, httpServletRequest.getUserPrincipal() != null);
                    if (requestContext.getHttpSession() != null) {
                        this.sessionToHandler.put((HttpSession)requestContext.getHttpSession(), handler);
                    }
                    httpServletResponse.setStatus(tyrusUpgradeResponse.getStatus());
                    for (Map.Entry entry : tyrusUpgradeResponse.getHeaders().entrySet()) {
                        httpServletResponse.addHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
                    }
                    response.flushBuffer();
                    LOGGER.fine("Handshake Complete");
                }
            }
        } else {
            if (this.wsadlEnabled && ((HttpServletRequest)request).getMethod().equals("GET") && ((HttpServletRequest)request).getRequestURI().endsWith("application.wsadl")) {
                try {
                    this.getWsadlJaxbContext().createMarshaller().marshal((Object)this.engine.getWsadlApplication(), (java.io.Writer)response.getWriter());
                }
                catch (JAXBException e) {
                    throw new ServletException((Throwable)e);
                }
                ((HttpServletResponse)response).setStatus(200);
                response.setContentType("application/wsadl+xml");
                response.flushBuffer();
                return;
            }
            filterChain.doFilter(request, response);
        }
    }

    private void appendTraceHeaders(HttpServletResponse httpServletResponse, TyrusUpgradeResponse tyrusUpgradeResponse) {
        for (Map.Entry entry : tyrusUpgradeResponse.getHeaders().entrySet()) {
            if (!((String)entry.getKey()).contains("X-Tyrus-Tracing-")) continue;
            httpServletResponse.addHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
    }

    private synchronized JAXBContext getWsadlJaxbContext() throws JAXBException {
        if (this.wsadlJaxbContext == null) {
            this.wsadlJaxbContext = JAXBContext.newInstance((String)Application.class.getPackage().getName());
        }
        return this.wsadlJaxbContext;
    }

    public void destroy() {
        this.serverContainer.stop();
        this.engine.getApplicationEventListener().onApplicationDestroyed();
        this.serverContainer = null;
        this.engine = null;
    }

    private static class TyrusHttpUpgradeHandlerProxy
    extends TyrusHttpUpgradeHandler {
        private TyrusHttpUpgradeHandler handler;

        private TyrusHttpUpgradeHandlerProxy() {
        }

        @Override
        public void init(WebConnection wc) {
            this.handler.init(wc);
        }

        @Override
        public void onDataAvailable() {
            this.handler.onDataAvailable();
        }

        @Override
        public void onAllDataRead() {
            this.handler.onAllDataRead();
        }

        @Override
        public void onError(Throwable t) {
            this.handler.onError(t);
        }

        @Override
        public void destroy() {
            this.handler.destroy();
        }

        @Override
        public void sessionDestroyed() {
            this.handler.sessionDestroyed();
        }

        @Override
        public void preInit(WebSocketEngine.UpgradeInfo upgradeInfo, Writer writer, boolean authenticated) {
            this.handler.preInit(upgradeInfo, writer, authenticated);
        }

        @Override
        public void setIncomingBufferSize(int incomingBufferSize) {
            this.handler.setIncomingBufferSize(incomingBufferSize);
        }

        @Override
        WebConnection getWebConnection() {
            return this.handler.getWebConnection();
        }

        void setHandler(TyrusHttpUpgradeHandler handler) {
            this.handler = handler;
        }
    }
}

