/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.LicenseDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.SecurityPermission;
import javax.resource.spi.TransactionSupport;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=Connector.class)
public class ConnectorAnnotationHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorAnnotationHandler.class);

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        Class annotatedClass;
        ConnectorDescriptor desc;
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        Connector connector = (Connector)element.getAnnotation();
        ArrayList<Class<? extends Annotation>> list = new ArrayList<Class<? extends Annotation>>();
        list.add(this.getAnnotationType());
        if (aeHandler instanceof RarBundleContext) {
            RarBundleContext rarContext = (RarBundleContext)aeHandler;
            desc = rarContext.getDescriptor();
            annotatedClass = (Class)element.getAnnotatedElement();
            if (desc.getResourceAdapterClass().equals("")) {
                desc.addConnectorAnnotation(element);
                return this.getSuccessfulProcessedResult(list);
            }
            if (!ConnectorAnnotationHandler.isResourceAdapterClass(annotatedClass)) {
                desc.addConnectorAnnotation(element);
                return this.getSuccessfulProcessedResult(list);
            }
            if (!desc.getResourceAdapterClass().equals(annotatedClass.getName())) {
                desc.addConnectorAnnotation(element);
                return this.getSuccessfulProcessedResult(list);
            }
        } else {
            String logMessage = "Not a rar bundle context";
            return this.getFailureResult(element, logMessage, true);
        }
        ConnectorAnnotationHandler.processDescriptor(annotatedClass, connector, desc);
        desc.setValidConnectorAnnotationProcessed(true);
        return this.getSuccessfulProcessedResult(list);
    }

    public static void processDescriptor(Class annotatedClass, Connector connector, ConnectorDescriptor desc) {
        Class[] requiredInflowContexts;
        OutboundResourceAdapter ora;
        SecurityPermission[] perms;
        AuthenticationMechanism[] auths;
        if (desc.getDescription().equals("") && connector.description().length > 0) {
            desc.setDescription(ConnectorAnnotationHandler.convertStringArrayToStringBuilder(connector.description()));
        }
        if (desc.getDisplayName().equals("") && connector.displayName().length > 0) {
            desc.setDisplayName(ConnectorAnnotationHandler.convertStringArrayToStringBuilder(connector.displayName()));
        }
        if ((desc.getSmallIconUri() == null || desc.getSmallIconUri().equals("")) && connector.smallIcon().length > 0) {
            desc.setSmallIconUri(ConnectorAnnotationHandler.convertStringArrayToStringBuilder(connector.smallIcon()));
        }
        if ((desc.getLargeIconUri() == null || desc.getLargeIconUri().equals("")) && connector.largeIcon().length > 0) {
            desc.setLargeIconUri(ConnectorAnnotationHandler.convertStringArrayToStringBuilder(connector.largeIcon()));
        }
        if (desc.getVendorName().equals("") && !connector.vendorName().equals("")) {
            desc.setVendorName(connector.vendorName());
        }
        if (desc.getEisType().equals("") && !connector.eisType().equals("")) {
            desc.setEisType(connector.eisType());
        }
        if (desc.getVersion().equals("") && !connector.version().equals("")) {
            desc.setVersion(connector.version());
        }
        if (desc.getLicenseDescriptor() == null) {
            String[] licenseDescriptor = connector.licenseDescription();
            boolean licenseRequired = connector.licenseRequired();
            SecurityPermission[] ld = new LicenseDescriptor();
            ld.setDescription(ConnectorAnnotationHandler.convertStringArrayToStringBuilder(licenseDescriptor));
            ld.setLicenseRequired(licenseRequired);
            desc.setLicenseDescriptor((LicenseDescriptor)ld);
        }
        if ((auths = connector.authMechanisms()) != null && auths.length > 0) {
            for (AuthenticationMechanism auth : auths) {
                String authMechString = auth.authMechanism();
                int authMechInt = AuthMechanism.getAuthMechInt((String)authMechString);
                boolean ignore = false;
                OutboundResourceAdapter ora2 = ConnectorAnnotationHandler.getOutbound(desc);
                Set ddAuthMechanisms = ora2.getAuthMechanisms();
                for (Object o : ddAuthMechanisms) {
                    AuthMechanism ddAuthMechanism = (AuthMechanism)o;
                    if (!ddAuthMechanism.getAuthMechType().equals(auth.authMechanism())) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                String credentialInterfaceName = OutboundResourceAdapter.getCredentialInterfaceName((AuthenticationMechanism.CredentialInterface)auth.credentialInterface());
                String description = "";
                if (auth.description().length > 0) {
                    description = auth.description()[0];
                }
                AuthMechanism authM = new AuthMechanism(description, authMechInt, credentialInterfaceName);
                ora2.addAuthMechanism(authM);
            }
        }
        if ((perms = connector.securityPermissions()) != null && perms.length > 0) {
            for (SecurityPermission perm : perms) {
                boolean ignore = false;
                Set ddSecurityPermissions = desc.getSecurityPermissions();
                for (Object o : ddSecurityPermissions) {
                    com.sun.enterprise.deployment.SecurityPermission ddSecurityPermission = (com.sun.enterprise.deployment.SecurityPermission)o;
                    if (!ddSecurityPermission.getPermission().equals(perm.permissionSpec())) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                com.sun.enterprise.deployment.SecurityPermission sp = new com.sun.enterprise.deployment.SecurityPermission();
                sp.setPermission(perm.permissionSpec());
                String firstDesc = "";
                if (perm.description().length > 0) {
                    firstDesc = perm.description()[0];
                }
                sp.setDescription(firstDesc);
                desc.addSecurityPermission(sp);
            }
        }
        if (connector.reauthenticationSupport() && !(ora = ConnectorAnnotationHandler.getOutbound(desc)).isReauthenticationSupportSet()) {
            ora.setReauthenticationSupport(connector.reauthenticationSupport());
        }
        if (!connector.transactionSupport().equals((Object)TransactionSupport.TransactionSupportLevel.NoTransaction) && !(ora = ConnectorAnnotationHandler.getOutbound(desc)).isTransactionSupportSet()) {
            ora.setTransactionSupport(connector.transactionSupport().toString());
        }
        if ((requiredInflowContexts = connector.requiredWorkContexts()) != null) {
            for (Class ic : requiredInflowContexts) {
                desc.addRequiredWorkContext(ic.getName());
            }
        }
        if (desc.getResourceAdapterClass().equals("") && ConnectorAnnotationHandler.isResourceAdapterClass(annotatedClass)) {
            desc.setResourceAdapterClass(annotatedClass.getName());
        }
    }

    public static boolean isResourceAdapterClass(Class claz) {
        return ResourceAdapter.class.isAssignableFrom(claz);
    }

    public static String convertStringArrayToStringBuilder(String[] stringArray) {
        StringBuilder result = new StringBuilder();
        if (stringArray != null) {
            for (String string : stringArray) {
                result.append(string);
            }
        }
        return result.toString();
    }

    protected HandlerProcessingResult getSuccessfulProcessedResult(List<Class<? extends Annotation>> annotationTypes) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        for (Class<? extends Annotation> annotation : annotationTypes) {
            result.addResult(annotation, ResultType.PROCESSED);
        }
        return result;
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return null;
    }

    public static OutboundResourceAdapter getOutbound(ConnectorDescriptor desc) {
        if (!desc.getOutBoundDefined()) {
            desc.setOutboundResourceAdapter(new OutboundResourceAdapter());
        }
        return desc.getOutboundResourceAdapter();
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            this.logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

