/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.micro.services;

import com.sun.enterprise.util.Utility;
import fish.payara.cdi.jsr107.implementation.PayaraValueHolder;
import fish.payara.micro.data.InstanceDescriptor;
import fish.payara.micro.event.PayaraClusteredCDIEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PayaraClusteredCDIEventImpl
implements PayaraClusteredCDIEvent {
    private static final long serialVersionUID = 1L;
    private InstanceDescriptor id;
    private boolean loopBack = false;
    private PayaraValueHolder<?> payload;
    private Properties props;
    private PayaraValueHolder<Set<InvocationHandler>> qualifiersPayload;
    private transient Set<InvocationHandler> qualifiers;

    public PayaraClusteredCDIEventImpl(InstanceDescriptor id, Serializable payload) throws IOException {
        this.id = id;
        this.payload = new PayaraValueHolder((Object)payload);
    }

    public PayaraClusteredCDIEventImpl(InstanceDescriptor id) {
        this.id = id;
    }

    public InstanceDescriptor getInstanceDescriptor() {
        return this.id;
    }

    void setInstanceDescriptor(InstanceDescriptor localDescriptor) {
        this.id = localDescriptor;
    }

    public InstanceDescriptor getId() {
        return this.id;
    }

    public void setId(InstanceDescriptor id) {
        this.id = id;
    }

    public Serializable getPayload() throws IOException, ClassNotFoundException {
        if (this.payload != null) {
            return (Serializable)this.payload.getValue();
        }
        return null;
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public void setLoopBack(boolean loopBack) {
        this.loopBack = loopBack;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperty(String name, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(name, value);
    }

    public String getProperty(String name) {
        String result = null;
        if (this.props != null) {
            result = this.props.getProperty(name);
        }
        return result;
    }

    public String getProperty(String name, String defaultValue) {
        String result = null;
        if (this.props != null) {
            result = this.props.getProperty(name, defaultValue);
        }
        return result;
    }

    public Set<Annotation> getQualifiers() {
        if (this.qualifiers == null) {
            try {
                this.qualifiers = (Set)this.qualifiersPayload.getValue();
            }
            catch (IOException | ClassNotFoundException ex) {
                Logger.getLogger(PayaraClusteredCDIEventImpl.class.getName()).log(Level.INFO, "Unable to deserialize qualifiers received on the event ignoring...", ex);
            }
        }
        if (this.qualifiers != null) {
            HashSet<Annotation> result = new HashSet<Annotation>(this.qualifiers.size());
            for (InvocationHandler qualifier : this.qualifiers) {
                Method[] methods = Annotation.class.getMethods();
                Class annotationClazz = null;
                for (Method method : methods) {
                    if (!method.getName().equals("annotationType")) continue;
                    try {
                        annotationClazz = (Class)qualifier.invoke(null, method, new Object[0]);
                        result.add((Annotation)Proxy.newProxyInstance(Utility.getClassLoader(), new Class[]{annotationClazz}, qualifier));
                    }
                    catch (Throwable ex) {
                        Logger.getLogger(PayaraClusteredCDIEventImpl.class.getName()).log(Level.INFO, "Problem determining the qualifier type of an Event ignoring", ex);
                    }
                }
            }
            return result;
        }
        return Collections.emptySet();
    }

    public void addQualifiers(Set<Annotation> add) throws IOException {
        if (this.qualifiers == null) {
            this.qualifiers = new HashSet<InvocationHandler>(add.size());
        }
        for (Annotation annotation : add) {
            if (!Proxy.isProxyClass(annotation.getClass())) continue;
            InvocationHandler handler = Proxy.getInvocationHandler(annotation);
            this.qualifiers.add(handler);
        }
        this.qualifiersPayload = new PayaraValueHolder(this.qualifiers);
    }
}

