/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryDialog;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Frame;
import java.util.Properties;
import javax.jms.JMSException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ObjStoreConFactoryPropsDialog
extends ObjStoreConFactoryDialog {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private ObjStoreConFactoryCObj osConFactoryCObj;

    public ObjStoreConFactoryPropsDialog(Frame parent) {
        super(parent, acr.getString("A1301"), 81);
        this.setHelpId("connection_factory_prop");
    }

    @Override
    public void doOK() {
        String lookupName = this.lookupLabel.getText();
        if ((lookupName = lookupName.trim()) == null || lookupName.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3000"), acr.getString("A1301") + ": " + acr.getString("A1218", "A3000"), 0, 0, null, close, close[0]);
            return;
        }
        int type = 3;
        ConnectionFactory tempObj = null;
        if (this.cfLabel.getText().equals(acr.getString("A1203"))) {
            type = 3;
            tempObj = new QueueConnectionFactory();
        } else if (this.cfLabel.getText().equals(acr.getString("A1204"))) {
            type = 4;
            tempObj = new TopicConnectionFactory();
        } else if (this.cfLabel.getText().equals(acr.getString("A1235"))) {
            type = 7;
            tempObj = new ConnectionFactory();
        } else if (this.cfLabel.getText().equals(acr.getString("A1232"))) {
            type = 5;
            tempObj = new XAQueueConnectionFactory();
        } else if (this.cfLabel.getText().equals(acr.getString("A1233"))) {
            type = 6;
            tempObj = new XATopicConnectionFactory();
        } else if (this.cfLabel.getText().equals(acr.getString("A1234"))) {
            type = 8;
            tempObj = new XAConnectionFactory();
        }
        Properties props = tempObj.getConfiguration();
        String propType = null;
        String propLabel = null;
        for (int i = 0; i < this.cfProps.size(); ++i) {
            String propValue;
            LabelledComponent cfItem = (LabelledComponent)this.cfProps.elementAt(i);
            String propName = (String)cfItem.getClientData();
            if (propName == null) continue;
            if (!cfItem.getComponent().isEnabled()) {
                props.remove(propName);
                continue;
            }
            try {
                propType = tempObj.getPropertyType(propName);
                propLabel = tempObj.getPropertyLabel(propName);
            }
            catch (JMSException jmsex) {
                JOptionPane.showOptionDialog(this, jmsex.toString(), acr.getString("A1301"), 0, 0, null, close, close[0]);
                return;
            }
            if (propType == null || (propValue = this.getValue(cfItem.getComponent(), propType).trim()).equals("")) continue;
            try {
                tempObj.setProperty(propName, propValue.trim());
                props.put(propName, propValue.trim());
                continue;
            }
            catch (JMSException jmsex) {
                if (jmsex instanceof InvalidPropertyValueException) {
                    JOptionPane.showOptionDialog(this, acr.getString("A3016", propLabel), acr.getString("A1301") + ": " + acr.getString("A1218", "A3016"), 0, 0, null, close, close[0]);
                } else {
                    JOptionPane.showOptionDialog(this, jmsex.toString(), acr.getString("A1301"), 0, 0, null, close, close[0]);
                }
                return;
            }
        }
        ObjAdminEvent oae = new ObjAdminEvent(this, 7);
        ObjStore os = this.osConFactoryCObj.getObjStore();
        oae.setLookupName(lookupName);
        oae.setObjStore(os);
        oae.setFactoryType(type);
        oae.setObjProperties(props);
        if (this.checkBox.isSelected()) {
            oae.setReadOnly(true);
        } else {
            oae.setReadOnly(false);
        }
        oae.setOKAction(true);
        this.fireAdminEventDispatched(oae);
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
        this.hide();
    }

    @Override
    public void doClose() {
        this.hide();
    }

    @Override
    public void doClear() {
    }

    @Override
    public void show() {
    }

    public void show(ObjStoreConFactoryCObj osConFactoryCObj) {
        this.osConFactoryCObj = osConFactoryCObj;
        this.lookupLabel.setText(osConFactoryCObj.getLookupName());
        Object object = osConFactoryCObj.getObject();
        if (object instanceof XAQueueConnectionFactory) {
            this.cfLabel.setText(acr.getString("A1232"));
        } else if (object instanceof XATopicConnectionFactory) {
            this.cfLabel.setText(acr.getString("A1233"));
        } else if (object instanceof XAConnectionFactory) {
            this.cfLabel.setText(acr.getString("A1234"));
        } else if (object instanceof QueueConnectionFactory) {
            this.cfLabel.setText(acr.getString("A1203"));
        } else if (object instanceof TopicConnectionFactory) {
            this.cfLabel.setText(acr.getString("A1204"));
        } else if (object instanceof ConnectionFactory) {
            this.cfLabel.setText(acr.getString("A1235"));
        }
        String propName = null;
        String propType = null;
        String value = null;
        AdministeredObject adminObj = (AdministeredObject)object;
        for (int i = 0; i < this.cfProps.size(); ++i) {
            LabelledComponent cfItem = (LabelledComponent)this.cfProps.elementAt(i);
            JComponent comp = cfItem.getComponent();
            propName = (String)cfItem.getClientData();
            if (propName == null) continue;
            try {
                if (!comp.isEnabled()) continue;
                propType = adminObj.getPropertyType(propName);
                value = adminObj.getProperty(propName);
                this.setValue(comp, propType, value);
                if (!(comp instanceof JComboBox)) continue;
                this.doComboBox((JComboBox)comp);
                continue;
            }
            catch (Exception e) {
                System.err.println(e.toString() + ": " + propName);
            }
        }
        QueueConnectionFactory tempObj2 = new QueueConnectionFactory();
        this.setOtherValues(tempObj2, true);
        if (adminObj.isReadOnly()) {
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
        }
        this.tabbedPane.setSelectedIndex(0);
        super.show();
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

