/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl;
import com.sun.enterprise.security.provider.PolicyConfigurationImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.jacc.ContextProvider;
import fish.payara.jacc.JaccConfigurationFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import sun.net.www.ParseUtil;
import sun.security.util.PropertyExpander;

public class JDKPolicyFileWrapper
extends Policy {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDKPolicyFileWrapper.class);
    private static final String POLICY = "java.security.policy";
    private static final String POLICY_URL = "jdkPolicyFile.url.";
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private static final String FORCE_APP_REFRESH_PROP_NAME = "com.sun.enterprise.security.provider.PolicyWrapper.force_app_refresh";
    private static final boolean FORCE_APP_REFRESH = Boolean.getBoolean("com.sun.enterprise.security.provider.PolicyWrapper.force_app_refresh");
    private long refreshTime = 0L;
    private Policy jdkPolicyFile = this.getNewPolicy();
    private static final String REUSE = "java.security.Policy.supportsReuse";
    private static final String IGNORE_REENTRANCY_PROP_NAME = "com.sun.enterprise.security.provider.PolicyWrapper.ignoreReentrancy";
    private static final boolean AVOID_REENTRANCY;
    private static ThreadLocal<Object> reentrancyStatus;
    private static ThreadLocal<Boolean> contextProviderReentry;

    public JDKPolicyFileWrapper() {
        this.defaultContextChanged();
    }

    protected Policy getNewPolicy() {
        try {
            return Policy.getInstance("JavaPolicy", null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        String contextId = PolicyContext.getContextID();
        ContextProvider contextProvider = this.getContextProvider(contextId, this.getPolicyFactory());
        if (contextProvider != null) {
            if (contextProviderReentry.get().booleanValue()) {
                return Policy.UNSUPPORTED_EMPTY_COLLECTION;
            }
            contextProviderReentry.set(true);
            try {
                PermissionCollection permissionCollection = contextProvider.getPolicy().getPermissions(codesource);
                return permissionCollection;
            }
            finally {
                contextProviderReentry.set(false);
            }
        }
        PolicyConfigurationImpl policyConfiguration = this.getPolicyConfigForContext(contextId);
        PermissionCollection permissions = this.getPolicy(policyConfiguration).getPermissions(codesource);
        if (permissions != null) {
            permissions = JDKPolicyFileWrapper.removeExcludedPermissions(policyConfiguration, permissions);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: PolicyWrapper.getPermissions(cs), context (" + contextId + ")  codesource (" + codesource + ") permissions: " + permissions);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        String contextId = PolicyContext.getContextID();
        ContextProvider contextProvider = this.getContextProvider(contextId, this.getPolicyFactory());
        if (contextProvider != null) {
            if (contextProviderReentry.get().booleanValue()) {
                return Policy.UNSUPPORTED_EMPTY_COLLECTION;
            }
            contextProviderReentry.set(true);
            try {
                PermissionCollection permissionCollection = contextProvider.getPolicy().getPermissions(domain);
                return permissionCollection;
            }
            finally {
                contextProviderReentry.set(false);
            }
        }
        PolicyConfigurationImpl policyConfiguration = this.getPolicyConfigForContext(contextId);
        PermissionCollection permissions = this.getPolicy(policyConfiguration).getPermissions(domain);
        if (permissions != null) {
            permissions = JDKPolicyFileWrapper.removeExcludedPermissions(policyConfiguration, permissions);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: PolicyWrapper.getPermissions(d), context (" + contextId + ") permissions: " + permissions);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (AVOID_REENTRANCY) {
            byte[] alreadyCalled = (byte[])reentrancyStatus.get();
            if (alreadyCalled[0] == 1) {
                return true;
            }
            alreadyCalled[0] = 1;
            try {
                boolean bl = this.doImplies(domain, permission);
                return bl;
            }
            finally {
                alreadyCalled[0] = 0;
            }
        }
        return this.doImplies(domain, permission);
    }

    @Override
    public void refresh() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Refreshing Policy files!");
        }
        this.jdkPolicyFile.refresh();
        boolean force = this.defaultContextChanged();
        List<PolicyConfigurationImpl> policyConfigurations = null;
        PolicyConfigurationFactoryImpl policyFactory = this.getPolicyFactory();
        if (policyFactory != null) {
            policyConfigurations = policyFactory.getPolicyConfigurationImpls();
        }
        if (policyConfigurations != null) {
            for (PolicyConfigurationImpl policyConfig : policyConfigurations) {
                if (policyConfig == null) continue;
                policyConfig.refresh(force);
            }
        }
        try {
            if (PolicyContext.getHandlerKeys().contains(REUSE)) {
                PolicyContext.getContext(REUSE);
            }
        }
        catch (PolicyContextException pe) {
            throw new IllegalStateException(pe.toString());
        }
    }

    private PolicyConfigurationImpl getPolicyConfigForContext(String contextId) {
        PolicyConfigurationImpl policyConfiguration = null;
        PolicyConfigurationFactoryImpl policyConfigurationFactory = this.getPolicyFactory();
        if (contextId != null && policyConfigurationFactory != null && (policyConfiguration = policyConfigurationFactory.getPolicyConfigurationImpl(contextId)) == null) {
            JDKPolicyFileWrapper.logMsg(Level.WARNING, "pc.unknown_policy_context", contextId);
        }
        return policyConfiguration;
    }

    private ContextProvider getContextProvider(String contextId, JaccConfigurationFactory configurationFactory) {
        if (configurationFactory != null && contextId != null) {
            return configurationFactory.getContextProviderByPolicyContextId(contextId);
        }
        return null;
    }

    private Policy getPolicy(PolicyConfigurationImpl policyConfiguration) {
        if (policyConfiguration == null) {
            return this.jdkPolicyFile;
        }
        Policy policyFromConfig = policyConfiguration.getPolicy();
        if (policyFromConfig == null) {
            return this.jdkPolicyFile;
        }
        return policyFromConfig;
    }

    private static Permissions getExcludedPolicy(PolicyConfigurationImpl policyConfiguration) {
        if (policyConfiguration != null) {
            return policyConfiguration.getExcludedPolicy();
        }
        return null;
    }

    private static PermissionCollection removeExcludedPermissions(PolicyConfigurationImpl policyConfiguration, PermissionCollection permissions) {
        PermissionCollection permissionsWithoutExcluded = permissions;
        Permissions excluded = JDKPolicyFileWrapper.getExcludedPolicy(policyConfiguration);
        if (excluded != null && excluded.elements().hasMoreElements()) {
            permissionsWithoutExcluded = null;
            boolean noneRemoved = true;
            for (Permission granted : Collections.list(permissions.elements())) {
                if (!JDKPolicyFileWrapper.grantedIsExcluded(granted, excluded)) {
                    if (permissionsWithoutExcluded == null) {
                        permissionsWithoutExcluded = new Permissions();
                    }
                    permissionsWithoutExcluded.add(granted);
                    continue;
                }
                noneRemoved = false;
            }
            if (noneRemoved) {
                permissionsWithoutExcluded = permissions;
            }
        }
        return permissionsWithoutExcluded;
    }

    private static boolean grantedIsExcluded(Permission granted, Permissions excluded) {
        boolean isExcluded = false;
        if (excluded != null) {
            if (!excluded.implies(granted)) {
                Enumeration<Permission> excludedPermissions = excluded.elements();
                while (!isExcluded && excludedPermissions.hasMoreElements()) {
                    Permission excludedPermission = excludedPermissions.nextElement();
                    if (!granted.implies(excludedPermission)) continue;
                    isExcluded = true;
                }
            } else {
                isExcluded = true;
            }
        }
        if (logger.isLoggable(Level.FINEST) && isExcluded) {
            logger.finest("JACC Policy Provider: permission is excluded: " + granted);
        }
        return isExcluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImplies(ProtectionDomain domain, Permission permission) {
        ContextProvider contextProvider;
        String contextId = PolicyContext.getContextID();
        if (contextId != null && (contextProvider = this.getContextProvider(contextId, this.getPolicyFactory())) != null) {
            if (contextProviderReentry.get().booleanValue()) {
                return false;
            }
            contextProviderReentry.set(true);
            try {
                boolean bl = contextProvider.getPolicy().implies(domain, permission);
                return bl;
            }
            finally {
                contextProviderReentry.set(false);
            }
        }
        PolicyConfigurationImpl policyConfiguration = this.getPolicyConfigForContext(contextId);
        boolean doesImplies = this.getPolicy(policyConfiguration).implies(domain, permission);
        if (!doesImplies) {
            this.logImpliesFailure(permission, contextId, domain);
        } else {
            Permissions excluded = JDKPolicyFileWrapper.getExcludedPolicy(policyConfiguration);
            if (excluded != null) {
                boolean bl = doesImplies = !JDKPolicyFileWrapper.grantedIsExcluded(permission, excluded);
            }
        }
        if (!doesImplies && logger.isLoggable(Level.FINEST)) {
            this.logDenies(permission, contextId);
        }
        return doesImplies;
    }

    private void logImpliesFailure(final Permission permission, final String contextId, final ProtectionDomain domain) {
        if (!(permission instanceof WebResourcePermission || permission instanceof MBeanPermission || permission instanceof WebRoleRefPermission || permission instanceof EJBRoleRefPermission)) {
            if (logger.isLoggable(Level.FINE)) {
                Exception ex = new Exception();
                ex.fillInStackTrace();
                logger.log(Level.FINE, "JACC Policy Provider, failed Permission Check at :", ex);
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    logger.info("JACC Policy Provider: Failed Permission Check, context(" + contextId + ")- permission(" + permission + ")");
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Domain that failed(" + domain + ")");
                    }
                    return null;
                }
            });
        }
    }

    private void logDenies(Permission permission, String contextId) {
        logger.log(Level.FINEST, () -> "JACC Policy Provider: PolicyWrapper.implies, context (" + contextId + ")-result was(false) permission (" + permission + ")");
    }

    synchronized boolean defaultContextChanged() {
        if (FORCE_APP_REFRESH) {
            return true;
        }
        long newTime = JDKPolicyFileWrapper.getTimeStamp(POLICY, POLICY_URL) + JDKPolicyFileWrapper.getTimeStamp(AUTH_POLICY, AUTH_POLICY_URL);
        boolean isDefaultContextChanged = this.refreshTime != newTime;
        this.refreshTime = newTime;
        return isDefaultContextChanged;
    }

    private static long getTimeStamp(final String propertyName, final String urlName) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                String extraPolicy;
                long sum = 0L;
                if (JDKPolicyFileWrapper.allowSystemProperties() && (extraPolicy = System.getProperty(propertyName)) != null) {
                    boolean overrideAll = false;
                    if (extraPolicy.startsWith("=")) {
                        overrideAll = true;
                        extraPolicy = extraPolicy.substring(1);
                    }
                    sum += JDKPolicyFileWrapper.getLastModifiedFromPolicyProperty(extraPolicy);
                    if (overrideAll) {
                        return sum;
                    }
                }
                return sum += JDKPolicyFileWrapper.getLastModifiedFromUrlNames(urlName);
            }
        });
    }

    private static boolean allowSystemProperties() {
        return "true".equalsIgnoreCase(Security.getProperty("jdkPolicyFile.allowSystemProperty"));
    }

    private static long getLastModifiedFromUrlNames(String urlName) {
        String policyUri;
        long sum = 0L;
        int n = 1;
        while ((policyUri = Security.getProperty(urlName + n)) != null) {
            try {
                URL policyUrl = JDKPolicyFileWrapper.getPolicyUrl(policyUri);
                if ("file".equals(policyUrl.getProtocol())) {
                    String path = policyUrl.getFile().replace('/', File.separatorChar);
                    File policyFile = new File(path = ParseUtil.decode(path));
                    if (policyFile.exists()) {
                        sum += policyFile.lastModified();
                        JDKPolicyFileWrapper.logMsg(Level.FINE, "pc.file_refreshed", path);
                    } else {
                        JDKPolicyFileWrapper.logMsg(Level.FINE, "pc.file_not_refreshed", path);
                    }
                } else {
                    JDKPolicyFileWrapper.logMsg(Level.FINE, "pc.file_not_refreshed", policyUrl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return sum;
    }

    private static long getLastModifiedFromPolicyProperty(String extraPolicy) {
        try {
            URL policyUrl;
            String path = PropertyExpander.expand(extraPolicy);
            File policyFile = new File(path);
            boolean found = policyFile.exists();
            if (!found && "file".equals((policyUrl = new URL(path)).getProtocol())) {
                path = policyUrl.getFile().replace('/', File.separatorChar);
                path = ParseUtil.decode(path);
                policyFile = new File(path);
                found = policyFile.exists();
            }
            return JDKPolicyFileWrapper.getLastModifiedTime(found, policyFile, path);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private static long getLastModifiedTime(boolean found, File policyFile, String path) {
        if (!found) {
            JDKPolicyFileWrapper.logMsg(Level.FINE, "pc.file_not_refreshed", path);
            return 0L;
        }
        JDKPolicyFileWrapper.logMsg(Level.FINE, "pc.file_refreshed", path);
        return policyFile.lastModified();
    }

    private static URL getPolicyUrl(String policyUri) throws MalformedURLException, PropertyExpander.ExpandException, URISyntaxException {
        String expandedUri = PropertyExpander.expand(policyUri).replace(File.separatorChar, '/');
        if (policyUri.startsWith("file:${java.home}/") || policyUri.startsWith("file:${user.home}/")) {
            return new File(expandedUri.substring(5)).toURI().toURL();
        }
        return new URI(expandedUri).toURL();
    }

    private PolicyConfigurationFactoryImpl getPolicyFactory() {
        return PolicyConfigurationFactoryImpl.getInstance();
    }

    private static void logMsg(Level level, String key, Object ... params) {
        if (!logger.isLoggable(level)) {
            return;
        }
        JDKPolicyFileWrapper.logMsg(level, key, params, null);
    }

    private static String logMsg(Level level, String key, Object[] params, String defMsg) {
        String defaultFormat = defMsg == null ? key : defMsg;
        String msg = key == null ? defMsg : localStrings.getLocalString(key, defaultFormat, params);
        logger.log(level, msg);
        return msg;
    }

    static {
        boolean bl = AVOID_REENTRANCY = !Boolean.getBoolean(IGNORE_REENTRANCY_PROP_NAME) && System.getSecurityManager() != null;
        if (AVOID_REENTRANCY) {
            reentrancyStatus = new ThreadLocal<Object>(){

                @Override
                protected synchronized Object initialValue() {
                    return new byte[]{0};
                }
            };
        }
        contextProviderReentry = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }
}

