/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.MinutesDataset;
import fish.payara.monitoring.model.Series;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SeriesDataset
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger("monitoring-console-core");
    private final Series series;
    private final String instance;
    private final long observedSince;
    private final int observedValues;

    static MinutesDataset aggregate(SeriesDataset predecessor, SeriesDataset successor, boolean aggregate) {
        try {
            return aggregate ? predecessor.getRecentMinutes().add(successor) : MinutesDataset.EMPTY;
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.WARNING, "Failed to compute aggreagte: ", ex);
            return predecessor.getRecentMinutes();
        }
    }

    public SeriesDataset(SeriesDataset predecessor) {
        this.series = predecessor.series;
        this.instance = predecessor.instance;
        this.observedSince = predecessor.observedSince;
        this.observedValues = predecessor.observedValues + 1;
    }

    public SeriesDataset(Series series, String instance, long observedSince, int observedValues) {
        this.series = series;
        this.instance = instance;
        this.observedSince = observedSince;
        this.observedValues = observedValues;
    }

    public final Series getSeries() {
        return this.series;
    }

    public String getInstance() {
        return this.instance;
    }

    public final BigInteger getObservedAvg() {
        return this.observedValues == 0 ? BigInteger.ZERO : this.getObservedSum().divide(BigInteger.valueOf(this.observedValues));
    }

    public long getObservedSince() {
        return this.observedSince;
    }

    public final int getObservedValues() {
        return this.observedValues;
    }

    public abstract int getObservedValueChanges();

    public abstract long[] points();

    public final SeriesDataset add(long time, long value) {
        return this.add(time, value, false);
    }

    public abstract SeriesDataset add(long var1, long var3, boolean var5);

    public abstract MinutesDataset getRecentMinutes();

    public abstract long getObservedMin();

    public abstract long getObservedMax();

    public abstract BigInteger getObservedSum();

    public abstract long getStableSince();

    public abstract int getStableCount();

    public abstract boolean isOutdated();

    public abstract int size();

    public abstract long lastValue();

    public abstract long firstTime();

    public abstract long lastTime();

    public abstract int capacity();

    public abstract int estimatedBytesMemory();

    public boolean isStable() {
        return true;
    }

    public final boolean isStableZero() {
        return this.isStable() && this.lastValue() == 0L;
    }

    public final boolean endsWithLastSecondOfMinute() {
        return this.lastTime() % 60000L >= 59000L;
    }

    public final String toString() {
        StringBuilder str = new StringBuilder();
        long[] points = this.points();
        str.append(this.getSeries()).append('@').append(this.getInstance());
        str.append("[\n");
        for (int i = 0; i < points.length; i += 2) {
            str.append('\t').append(points[i]).append('@').append(points[i + 1]).append('\n');
        }
        str.append(']');
        return str.toString();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SeriesDataset)) {
            return false;
        }
        SeriesDataset other = (SeriesDataset)obj;
        return this.instance.equals(other.instance) && this.series.equals(other.series);
    }

    public final int hashCode() {
        return this.instance.hashCode() ^ this.series.hashCode();
    }

    public static long[] perSecond(long[] points) {
        long[] perSec = new long[points.length - 2];
        for (int i = 0; i < perSec.length; i += 2) {
            perSec[i] = points[i + 2];
            long deltaTime = points[i + 2] - points[i];
            long deltaValue = points[i + 3] - points[i + 1];
            perSec[i + 1] = deltaTime == 1000L ? deltaValue : (deltaTime % 1000L == 0L ? deltaValue / (deltaTime / 1000L) : Math.round((double)deltaValue / (double)deltaTime * 1000.0));
        }
        return perSec;
    }
}

