/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.EmptyDataset;
import fish.payara.monitoring.model.MinutesDataset;
import fish.payara.monitoring.model.PartialDataset;
import fish.payara.monitoring.model.SeriesDataset;
import java.math.BigInteger;

public class ConstantDataset
extends SeriesDataset {
    private final long stableSince;
    private final long time;
    private final long value;
    private final int capacity;
    private final MinutesDataset recentMinute;

    public ConstantDataset(SeriesDataset predecessor, long time, boolean aggregate) {
        super(predecessor);
        this.capacity = predecessor.capacity();
        this.stableSince = predecessor.getStableSince();
        this.time = time;
        this.value = predecessor.lastValue();
        this.recentMinute = ConstantDataset.aggregate(predecessor, this, aggregate);
    }

    public ConstantDataset(EmptyDataset predecessor, long time, long value, boolean aggregate) {
        super(predecessor.getSeries(), predecessor.getInstance(), time, 1);
        this.capacity = predecessor.capacity();
        this.stableSince = time;
        this.time = time;
        this.value = value;
        this.recentMinute = ConstantDataset.aggregate(predecessor, this, aggregate);
    }

    @Override
    public long[] points() {
        long[] lArray;
        if (this.size() == 1) {
            long[] lArray2 = new long[2];
            lArray2[0] = this.stableSince;
            lArray = lArray2;
            lArray2[1] = this.value;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = this.stableSince;
            lArray3[1] = this.value;
            lArray3[2] = this.time;
            lArray = lArray3;
            lArray3[3] = this.value;
        }
        return lArray;
    }

    @Override
    public SeriesDataset add(long time, long value, boolean aggregate) {
        if (time == this.lastTime()) {
            return new PartialDataset(this, time, value + this.lastValue(), aggregate);
        }
        return value == this.lastValue() ? new ConstantDataset(this, time, aggregate) : new PartialDataset(this, time, value, aggregate);
    }

    @Override
    public final MinutesDataset getRecentMinutes() {
        return this.recentMinute;
    }

    @Override
    public long getObservedMin() {
        return this.value;
    }

    @Override
    public long getObservedMax() {
        return this.value;
    }

    @Override
    public BigInteger getObservedSum() {
        return BigInteger.valueOf(this.getObservedValues()).multiply(BigInteger.valueOf(this.value));
    }

    @Override
    public int getObservedValueChanges() {
        return 1;
    }

    @Override
    public long getStableSince() {
        return this.stableSince;
    }

    @Override
    public int getStableCount() {
        return this.getObservedValues();
    }

    @Override
    public final boolean isOutdated() {
        return false;
    }

    @Override
    public final int size() {
        return this.stableSince == this.time ? 1 : 2;
    }

    @Override
    public final long firstTime() {
        return this.stableSince;
    }

    @Override
    public final long lastTime() {
        return this.time;
    }

    @Override
    public final long lastValue() {
        return this.value;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public int estimatedBytesMemory() {
        return 64 + this.recentMinute.estimatedBytesMemory();
    }
}

