/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ClassPathBuilder;
import com.sun.enterprise.admin.cli.optional.DBManager;
import com.sun.enterprise.admin.cli.optional.H2Manager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.util.ArrayList;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class DatabaseCommand
extends CLICommand {
    private static final String DB_HOST_DEFAULT = "0.0.0.0";
    private static final String DB_PORT_DEFAULT = "9092";
    protected static final String DB_USER = "dbuser";
    @Param(name="dbhost", optional=true, defaultValue="0.0.0.0")
    protected String dbHost;
    @Param(name="dbport", optional=true)
    protected String dbPort;
    protected File dbLocation;
    protected File sJavaHome;
    protected File sInstallRoot;
    protected final ClassPathBuilder sClasspath = new ClassPathBuilder();
    protected final ClassPathBuilder sDatabaseClasspath = new ClassPathBuilder();
    private static final LocalStringsImpl strings = new LocalStringsImpl(DatabaseCommand.class);
    protected DBManager dbManager;

    protected void prepareProcessExecutor() throws Exception {
        this.sInstallRoot = new File(this.getSystemProperty("com.sun.aas.installRoot"));
        if (this.dbHost == null) {
            this.dbHost = DB_HOST_DEFAULT;
        }
        if (this.dbPort == null) {
            this.dbPort = DB_PORT_DEFAULT;
        } else {
            this.checkIfPortIsValid(this.dbPort);
        }
        this.sJavaHome = new File(this.getSystemProperty("com.sun.aas.javaRoot"));
        this.dbManager = new H2Manager();
        this.dbLocation = new File(this.getSystemProperty(this.dbManager.getRootProperty()));
        try {
            this.dbManager.checkIfDbInstalled(this.dbLocation);
        }
        catch (CommandException ce) {
            logger.info(strings.get("DatabaseNotInstalled", this.dbLocation));
            throw ce;
        }
        this.sClasspath.add(new File(this.sInstallRoot, "lib/asadmin/cli-optional.jar"));
        this.dbManager.buildDatabaseClasspath(this.dbLocation, this.sDatabaseClasspath);
    }

    private void checkIfPortIsValid(String port) throws CommandValidationException {
        try {
            Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new CommandValidationException(strings.get("InvalidPortNumber", port));
        }
    }

    protected String[] pingDatabaseCmd(boolean bRedirect) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaExe().toString());
        cmd.add("-Djava.library.path=" + this.sInstallRoot + File.separator + "lib");
        cmd.addAll(this.dbManager.getSystemProperty());
        cmd.add("-cp");
        cmd.add(this.sClasspath + File.pathSeparator + this.sDatabaseClasspath);
        cmd.add(this.dbManager.getDBControl().getName());
        cmd.add("ping");
        cmd.add(this.dbHost);
        cmd.add(this.dbPort);
        cmd.add(Boolean.toString(bRedirect));
        return cmd.toArray(new String[cmd.size()]);
    }

    protected final File getJavaExe() {
        return new File(new File(this.sJavaHome, "bin"), "java");
    }
}

