/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.cluster;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import fish.payara.nucleus.cluster.ClusterListener;
import fish.payara.nucleus.cluster.MemberEvent;
import fish.payara.nucleus.eventbus.EventBus;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.exec.ClusterExecutionService;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.store.ClusteredStore;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-cluster")
@RunLevel(value=10)
public class PayaraCluster
implements MembershipListener,
EventListener {
    private static final Logger logger = Logger.getLogger(PayaraCluster.class.getCanonicalName());
    @Inject
    Events events;
    @Inject
    private HazelcastCore hzCore;
    @Inject
    private ClusterExecutionService execService;
    @Inject
    private ClusteredStore clusteredStore;
    @Inject
    private EventBus eventBus;
    private Set<ClusterListener> myListeners;
    private UUID localUUID;

    public boolean isEnabled() {
        return this.hzCore.isEnabled();
    }

    public ClusterExecutionService getExecService() {
        return this.execService;
    }

    public HazelcastCore getUnderlyingHazelcastService() {
        return this.hzCore;
    }

    public ClusteredStore getClusteredStore() {
        return this.clusteredStore;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void memberAdded(MembershipEvent me) {
        for (ClusterListener myListener : this.myListeners) {
            myListener.memberAdded(new MemberEvent(this.hzCore, me.getMember()));
        }
        logger.log(Level.INFO, "Data Grid Instance Added {0} at Address {1}", new String[]{me.getMember().getUuid().toString(), me.getMember().getSocketAddress().toString()});
        this.logClusterStatus();
    }

    public void memberRemoved(MembershipEvent me) {
        for (ClusterListener myListener : this.myListeners) {
            myListener.memberRemoved(new MemberEvent(this.hzCore, me.getMember()));
        }
        logger.log(Level.INFO, "Data Grid Instance Removed {0} from Address {1}", new String[]{me.getMember().getUuid().toString(), me.getMember().getSocketAddress().toString()});
        this.logClusterStatus();
    }

    public UUID getLocalUUID() {
        return this.localUUID;
    }

    public void removeClusterListener(ClusterListener listener) {
        this.myListeners.remove(listener);
    }

    public void addClusterListener(ClusterListener listener) {
        this.myListeners.add(listener);
    }

    public Set<UUID> getClusterMembers() {
        HashSet<UUID> result = new HashSet<UUID>(5);
        if (this.hzCore.isEnabled()) {
            Set members = this.hzCore.getInstance().getCluster().getMembers();
            for (Member member : members) {
                result.add(member.getUuid());
            }
        }
        return result;
    }

    public String getMemberName(UUID memberUUID) {
        String result = null;
        if (this.hzCore.isEnabled()) {
            Set members = this.hzCore.getInstance().getCluster().getMembers();
            for (Member member : members) {
                if (!member.getUuid().equals(memberUUID)) continue;
                result = this.hzCore.getAttribute(member.getUuid(), "GLASSFISH-INSTANCE");
            }
        }
        return result;
    }

    public String getMemberGroup(UUID memberUUID) {
        String result = null;
        if (this.hzCore.isEnabled()) {
            Set members = this.hzCore.getInstance().getCluster().getMembers();
            for (Member member : members) {
                if (!member.getUuid().equals(memberUUID)) continue;
                result = member.getAttribute("GLASSFISH_INSTANCE_GROUP");
            }
        }
        return result;
    }

    public Set<String> getMemberNames() {
        HashSet<String> result = new HashSet<String>(5);
        if (this.hzCore.isEnabled()) {
            Set members = this.hzCore.getInstance().getCluster().getMembers();
            for (Member member : members) {
                String memberName = this.hzCore.getAttribute(member.getUuid(), "GLASSFISH-INSTANCE");
                if (memberName == null) continue;
                result.add(memberName);
            }
        }
        return result;
    }

    public Set<String> getMemberNamesInGroup(String groupName) {
        HashSet<String> result = new HashSet<String>(5);
        if (this.hzCore.isEnabled()) {
            Set members = this.hzCore.getInstance().getCluster().getMembers();
            for (Member member : members) {
                String memberName = this.hzCore.getAttribute(member.getUuid(), "GLASSFISH-INSTANCE");
                String memberGroupName = member.getAttribute("GLASSFISH_INSTANCE_GROUP");
                if (memberName == null || memberGroupName == null || !groupName.equals(memberGroupName)) continue;
                result.add(memberName);
            }
        }
        return result;
    }

    @PostConstruct
    void postConstruct() {
        this.events.register((EventListener)this);
        this.myListeners = ConcurrentHashMap.newKeySet(2);
    }

    public void event(EventListener.Event event) {
        if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE) && this.hzCore.isEnabled()) {
            logger.config("Payara Data Grid Service Enabled");
            this.logClusterStatus();
            Cluster cluster = this.hzCore.getInstance().getCluster();
            this.localUUID = cluster.getLocalMember().getUuid();
            cluster.addMembershipListener((MembershipListener)this);
        }
    }

    private void logClusterStatus() {
        StringBuilder message = new StringBuilder();
        String NL = System.lineSeparator();
        message.append(NL);
        if (this.hzCore.isEnabled()) {
            String dataGridName = this.hzCore.getInstance().getConfig().getClusterName();
            Cluster cluster = this.hzCore.getInstance().getCluster();
            Set members = this.hzCore.getInstance().getCluster().getMembers();
            message.append("Payara Data Grid State: DG Version: ").append(cluster.getClusterVersion().getMajor());
            message.append(" DG Name: ").append(dataGridName);
            message.append(" DG Size: ").append(members.size());
            message.append(NL);
            message.append("Instances: {").append(NL);
            for (Member member : members) {
                String name = this.hzCore.getAttribute(member.getUuid(), "GLASSFISH-INSTANCE");
                String group = this.hzCore.getAttribute(member.getUuid(), "GLASSFISH_INSTANCE_GROUP");
                message.append(" DataGrid: ").append(dataGridName);
                if (group != null) {
                    message.append(" Instance Group: ").append(group);
                }
                if (name != null) {
                    message.append(" Name: ").append(name);
                }
                message.append(" Lite: ").append(Boolean.toString(member.isLiteMember()));
                message.append(" This: ").append(Boolean.toString(member.localMember()));
                message.append(" UUID: ").append(member.getUuid());
                message.append(" Address: ").append(member.getSocketAddress());
                message.append(NL);
            }
            message.append("}");
            logger.info("Data Grid Status " + message);
        }
    }
}

