/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.AsyncSendCallback;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.BytesMessageImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.ContextableSession;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MapMessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ObjectMessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.ServerSessionRunner;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.SessionReader;
import com.sun.messaging.jmq.jmsclient.StreamMessageImpl;
import com.sun.messaging.jmq.jmsclient.TextMessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.Transaction;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.timer.TimerEventHandler;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import com.sun.messaging.jms.ra.api.JMSRAManagedConnection;
import com.sun.messaging.jms.ra.api.JMSRAXASession;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.ServerSession;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TransactionRolledBackException;

public class SessionImpl
implements JMSRAXASession,
Traceable,
ContextableSession {
    private ServerSessionRunner serverSessionRunner = null;
    private ConnectionConsumerImpl connectionConsumer = null;
    protected ConnectionImpl connection = null;
    protected boolean isTransacted = false;
    protected int acknowledgeMode = 1;
    protected SessionReader sessionReader = null;
    protected SessionQueue sessionQueue = null;
    protected ReadChannel readChannel = null;
    protected Hashtable consumers = new Hashtable();
    protected Vector producers = new Vector();
    protected WriteChannel writeChannel = null;
    protected Long sessionId = null;
    protected ProtocolHandler protocolHandler = null;
    protected Transaction transaction = null;
    protected boolean failoverOccurred = false;
    protected int dupsOkLimit = 10;
    protected boolean isAckLimited = false;
    protected int ackLimit = 100;
    protected int ackCounter = 0;
    protected Vector unAckedMessageQueue = new Vector();
    protected boolean isClosed = false;
    protected boolean isStopped = false;
    protected boolean protectMode = false;
    protected Hashtable browserConsumers = new Hashtable();
    ReadWritePacket ackPkt = new ReadWritePacket();
    ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
    DataOutputStream dos = new DataOutputStream(this.bos);
    ReadWritePacket expirePkt = new ReadWritePacket();
    ByteArrayOutputStream expireBos = new ByteArrayOutputStream(36);
    DataOutputStream expireDos = new DataOutputStream(this.expireBos);
    protected boolean setJMSXConsumerTXID = false;
    protected boolean debug = Debug.debug;
    private Object syncObject = new Object();
    private boolean inSyncState = false;
    private int inSyncStateOperation = 0;
    private static final int INSYNCSTATE_NOTSET = 0;
    private static final int INSYNCSTATE_SESSION_CLOSING = 1;
    private static final int INSYNCSTATE_CONSUMER_CLOSING = 2;
    private static final int INSYNCSTATE_OTHER = 3;
    private Object sessionSyncObj = new Object();
    protected boolean xaTxnMode = false;
    private Object raEndpointSyncObj = new Object();
    private JMSRAManagedConnection mc = null;
    private boolean isDedicatedToServerSession = false;
    private long brokerSessionID = -1L;
    private int TEST_ackCount = 0;
    private int TEST_rxCount = 0;
    protected boolean dupsOkAckOnEmptyQueue = false;
    protected boolean dupsOkAckOnLimit = false;
    protected boolean dupsOkAckOnTimeout = false;
    protected long dupsOkAckTimeout = 0L;
    protected long dupsOkTimestamp = 0L;
    protected Object dupsOkSyncObj = new Object();
    protected boolean allowExtensions = false;
    public static final String SESSION_LOGGER_NAME = "javax.jms.session";
    protected static final Logger sessionLogger = Logger.getLogger("javax.jms.session", "com.sun.messaging.jmq.jmsclient.resources.ClientResources");
    protected volatile boolean remore_broker_failed = false;
    protected volatile boolean isRollbackOnly = false;
    protected Throwable rollbackCause = null;
    public static final boolean autoStartTxn = Boolean.getBoolean("imq.autoStartTxn");
    public static final boolean noBlockUntilTxnCompletes = Boolean.getBoolean("imq.noBlockUntilTxnCompletes");
    public static final boolean noBlockOnAutoAckNPTopics = Boolean.getBoolean("imq.noBlockOnAutoAckNPTopics");
    private static long waitTimeoutForConsumerCloseDone = Integer.getInteger("imqWaitTimeoutForConsumerCloseDone", 90000).intValue();
    private ThreadLocal<Boolean> isMessageListener = new ThreadLocal();
    private Object asyncSendLock = new Object();
    private ArrayList<AsyncSendCallback> asyncSends = new ArrayList();
    private boolean noAsyncSendCBProcessor = true;
    protected WakeupableTimer asyncSendCBProcessor = null;
    protected static final Exception asyncSendWaitTimeoutEx = SessionImpl.getAsyncSendWaitTimeoutException();
    protected static final Exception noAsyncSendCBProcessorEx = SessionImpl.getNoAsyncSendCBProcessorException();
    protected static final Exception connectionBrokenEx = SessionImpl.getConnectionBrokenException();

    private static Exception getAsyncSendWaitTimeoutException() {
        String emsg = AdministeredObject.cr.getKString("C4314");
        return new JMSException(emsg, "C4314");
    }

    private static Exception getNoAsyncSendCBProcessorException() {
        String emsg = AdministeredObject.cr.getKString("C4315");
        return new IllegalStateException(emsg, "C4315");
    }

    private static Exception getConnectionBrokenException() {
        String emsg = AdministeredObject.cr.getKString("E703");
        return new JMSException(emsg, "E703");
    }

    protected SessionImpl() {
    }

    public SessionImpl(ConnectionImpl connection) throws JMSException {
        this(connection, false, 1, false, null);
    }

    public SessionImpl(ConnectionImpl connection, boolean isTransacted, int acknowledgeMode) throws JMSException {
        this(connection, isTransacted, acknowledgeMode, false, null);
    }

    public SessionImpl(ConnectionImpl connection, boolean isTransacted, int acknowledgeMode, JMSRAManagedConnection mc) throws JMSException {
        this(connection, isTransacted, acknowledgeMode, false, mc);
    }

    public SessionImpl(ConnectionImpl connection, int acknowledgeMode) throws JMSException {
        this(connection, false, acknowledgeMode, true, null);
    }

    public SessionImpl(ConnectionImpl connection, boolean isTransacted, int acknowledgeMode, boolean allowJMSExtension, JMSRAManagedConnection mc) throws JMSException {
        try {
            this.sessionQueue = new SessionQueue();
            this.sessionQueue.validateQueue();
            this.allowExtensions = allowJMSExtension;
            this.connection = connection;
            if (!isTransacted) {
                if (acknowledgeMode == 0) {
                    acknowledgeMode = 1;
                }
                this.checkAckMode(acknowledgeMode);
            }
            this.writeChannel = connection.getWriteChannel();
            this.readChannel = connection.getReadChannel();
            this.protocolHandler = connection.getProtocolHandler();
            this.isTransacted = isTransacted;
            this.acknowledgeMode = acknowledgeMode;
            this.sessionId = connection.getNextSessionId();
            if (mc != null) {
                this.mc = mc;
            }
            this.init();
            this.logLifeCycle("I200");
        }
        catch (JMSException jmse) {
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void checkAckMode(int ackMode) throws JMSException {
        if (ackMode != 1 && ackMode != 2 && ackMode != 3) {
            if (this.allowExtensions && ackMode == 32768) {
                if (this.connection.getBrokerProtocolLevel() <= 350) {
                    String errorString = AdministeredObject.cr.getKString("C4092", this.connection.getBrokerVersion());
                    com.sun.messaging.jms.JMSException jmse = new com.sun.messaging.jms.JMSException(errorString, "C4092");
                    ExceptionHandler.throwJMSException(jmse);
                }
                return;
            }
            String ackModeStr = String.valueOf(ackMode);
            String errorString = AdministeredObject.cr.getKString("C4067", ackModeStr);
            JMSException jmse = new JMSException(errorString, "C4067");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void init() throws JMSException {
        this.serverSessionRunner = new ServerSessionRunner(this, null);
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
        if (this.isTransacted) {
            if (this.mc == null) {
                this.transaction = new Transaction(this, true);
            } else {
                this.transaction = new Transaction(this, false);
                if (this.mc.xaTransactionStarted()) {
                    this.transaction.setTransactionID(this.mc.getTransactionID());
                    this.xaTxnMode = true;
                }
            }
        }
        if (this.connection.getIsStopped()) {
            this.sessionQueue.setIsLocked(true);
        }
        this.connection.addToReadQTable(this.sessionId, this.sessionQueue);
        this.connection.addSession(this);
        this.dupsOkLimit = this.connection.getDupsOkLimit();
        this.isAckLimited = this.connection.getIsAckLimited();
        this.ackLimit = this.connection.getAckLimit();
        this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID && this.isTransacted;
        this.protectMode = this.connection.getProtectMode();
        this.isDedicatedToServerSession = this.connection.getIsDedicatedToConnectionConsumer();
        this.dupsOkInit();
        this.sessionReader = new SessionReader(this);
        if (this.isDedicatedToServerSession) {
            this.sessionReader.close();
        } else {
            this.sessionReader.start();
        }
    }

    protected void dupsOkInit() {
        if (!this.isTransacted && this.acknowledgeMode == 3) {
            if (this.isDedicatedToServerSession) {
                this.dupsOkAckOnEmptyQueue = true;
            } else {
                this.dupsOkAckOnEmptyQueue = this.connection.dupsOkAckOnEmptyQueue;
                if (!this.dupsOkAckOnEmptyQueue) {
                    this.dupsOkAckTimeout = this.connection.dupsOkAckTimeout;
                    if (this.dupsOkAckTimeout > 0L) {
                        this.dupsOkAckOnTimeout = true;
                    } else {
                        this.dupsOkAckOnLimit = true;
                        this.dupsOkAckTimeout = 0L;
                    }
                }
            }
        }
        if (this.debug) {
            if (this.dupsOkAckOnTimeout || this.dupsOkAckOnEmptyQueue || this.dupsOkAckOnLimit) {
                Debug.println("*** dupsOkAckOnEmptyQueue: " + this.dupsOkAckOnEmptyQueue);
                Debug.println("*** dupsOkAckOnTimeout: " + this.dupsOkAckOnTimeout);
                Debug.println("*** dupsOkAckTimeout: " + this.dupsOkAckTimeout);
                Debug.println("*** dupsOkAckOnLimit: " + this.dupsOkAckOnLimit);
            } else {
                Debug.println("*** Session ackMode:  " + this.acknowledgeMode);
            }
        }
    }

    protected void switchOnXATransaction() throws JMSException {
        if (this.xaTxnMode) {
            return;
        }
        if (this.isTransacted) {
            this.setInSyncState();
            try {
                this.receiveRollback();
                this.transaction.rollbackToXA();
            }
            finally {
                this.releaseInSyncState();
            }
        }
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
            this.isTransacted = true;
            this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID;
        }
        this.xaTxnMode = true;
    }

    protected void switchOffXATransaction() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    protected void addMessageConsumer(MessageConsumerImpl consumer) throws JMSException {
        this.consumers.put(consumer.interestId, consumer);
    }

    protected void checkBrowserCreation() throws JMSException {
        if (this.isDedicatedToServerSession) {
            this.checkConsumerCreation();
        }
    }

    protected void checkConsumerCreation() throws JMSException {
        if (this.isDedicatedToServerSession || this.serverSessionRunner.getMessageListener() != null) {
            String errorString = AdministeredObject.cr.getKString("C4031");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4031");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void removeMessageConsumer(MessageConsumerImpl consumer) {
        this.consumers.remove(consumer.interestId);
    }

    protected MessageConsumerImpl getMessageConsumer(Object key) {
        return (MessageConsumerImpl)this.consumers.get(key);
    }

    protected void addBrowserConsumer(BrowserConsumer consumer) {
        consumer.getBrowser().addBrowserConsumer(consumer);
        this.browserConsumers.put(consumer.interestId, consumer);
    }

    protected void removeBrowserConsumer(BrowserConsumer consumer) {
        this.browserConsumers.remove(consumer.interestId);
        consumer.getBrowser().removeBrowserConsumer(consumer);
    }

    protected BrowserConsumer getBrowserConsumer(Object key) {
        return (BrowserConsumer)this.browserConsumers.get(key);
    }

    protected void addMessageProducer(MessageProducerImpl producer) {
        this.producers.add(producer);
    }

    protected void removeMessageProducer(MessageProducerImpl producer) {
        this.producers.remove(producer);
    }

    protected void verifyDestination(javax.jms.Destination destination, String selector, boolean browser) throws JMSException {
        this.protocolHandler.verifyDestination(destination, selector, browser);
    }

    protected SysMessageID[] getMessageIdSet(Consumer consumer) throws JMSException {
        return this.protocolHandler.browse(consumer);
    }

    protected boolean requestMessages(ByteArrayOutputStream bos, BrowserConsumer consumer) throws JMSException {
        return this.protocolHandler.deliver(bos, consumer);
    }

    protected ProtocolHandler getProtocolHandler() {
        return this.connection.getProtocolHandler();
    }

    protected Long getSessionId() {
        return this.sessionId;
    }

    protected ConnectionImpl getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAsyncSendCallback(AsyncSendCallback cb) throws JMSException {
        IllegalStateException jmse;
        String emsg;
        if (this.isClosed) {
            emsg = AdministeredObject.cr.getKString("C4059");
            jmse = new IllegalStateException(emsg, "C4059");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.createAsyncSendCBProcessor();
        if (this.noAsyncSendCBProcessor) {
            emsg = AdministeredObject.cr.getKString("C4315");
            jmse = new IllegalStateException(emsg, "C4315");
            ExceptionHandler.throwJMSException(jmse);
        }
        Object object = this.asyncSendLock;
        synchronized (object) {
            this.asyncSends.add(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAsyncSendCBProcessor() {
        Object object = this.asyncSendLock;
        synchronized (object) {
            if (this.asyncSendCBProcessor == null) {
                this.asyncSendCBProcessor = new WakeupableTimer("AsyncSendListenerProcessor[" + this.toString() + "]", new AsyncSendTimerEventHandler(), 0L, 0L, AdministeredObject.cr.getKString("I502") + "[" + this.toString() + "]", AdministeredObject.cr.getKString("I503") + "[" + this.toString() + "]");
                this.noAsyncSendCBProcessor = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAsyncSendCallback(AsyncSendCallback cb) {
        Object object = this.asyncSendLock;
        synchronized (object) {
            this.asyncSends.remove(cb);
            this.asyncSendLock.notifyAll();
        }
    }

    protected void writeJMSMessage(Message message, AsyncSendCallback asynccb) throws JMSException {
        JMSException jmse;
        String errorString;
        if (this.isClosed) {
            errorString = AdministeredObject.cr.getKString("C4059");
            jmse = new IllegalStateException(errorString, "C4059");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (asynccb != null && this.xaTxnMode) {
            errorString = AdministeredObject.cr.getKString("C4311");
            jmse = new JMSException(errorString, "C4311");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (this.isTransacted) {
            this.checkFailOver();
            this.transaction.send(message, asynccb);
        } else {
            this.writeChannel.writeJMSMessage(message, asynccb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitAllAsyncSendCompletion(MessageProducerImpl producer) throws JMSException {
        this.checkPermissionForAsyncSend();
        if (this.connection.isBroken()) {
            Object object = this.asyncSendLock;
            synchronized (object) {
                this.asyncSendLock.notifyAll();
            }
        }
        AsyncSendCallback cb2 = null;
        long endtime = System.currentTimeMillis() + this.connection.getAsyncSendCompletionWaitTimeout();
        long remaining = 0L;
        if (producer == null) {
            int asize = 0;
            Object object = this.asyncSendLock;
            synchronized (object) {
                asize = this.asyncSends.size();
            }
            boolean firstround = true;
            while (asize > 0) {
                remaining = this.connection.getAsyncSendCompletionWaitTimeout();
                Object object2 = this.asyncSendLock;
                synchronized (object2) {
                    boolean logged = false;
                    while (!(this.asyncSends.size() <= 0 || remaining <= 0L || firstround && this.connection.isBroken() && this.noAsyncSendCBProcessor)) {
                        try {
                            if (!logged) {
                                String msg = AdministeredObject.cr.getKString("I505", String.valueOf(remaining), this);
                                sessionLogger.log(Level.INFO, msg);
                                logged = true;
                            }
                            this.asyncSendLock.wait(remaining);
                        }
                        catch (InterruptedException msg) {
                            // empty catch block
                        }
                        remaining = endtime - System.currentTimeMillis();
                    }
                    if (this.connection.isBroken()) {
                        this.asyncSendLock.notifyAll();
                    }
                    if (this.asyncSends.size() > 0) {
                        Exception ex;
                        Exception exception = ex = this.noAsyncSendCBProcessor ? noAsyncSendCBProcessorEx : asyncSendWaitTimeoutEx;
                        if (this.connection.isBroken()) {
                            ex = connectionBrokenEx;
                        }
                        ex.fillInStackTrace();
                        for (AsyncSendCallback cb2 : this.asyncSends) {
                            cb2.processException(ex);
                        }
                        if (this.noAsyncSendCBProcessor) {
                            String emsg = AdministeredObject.cr.getKString("C4315");
                            JMSException jmse = new JMSException(emsg, "C4315");
                            ExceptionHandler.throwJMSException(jmse);
                        }
                    }
                    firstround = false;
                    asize = this.asyncSends.size();
                }
            }
        } else {
            boolean loggered = false;
            boolean found = true;
            boolean firstround = true;
            remaining = this.connection.getAsyncSendCompletionWaitTimeout();
            while (found) {
                found = false;
                Object object = this.asyncSendLock;
                synchronized (object) {
                    for (AsyncSendCallback cb2 : this.asyncSends) {
                        if (cb2.producer != producer) continue;
                        found = true;
                        if (remaining == 0L || firstround && (this.connection.isBroken() || this.noAsyncSendCBProcessor)) {
                            Exception ex;
                            Exception exception = ex = this.noAsyncSendCBProcessor ? noAsyncSendCBProcessorEx : asyncSendWaitTimeoutEx;
                            if (this.connection.isBroken()) {
                                ex = connectionBrokenEx;
                                this.asyncSendLock.notifyAll();
                            }
                            ex.fillInStackTrace();
                            cb2.processException(ex);
                            if (remaining != 0L) continue;
                            remaining = this.connection.getAsyncSendCompletionWaitTimeout();
                            loggered = false;
                            break;
                        }
                        if (this.noAsyncSendCBProcessor) {
                            String emsg = AdministeredObject.cr.getKString("C4315");
                            JMSException jmse = new JMSException(emsg, "C4315");
                            ExceptionHandler.throwJMSException(jmse);
                        }
                        try {
                            if (!loggered) {
                                String msg = AdministeredObject.cr.getKString("I504", String.valueOf(remaining), producer);
                                sessionLogger.log(Level.FINE, msg);
                                loggered = true;
                            }
                            this.asyncSendLock.wait(remaining);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        remaining = endtime - System.currentTimeMillis();
                        break;
                    }
                    firstround = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _stopFromRA() throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.stop(false);
        }
    }

    protected void stop() throws JMSException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(boolean doWait) throws JMSException {
        if (this.isStopped || this.isClosed) {
            return;
        }
        this.checkPermission();
        Object object = this.sessionSyncObj;
        synchronized (object) {
            this.sessionQueue.stop(doWait);
            this.serverSessionRunner.serverSessionStop();
            MessageConsumerImpl[] consumerArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
            for (int i = 0; i < consumerArray.length; ++i) {
                if (doWait) {
                    consumerArray[i].stop();
                    continue;
                }
                consumerArray[i].stopNoWait();
            }
            this.isStopped = true;
        }
    }

    protected void setConnectionConsumer(ConnectionConsumerImpl cc) {
        this.connectionConsumer = cc;
    }

    protected void resetServerSessionRunner() {
        this.resetServerSessionRunner(true);
    }

    protected void resetServerSessionRunner(boolean resetState) {
        ServerSessionRunner ssr = this.serverSessionRunner;
        if (ssr != null) {
            ssr.reset(resetState);
        }
    }

    protected void reset() throws JMSException {
        try {
            this.sessionQueue.clear();
            MessageConsumerImpl consumer = null;
            Enumeration enum2 = this.consumers.elements();
            while (enum2.hasMoreElements()) {
                consumer = (MessageConsumerImpl)enum2.nextElement();
                consumer.receiveQueue.clear();
            }
            if (this.unAckedMessageQueue != null) {
                this.unAckedMessageQueue.removeAllElements();
            }
            this.consumers.clear();
            this.remore_broker_failed = false;
            if (this.serverSessionRunner != null) {
                this.serverSessionRunner.reset();
            }
            this.closeBrowserConsumers();
        }
        finally {
            this.sessionQueue.start();
            this.isStopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recreateSession() throws JMSException {
        String emsg = AdministeredObject.cr.getKString("C4312");
        JMSException ex = new JMSException(emsg, "C4312");
        AsyncSendCallback cb2 = null;
        Object object = this.asyncSendLock;
        synchronized (object) {
            for (AsyncSendCallback cb2 : this.asyncSends) {
                cb2.processException(ex);
            }
        }
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
        if (this.isTransacted && !this.connection.isConnectedToHABroker) {
            this.transaction = new Transaction(this, true);
        }
        this.failoverOccurred = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws JMSException {
        Object object = this.sessionSyncObj;
        synchronized (object) {
            this.sessionQueue.start();
            this.serverSessionRunner.serverSessionRun();
            MessageConsumerImpl[] consumerArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
            for (int i = 0; i < consumerArray.length; ++i) {
                consumerArray[i].start();
            }
            this.isStopped = false;
        }
    }

    protected void checkPermission() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread || Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            String errorString = AdministeredObject.cr.getKString("C4049");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4049");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void checkPermissionForAsyncSend() throws JMSException {
        if (this.asyncSendCBProcessor != null && this.asyncSendCBProcessor.isTimerThread(Thread.currentThread())) {
            String errorString = AdministeredObject.cr.getKString("C4049");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4049");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeUndeliverableFromRAEndpoint(MessageImpl message, XAResourceForRA xar, boolean sendToDMQ) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.readChannel.flowControl.messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(message.getInterestID());
            this.readChannel.flowControl.messageDelivered(consumer);
            ++this.TEST_rxCount;
            try {
                this.setInSyncState();
                if (xar != null && xar.started()) {
                    XAResourceForRA xAResourceForRA = xar;
                    synchronized (xAResourceForRA) {
                        this.ackPkt.setTransactionID(xar.getTransactionID());
                    }
                } else {
                    this.ackPkt.setTransactionID(0L);
                }
                this.writeMessageID(message);
                this.doAcknowledgeUndeliverable(true, sendToDMQ);
            }
            finally {
                this.releaseInSyncState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl message, XAResourceForRA xar) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            if (sessionLogger.isLoggable(Level.FINER)) {
                this.logMessageDelivered(message);
            }
            this.readChannel.flowControl.messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(message.getInterestID());
            this.readChannel.flowControl.messageDelivered(consumer);
            ++this.TEST_rxCount;
            boolean requiresAckFromBroker = true;
            Hashtable originalProps = null;
            try {
                this.setInSyncState();
                if (xar != null && xar.started()) {
                    XAResourceForRA xAResourceForRA = xar;
                    synchronized (xAResourceForRA) {
                        this.ackPkt.setTransactionID(xar.getTransactionID());
                    }
                    requiresAckFromBroker = !noBlockUntilTxnCompletes;
                } else {
                    this.ackPkt.setTransactionID(0L);
                    if (!this.isTransacted && this.acknowledgeMode == 1 && (consumer != null && !consumer.getDurable() || noBlockOnAutoAckNPTopics)) {
                        javax.jms.Destination d = message.getJMSDestination();
                        if (!message._getPersistent() && d instanceof Topic) {
                            requiresAckFromBroker = false;
                        }
                    }
                }
                this.writeMessageID(message);
                if (message.getClientRetries() > 0) {
                    try {
                        originalProps = this.ackPkt.getProperties();
                    }
                    catch (Exception d) {
                        // empty catch block
                    }
                    Hashtable<String, Integer> props = new Hashtable<String, Integer>();
                    props.put("JMSXDeliveryCount", message.getClientRetries());
                    this.ackPkt.setProperties(props);
                }
                this.doAcknowledge(requiresAckFromBroker);
                if (originalProps != null) {
                    this.ackPkt.setProperties(originalProps);
                }
                this.releaseInSyncState();
            }
            catch (Throwable throwable) {
                if (originalProps != null) {
                    this.ackPkt.setProperties(originalProps);
                }
                this.releaseInSyncState();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl message) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.acknowledge(message);
        }
    }

    public void _appTransactedAck(MessageImpl message) throws JMSException {
        Consumer consumer = (Consumer)this.consumers.get(message.getInterestID());
        if (consumer == null) {
            String errorString = AdministeredObject.cr.getKString("C4063");
            throw new JMSException(errorString, "C4063");
        }
        if (!(consumer instanceof MessageConsumerImpl)) {
            throw new JMSException("Operation not supported for consumer type: " + consumer.getClass().getName());
        }
        this.acknowledge(message);
        ((MessageConsumerImpl)consumer).lastDeliveredID = message.getMessageID();
    }

    protected void doPrefetch(Consumer consumer) {
        this.readChannel.flowControl.messageDelivered();
        this.readChannel.flowControl.messageDelivered(consumer);
        ++this.TEST_rxCount;
    }

    protected void acknowledge(MessageImpl message) throws JMSException {
        this.acknowledge(message, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void acknowledge(MessageImpl message, boolean prefetch) throws JMSException {
        Consumer consumer;
        if (sessionLogger.isLoggable(Level.FINER)) {
            this.logMessageDelivered(message);
        }
        if (prefetch) {
            this.readChannel.flowControl.messageDelivered();
        }
        if ((consumer = (Consumer)this.consumers.get(message.getInterestID())) == null) {
            consumer = this.connection.interestTable.getConsumer(message.getInterestID());
        }
        if (prefetch) {
            this.readChannel.flowControl.messageDelivered(consumer);
            ++this.TEST_rxCount;
        }
        try {
            this.setInSyncState();
            if (this.isTransacted) {
                this.transactedAcknowledge(message);
                return;
            }
            switch (this.acknowledgeMode) {
                case 1: {
                    this.autoAcknowledge(message, consumer == null ? true : consumer.getDurable());
                    return;
                }
                case 2: {
                    this.prepareClientAcknowledge(message);
                    return;
                }
                case 3: {
                    if (this.dupsOkAckOnTimeout) {
                        this.syncedDupsOkAcknowledge(message);
                        return;
                    } else {
                        this.dupsOkAcknowledge(message);
                        return;
                    }
                }
                case 32768: {
                    return;
                }
                default: {
                    this.autoAcknowledge(message, consumer == null ? true : consumer.getDurable());
                    return;
                }
            }
        }
        catch (JMSException jmse) {
            if (this.isTransacted || this.acknowledgeMode != 1 && this.acknowledgeMode != 3 || !this.isRemoteException(jmse)) throw jmse;
            this.recreateConsumers();
            ExceptionHandler.throwRemoteAcknowledgeException(jmse, "C4107");
            throw jmse;
        }
        finally {
            this.releaseInSyncState();
        }
    }

    protected void acknowledgeExpired(MessageImpl message) throws JMSException {
        this.acknowledgeExpired(message, true);
    }

    protected void acknowledgeExpired(MessageImpl message, boolean prefetch) throws JMSException {
        if (sessionLogger.isLoggable(Level.FINER)) {
            this.logMessageExpired(message);
        }
        this.acknowledgeDeadMessage(message, prefetch, 1);
    }

    protected void acknowledgeUndeliverable(MessageImpl message) throws JMSException {
        if (sessionLogger.isLoggable(Level.FINER)) {
            this.logMessageUndeliverable(message);
        }
        this.acknowledgeDeadMessage(message, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledgeDeadMessage(MessageImpl message, boolean prefetch, int deadReason) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            Consumer consumer;
            if (prefetch) {
                this.readChannel.flowControl.messageDelivered();
            }
            if ((consumer = (Consumer)this.consumers.get(message.getInterestID())) == null) {
                consumer = this.connection.interestTable.getConsumer(message.getInterestID());
            }
            if (prefetch) {
                this.readChannel.flowControl.messageDelivered(consumer);
                ++this.TEST_rxCount;
            }
            try {
                this.expireDos.writeLong(message.getInterestID());
                message.getMessageID().writeID(this.expireDos);
                this.expireDos.flush();
                this.expireBos.flush();
                this.expirePkt.setMessageBody(this.expireBos.toByteArray());
                this.ackPkt.setSendAcknowledge(false);
                this.protocolHandler.acknowledgeUndeliverable(this.expirePkt, true, deadReason);
            }
            catch (Exception e) {
                String destName = "";
                try {
                    destName = consumer != null ? consumer.getDestName() : message.getJMSDestination().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object[] args = new Object[]{message.getMessageID(), destName, message.getInterestID(), e.getMessage()};
                String ecode = deadReason == 1 ? "C4303" : "C4304";
                String estr = AdministeredObject.cr.getKString(ecode, args);
                JMSException jmse = new JMSException(estr, ecode);
                jmse.setLinkedException(e);
                throw jmse;
            }
            finally {
                this.expireBos.reset();
            }
        }
    }

    private void logMessageExpired(MessageImpl message) {
        this.logMessage(message, "I303");
    }

    private void logMessageUndeliverable(MessageImpl message) {
        this.logMessage(message, "I304");
    }

    private void logMessageDelivered(MessageImpl message) {
        this.logMessage(message, "I302");
    }

    private void logMessage(MessageImpl message, String key) {
        try {
            if (sessionLogger.isLoggable(Level.FINER)) {
                String param = this.makeDebugStringForMessage(message);
                sessionLogger.log(Level.FINER, key, param);
                if (sessionLogger.isLoggable(Level.FINEST)) {
                    param = "MQTrace=MessageConsumer, ConsumerID=" + message.getInterestID() + ", Message=" + message.toString();
                    sessionLogger.log(Level.FINEST, key, param);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String makeDebugStringForMessage(MessageImpl message) {
        try {
            Destination mqDest = (Destination)message.getJMSDestination();
            String domain = mqDest.isQueue() ? "Queue:" : "Topic:";
            String pktType = PacketType.getString(message.getPacket().getPacketType());
            return "MQTrace=MessageConsumer, ThreadID=" + Thread.currentThread().getId() + ", ClientID=" + this.connection.getClientID() + ", ConnectionID=" + this.connection.getConnectionID() + ", SessionID=" + this.getBrokerSessionID() + ", ConsumerID=" + message.getInterestID() + ", Destination=" + domain + mqDest.getName() + ", MessageID=" + message.getJMSMessageID() + ", MessageType=" + pktType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "[MessageID=" + message.getMessageID() + ", ConsumerID=" + message.getInterestID() + "]";
        }
    }

    protected void autoAcknowledge(MessageImpl message, boolean isdurable) throws JMSException {
        this.writeMessageID(message);
        boolean requireAckFromBroker = true;
        if (!isdurable || noBlockOnAutoAckNPTopics) {
            javax.jms.Destination d = message.getJMSDestination();
            if (!message._getPersistent() && d instanceof Topic) {
                requireAckFromBroker = false;
            }
        }
        this.doAcknowledge(requireAckFromBroker);
    }

    protected void transactedAcknowledge(MessageImpl message) throws JMSException {
        try {
            boolean isAddedToList = this.prepareTransactedAcknowledge(message);
            if (isAddedToList) {
                this.ackPkt.setTransactionID(this.transaction.getTransactionID());
                this.writeMessageID(message);
                boolean requiresAckFromBroker = !noBlockUntilTxnCompletes;
                this.doAcknowledge(requiresAckFromBroker);
            }
        }
        catch (JMSException jmse) {
            if (jmse instanceof RemoteAcknowledgeException) {
                this.remore_broker_failed = true;
            }
            throw jmse;
        }
    }

    protected void writeMessageID(MessageImpl message) throws JMSException {
        try {
            this.dos.writeLong(message.getInterestID());
            message.getMessageID().writeID(this.dos);
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
    }

    protected void writeMessageID(UnAckedMessage message) throws JMSException {
        try {
            this.dos.writeLong(message.getConsumerID());
            message.getMessageID().writeID(this.dos);
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
    }

    protected void writeMessageID(ReadOnlyPacket pkt) throws JMSException {
        try {
            this.dos.writeLong(pkt.getConsumerID());
            pkt.getSysMessageID().writeID(this.dos);
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAcknowledgeUndeliverable(boolean requireAckFromBroker, boolean sendToDMQ) throws JMSException {
        try {
            this.dos.flush();
            this.bos.flush();
            this.ackPkt.setMessageBody(this.bos.toByteArray());
            this.ackPkt.setSendAcknowledge(requireAckFromBroker);
            this.protocolHandler.acknowledgeUndeliverable(this.ackPkt, sendToDMQ);
            ++this.TEST_ackCount;
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4016");
        }
        finally {
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
    }

    protected void doAcknowledge(boolean requireAckFromBroker) throws JMSException {
        try {
            this.dos.flush();
            this.bos.flush();
            this.ackPkt.setMessageBody(this.bos.toByteArray());
            this.ackPkt.setSendAcknowledge(requireAckFromBroker);
            this.checkFailOver();
            this.protocolHandler.acknowledge(this.ackPkt);
            ++this.TEST_ackCount;
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4016");
        }
        finally {
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
    }

    protected void dupsOkAcknowledge(MessageImpl message) throws JMSException {
        this.addMessageToAckList(message);
        if (this.dupsOkShouldAcknowledge()) {
            this.dupsOkCommitAcknowledge();
        }
    }

    protected void dupsOkCommitAcknowledge() throws JMSException {
        if (this.debug) {
            Debug.println("***** dups ok committing ack .... size: " + this.ackCounter);
        }
        this.dequeueUnAckedMessages();
        this.doAcknowledge(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkAcknowledge(MessageImpl message) throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter == 0) {
                this.dupsOkTimestamp = System.currentTimeMillis();
            }
            this.dupsOkAcknowledge(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkCommitAcknowledge() throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter > 0) {
                this.dupsOkCommitAcknowledge();
            }
        }
    }

    protected boolean dupsOkShouldAcknowledge() {
        if (this.dupsOkAckOnTimeout) {
            boolean timeToAck = System.currentTimeMillis() - this.dupsOkTimestamp >= this.dupsOkAckTimeout;
            return this.ackCounter == this.dupsOkLimit || timeToAck;
        }
        if (this.dupsOkAckOnEmptyQueue) {
            return this.ackCounter == this.dupsOkLimit || this.sessionQueue.isEmpty();
        }
        return this.ackCounter == this.dupsOkLimit;
    }

    protected boolean addMessageToAckList(MessageImpl message) throws JMSException {
        boolean isAddedToList = false;
        if (message != null && !message.getIsOnAckList()) {
            message.setIsOnAckList(true);
            UnAckedMessage unacked = new UnAckedMessage(message);
            this.unAckedMessageQueue.addElement(unacked);
            ++this.ackCounter;
            isAddedToList = true;
        }
        return isAddedToList;
    }

    protected void removeMessageFromAckList(UnAckedMessage unacked) {
        this.unAckedMessageQueue.removeElement(unacked);
        --this.ackCounter;
    }

    protected void prepareClientAcknowledge(MessageImpl message) throws JMSException {
        this.addMessageToAckList(message);
        if (this.isAckLimited) {
            this.checkClientAckLimit();
        }
    }

    protected void checkClientAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String errorString = AdministeredObject.cr.getKString("C4023");
            Debug.println(errorString);
        }
    }

    protected boolean prepareTransactedAcknowledge(MessageImpl message) throws JMSException {
        boolean isAddedToList = false;
        isAddedToList = this.addMessageToAckList(message);
        if (this.isAckLimited) {
            this.checkTransactedAckLimit();
        }
        return isAddedToList;
    }

    protected void checkTransactedAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String errorString = AdministeredObject.cr.getKString("C4026");
            Debug.println(errorString);
        }
    }

    @Override
    public void clientAcknowledge() throws JMSException {
        if (this.getAcknowledgeMode() != 2) {
            return;
        }
        if (this.failoverOccurred) {
            String errorString = AdministeredObject.cr.getKString("C4075");
            JMSException jmse = new JMSException(errorString, "C4075");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.checkSessionState();
        if (this.unAckedMessageQueue.size() > 0) {
            this.dequeueUnAckedMessages();
            this.doClientAcknowledge();
        }
    }

    protected void clientAcknowledge(MessageImpl message) throws JMSException {
        if (this.failoverOccurred) {
            String errorString = AdministeredObject.cr.getKString("C4075");
            JMSException jmse = new JMSException(errorString, "C4075");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.checkClientAckMessage(message);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(message);
            if (this.unAckedMessageQueue.size() > 0) {
                this.dequeueUnAckedMessages();
                this.doClientAcknowledge();
            }
        }
    }

    protected void clientAcknowledgeThisMessage(MessageImpl message) throws JMSException {
        this.checkClientAckMessage(message);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(message);
            UnAckedMessage unAckedMessage = null;
            for (int i = 0; i < this.unAckedMessageQueue.size(); ++i) {
                unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
                if (!message.messageID.equals(unAckedMessage.getMessageID())) continue;
                this.writeMessageID(unAckedMessage);
                this.unAckedMessageQueue.removeElementAt(i);
                this.doClientAcknowledge();
                return;
            }
        }
    }

    protected void clientAcknowledgeUpThroughThisMessage(MessageImpl message) throws JMSException {
        if (this.failoverOccurred) {
            String errorString = AdministeredObject.cr.getKString("C4075");
            JMSException jmse = new JMSException(errorString, "C4075");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.checkClientAckMessage(message);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(message);
            if (this.isMessageInUnAckedQueue(message)) {
                UnAckedMessage unAckedMessage = null;
                boolean found = false;
                while (!found) {
                    unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.firstElement();
                    this.writeMessageID(unAckedMessage);
                    this.unAckedMessageQueue.removeElementAt(0);
                    if (!message.messageID.equals(unAckedMessage.getMessageID())) continue;
                    found = true;
                }
                this.doClientAcknowledge();
            }
        }
    }

    private void doClientAcknowledge() throws JMSException {
        if (this.remore_broker_failed) {
            ExceptionHandler.throwRemoteAcknowledgeException(null, "C4108");
        }
        try {
            this.doAcknowledge(true);
        }
        catch (JMSException jmse) {
            if (this.isRemoteException(jmse)) {
                this.remore_broker_failed = true;
                ExceptionHandler.throwRemoteAcknowledgeException(jmse, "C4108");
            }
            throw jmse;
        }
    }

    protected boolean isMessageInUnAckedQueue(MessageImpl message) throws JMSException {
        boolean inQueue = false;
        UnAckedMessage unAckedMessage = null;
        int size = this.unAckedMessageQueue.size();
        for (int i = 0; i < size; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            if (!message.messageID.equals(unAckedMessage.getMessageID())) continue;
            inQueue = true;
            i = size;
        }
        return inQueue;
    }

    protected void checkSessionState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4059");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4059");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void checkFailOver() throws JMSException {
        if (this.isTransacted && this.failoverOccurred) {
            String errorString = AdministeredObject.cr.getKString("C4103");
            JMSException jmse = new JMSException(errorString, "C4103");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkSessionState();
        return new BytesMessageImpl(true);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkSessionState();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkSessionState();
        MessageImpl message = new MessageImpl();
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkSessionState();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkSessionState();
        ObjectMessageImpl objectMessage = new ObjectMessageImpl();
        objectMessage.setObject(object);
        return objectMessage;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkSessionState();
        return new StreamMessageImpl(true);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkSessionState();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkSessionState();
        TextMessageImpl message = new TextMessageImpl();
        message.setText(text);
        return message;
    }

    public boolean getTransacted() throws JMSException {
        this.checkSessionState();
        return this.isTransacted;
    }

    protected boolean getTransactedNoCheck() {
        return this.isTransacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkSessionState();
        if (this.isTransacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        JMSException jmse;
        String errorString;
        this.checkSessionState();
        this.checkPermissionForAsyncSend();
        if (!this.isTransacted) {
            errorString = AdministeredObject.cr.getKString("C4024");
            jmse = new IllegalStateException(errorString, "C4024");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (this.failoverOccurred) {
            this.rollback();
            errorString = AdministeredObject.cr.getKString("C4074");
            jmse = new TransactionRolledBackException(errorString, "C4074");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (this.isRollbackOnly) {
            if (this.rollbackCause instanceof Exception) {
                ExceptionHandler.handleException((Exception)this.rollbackCause, "C4038");
            } else {
                Exception e = new Exception(this.rollbackCause);
                ExceptionHandler.handleException(e, "C4038");
            }
        }
        this.waitAllAsyncSendCompletion(null);
        Throwable rbrollbackex = null;
        boolean rbrollback = false;
        this.setInSyncState();
        try {
            this.receiveCommit();
            this.transaction.commit();
        }
        catch (JMSException jmse2) {
            if (this.isRemoteException(jmse2)) {
                this.doRemoteFailedRollback(jmse2);
            } else {
                Exception e1;
                if (!this.connection.isConnectedToHABroker() && jmse2.getErrorCode().equals("C4036") && (e1 = jmse2.getLinkedException()) != null && e1 instanceof JMSException && (((JMSException)e1).getErrorCode().equals(Status.getString(410)) || ((JMSException)e1).getErrorCode().equals(Status.getString(409)))) {
                    sessionLogger.log(Level.WARNING, "Exception on commit transaction " + this.transaction.getTransactionID() + ", will rollback", jmse2);
                    rbrollbackex = jmse2;
                    rbrollback = true;
                }
                if (!rbrollback) {
                    throw jmse2;
                }
            }
        }
        finally {
            this.releaseInSyncState();
        }
        if (rbrollback) {
            Throwable ex = rbrollbackex;
            try {
                this.rollback();
                ex = new com.sun.messaging.jms.TransactionRolledBackException(rbrollbackex.getMessage(), ((JMSException)rbrollbackex).getErrorCode());
            }
            catch (Exception e) {
                sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + this.transaction.getTransactionID() + " after commit failure", e);
                ex = rbrollbackex;
            }
            throw ex;
        }
    }

    protected void doRemoteFailedRollback(JMSException jmse) throws JMSException {
        this.recreateConsumers();
        String errorString = AdministeredObject.cr.getKString("C4109");
        com.sun.messaging.jms.TransactionRolledBackException newjmse = new com.sun.messaging.jms.TransactionRolledBackException(errorString, "C4109");
        ((JMSException)newjmse).setLinkedException(jmse);
        ExceptionHandler.throwJMSException(newjmse);
    }

    public void rollback() throws JMSException {
        this.checkSessionState();
        this.checkPermissionForAsyncSend();
        if (!this.isTransacted) {
            String errorString = AdministeredObject.cr.getKString("C4024");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4024");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.waitAllAsyncSendCompletion(null);
        this.setInSyncState();
        try {
            if (this.remore_broker_failed) {
                this.recreateConsumers();
                this.remore_broker_failed = false;
                return;
            }
            if (this.connection.isConnectedToHABroker) {
                this.rollbackHATransaction();
            } else {
                this.receiveRollback();
                this.transaction.rollback();
            }
        }
        finally {
            this.isRollbackOnly = false;
            this.rollbackCause = null;
            this.failoverOccurred = false;
            this.releaseInSyncState();
        }
    }

    private void rollbackHATransaction() throws JMSException {
        try {
            this.receiveRollback();
            this.transaction.rollback();
        }
        catch (JMSException jmse) {
            String ecode = jmse.getErrorCode();
            if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
                this.rollbackFailed(jmse);
            }
            throw jmse;
        }
    }

    private void rollbackFailed(JMSException jmse) throws JMSException {
        if (!this.connection.imqReconnect) {
            throw jmse;
        }
        SessionImpl.yield();
        this.connection.checkReconnecting(null);
        if (this.connection.isCloseCalled || this.connection.connectionIsBroken) {
            throw jmse;
        }
        this.transaction.startNewLocalTransaction();
    }

    public static void yield() {
        try {
            Thread.yield();
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConsumers() throws JMSException {
        Collection cons = this.consumers.values();
        MessageConsumerImpl[] consumerArray = cons.toArray(new MessageConsumerImpl[cons.size()]);
        for (int i = 0; i < consumerArray.length; ++i) {
            consumerArray[i].close(true);
        }
        this.consumers.clear();
    }

    private void closeProducers() throws JMSException {
        MessageProducerImpl[] _producers = this.producers.toArray(new MessageProducerImpl[this.producers.size()]);
        for (int i = 0; i < _producers.length; ++i) {
            _producers[i].close();
        }
        this.producers.clear();
    }

    private void closeBrowserConsumers() throws JMSException {
        Collection bcons = this.browserConsumers.values();
        BrowserConsumer[] bcArray = bcons.toArray(new BrowserConsumer[bcons.size()]);
        for (int i = 0; i < bcArray.length; ++i) {
            bcArray[i].close();
        }
        this.browserConsumers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        sessionLogger.log(Level.FINEST, "##### closing session.  consumer table size: " + this.consumers.values().size());
        int reduceFlowCount = 0;
        this.checkPermission();
        this.checkPermissionForAsyncSend();
        try {
            this.prepareToClose(true);
            Object object = this.sessionSyncObj;
            synchronized (object) {
                try {
                    if (this.isClosed) {
                        return;
                    }
                    this.sessionQueue.stop(true);
                    reduceFlowCount = this.sessionQueue.size();
                    if (this.isTransacted) {
                        if (this.xaTxnMode) {
                            this.receiveCommit();
                        } else if (!this.connection.isBroken() && !this.connection.recoverInProcess) {
                            this.transaction.releaseBrokerResource();
                        }
                    }
                    this.closeConsumers();
                    this.closeProducers();
                    this.closeBrowserConsumers();
                    this.sessionReader.close();
                    this.serverSessionRunner.serverSessionClose();
                }
                finally {
                    this.waitAllAsyncSendCompletion(null);
                    if (this.asyncSendCBProcessor != null) {
                        this.asyncSendCBProcessor.cancel();
                    }
                }
                this.connection.removeSession(this);
                this.connection.removeFromReadQTable(this.sessionId);
                if (this.connection.getBrokerProtocolLevel() >= 350 && !this.connection.isBroken() && !this.connection.recoverInProcess) {
                    this.protocolHandler.deleteSession(this);
                }
                this.isClosed = true;
            }
        }
        finally {
            sessionLogger.log(Level.FINEST, "***** consumer table size: " + this.consumers.values().size());
            if (!this.isClosed) {
                this.sessionReader.close();
            }
            if (this.consumers.values().size() > 0) {
                this.cleanUpConsumers();
            }
            this.isClosed = true;
            this.serverSessionRunner.reset();
            if (this.connectionConsumer != null) {
                this.connectionConsumer.sessionClosed(this);
            }
            this.releaseInSyncState();
            this.resetConnectionFlowControl(reduceFlowCount);
            if (sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I201");
            }
        }
        if (!this.debug) return;
        Debug.println("session closed ...");
        Debug.println(this);
    }

    protected void cleanUpConsumers() {
        sessionLogger.log(Level.FINEST, "Cleaning up consumers in session.  SessionID: " + this.sessionId);
        Collection cons = this.consumers.values();
        MessageConsumerImpl[] consumerArray = cons.toArray(new MessageConsumerImpl[cons.size()]);
        for (int i = 0; i < consumerArray.length; ++i) {
            consumerArray[i].receiveQueue.close();
            consumerArray[i].isClosed = true;
        }
        this.consumers.clear();
    }

    protected void resetConnectionFlowControl(int reduceFlowCount) {
        if (this.connection.isCloseCalled) {
            return;
        }
        if (this.connection.protectMode && reduceFlowCount > 0) {
            this.readChannel.flowControl.resetFlowControl(this.connection, reduceFlowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFromRA() {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.sessionReader.close();
        }
    }

    public void _setRAEndpointSession() {
    }

    public void _startLocalTransaction() throws JMSException {
        if (this.isTransacted) {
            if (this.transaction == null) {
                throw new com.sun.messaging.jms.JMSException("MQRA:S:Can't start local transaction-transacted w/o Transaction Object");
            }
        } else {
            if (this.transaction != null) {
                throw new com.sun.messaging.jms.JMSException("MQRA:S:Can't start local transaction-already transacted");
            }
            this.transaction = new Transaction(this, true);
            this.isTransacted = true;
        }
    }

    protected boolean needToWait() {
        return !this.connection.isBroken();
    }

    /*
     * Unable to fully structure code
     */
    public void recover() throws JMSException {
        this.checkSessionState();
        if (this.isTransacted) {
            errorString = AdministeredObject.cr.getKString("C4025");
            jmse = new IllegalStateException(errorString, "C4025");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (this.acknowledgeMode == 32768) {
            errorString = AdministeredObject.cr.getKString("C4091");
            jmse = new IllegalStateException(errorString, "C4091");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (this.remore_broker_failed) {
            this.recreateConsumers();
            this.remore_broker_failed = false;
            return;
        }
        this.setInSyncState();
        try {
            switch (this.acknowledgeMode) {
                case 1: {
                    if (Thread.currentThread() != this.sessionReader.sessionThread) ** GOTO lbl21
                    this.sessionReader.currentMessage.doAcknowledge = false;
                    ** GOTO lbl23
lbl21:
                    // 1 sources

                    if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
                        this.serverSessionRunner.currentMessage.doAcknowledge = false;
                    }
                }
lbl23:
                // 5 sources

                case 2: 
                case 3: {
                    if (Thread.currentThread() == this.sessionReader.sessionThread) {
                        this.prepareClientAcknowledge(this.sessionReader.currentMessage);
                        break;
                    }
                    if (Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) break;
                    this.prepareClientAcknowledge(this.serverSessionRunner.currentMessage);
                }
            }
        }
        catch (Exception var1_2) {
            // empty catch block
        }
        try {
            this.stopSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.stop();
            }
            this.redeliverMessagesInQueues(false);
            this.redeliverUnAckedMessages(true);
            this.failoverOccurred = false;
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.start();
            }
        }
        finally {
            this.releaseInSyncState();
            this.resumeSession();
        }
    }

    protected void stopSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.incStoppedCount();
            this.protocolHandler.stop();
        } else {
            this.protocolHandler.stopSession(this.brokerSessionID);
        }
    }

    protected void resumeSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.decStoppedCount();
            if (!this.connection.getIsStopped()) {
                this.protocolHandler.start();
            }
        } else {
            this.protocolHandler.resumeSession(this.brokerSessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInSyncState() throws JMSException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkSessionState();
            if (this.inSyncState) {
                if (this.isIsMessageListenerThread() && (this.inSyncStateOperation == 1 || this.inSyncStateOperation == 2)) {
                    return;
                }
                if (this.inSyncStateOperation == 2) {
                    long totalwaited = 0L;
                    long waittime = waitTimeoutForConsumerCloseDone;
                    while (this.inSyncState && this.inSyncStateOperation == 2 && (waittime > 0L || waitTimeoutForConsumerCloseDone == 0L)) {
                        this.checkSessionState();
                        long starttime = System.currentTimeMillis();
                        try {
                            this.syncObject.wait(waittime);
                        }
                        catch (InterruptedException e) {
                            Debug.printStackTrace(e);
                        }
                        if ((waittime = waitTimeoutForConsumerCloseDone - (totalwaited += System.currentTimeMillis() - starttime)) >= 0L) continue;
                        waittime = 0L;
                    }
                    if (!this.inSyncState) {
                        this.inSyncState = true;
                        this.inSyncStateOperation = 3;
                        return;
                    }
                }
                String errorString = AdministeredObject.cr.getKString("C4055");
                IllegalStateException jmse = new IllegalStateException(errorString, "C4055");
                ExceptionHandler.throwJMSException(jmse);
            }
            this.inSyncState = true;
            this.inSyncStateOperation = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseInSyncState() {
        Object object = this.syncObject;
        synchronized (object) {
            this.inSyncState = false;
            this.inSyncStateOperation = 0;
            this.syncObject.notifyAll();
        }
    }

    protected boolean getInSyncState() {
        return this.inSyncState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareToClose(boolean fromSessionClose) {
        Object object = this.syncObject;
        synchronized (object) {
            while (this.inSyncState) {
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException e) {
                    Debug.printStackTrace(e);
                }
            }
            this.inSyncState = true;
            this.inSyncStateOperation = fromSessionClose ? 1 : 2;
        }
    }

    protected void receiveCommit() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.transactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.transactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
    }

    protected void clearUnackedMessageQ() {
        this.unAckedMessageQueue.clear();
    }

    protected void receiveRollback() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.prepareTransactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.prepareTransactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
        this.stopSession();
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.stop();
        }
        this.redeliverMessagesInQueues(false);
        this.redeliverUnAckedMessages(true);
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.start();
        }
        this.resumeSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackAfterReceiveCommit(JMQXid jmqXid) throws JMSException {
        this.checkSessionState();
        this.stopSession();
        boolean stoppedbyme = false;
        try {
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.stop();
                stoppedbyme = true;
            }
            this.redeliverMessagesInQueues(false);
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.start();
                stoppedbyme = false;
            }
            this.connection.getProtocolHandler().rollback(0L, jmqXid, true);
        }
        finally {
            try {
                if (stoppedbyme) {
                    this.start();
                }
            }
            finally {
                this.resumeSession();
            }
        }
    }

    protected void redeliverUnAckedMessages(boolean redeliverFlag) throws JMSException {
        this.dequeueUnAckedMessages();
        this.redeliver(redeliverFlag);
    }

    protected void redeliverMessagesInQueues(boolean redeliverFlag) throws JMSException {
        this.dequeueMessagesInQueues();
        this.redeliver(redeliverFlag);
    }

    protected void dequeueMessagesInQueues() throws JMSException {
        MessageConsumerImpl consumer = null;
        Enumeration enum2 = this.consumers.elements();
        int reduceFlowCount = 0;
        while (enum2.hasMoreElements()) {
            consumer = (MessageConsumerImpl)enum2.nextElement();
            reduceFlowCount += consumer.receiveQueue.size();
            this.dequeueReceiveQ(consumer.receiveQueue);
            this.readChannel.flowControl.resetFlowControl(consumer, 0);
        }
        this.dequeueSessionQ(this.sessionQueue);
        this.resetConnectionFlowControl(reduceFlowCount += this.sessionQueue.size());
    }

    protected void dequeueReceiveQ(ReceiveQueue queue) throws JMSException {
        MessageImpl message = null;
        while (!queue.isEmpty()) {
            message = (MessageImpl)queue.dequeue();
            if (message == null) continue;
            this.writeMessageID(message);
        }
    }

    protected void dequeueSessionQ(SessionQueue queue) throws JMSException {
        ReadOnlyPacket pkt = null;
        while (!queue.isEmpty()) {
            pkt = (ReadOnlyPacket)queue.dequeue();
            if (pkt == null) continue;
            this.writeMessageID(pkt);
        }
    }

    private void dequeueUnAckedMessages() throws JMSException {
        UnAckedMessage unAckedMessage = null;
        int size = this.unAckedMessageQueue.size();
        for (int i = 0; i < size; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            this.writeMessageID(unAckedMessage);
        }
        this.unAckedMessageQueue.removeAllElements();
        this.ackCounter = 0;
    }

    protected void redeliver(boolean redeliverFlag) throws JMSException {
        if (this.bos.size() == 0) {
            return;
        }
        ReadWritePacket pkt = new ReadWritePacket();
        try {
            this.dos.flush();
            this.bos.flush();
            pkt.setMessageBody(this.bos.toByteArray());
            if (this.isTransacted) {
                pkt.setTransactionID(this.transaction.getTransactionID());
            }
            this.protocolHandler.redeliver(pkt, redeliverFlag, this.isTransacted);
            this.bos.reset();
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4018");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkSessionState();
        return this.serverSessionRunner.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkSessionState();
        if (listener != null && this.consumers.size() > 0) {
            String errorString = AdministeredObject.cr.getKString("C4031");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4031");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.serverSessionRunner.setMessageListener(listener);
    }

    public void run() {
        this.serverSessionRunner.run();
    }

    protected void loadMessageToServerSession(MessageImpl message, ServerSession ss, boolean isDMQMessage) {
        this.serverSessionRunner.loadMessage(message, ss, isDMQMessage);
    }

    protected SessionQueue getSessionQueue() {
        return this.sessionQueue;
    }

    public boolean _getAckSendAcknowledge() {
        return this.ackPkt.getSendAcknowledge();
    }

    public int _getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    protected boolean _getXaTxnMode() {
        return this.xaTxnMode;
    }

    protected void _setXaTxnMode(boolean mode) {
        this.xaTxnMode = mode;
    }

    public long getBrokerSessionID() {
        return this.brokerSessionID;
    }

    public void setBrokerSessionID(long brokerSessionID) {
        this.brokerSessionID = brokerSessionID;
    }

    public Transaction _getTransaction() {
        return this.transaction;
    }

    @Override
    public void setFailoverOccurred(boolean v) {
        this.failoverOccurred = v;
    }

    @Override
    public void initXATransactionForMC(long transactionID) throws JMSException {
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
        }
        this.transaction.setTransactionID(transactionID);
        this.xaTxnMode = true;
        this.isTransacted = true;
    }

    @Override
    public void finishXATransactionForMC() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ SessionImpl dump ------");
        ps.println("broker session ID: " + this.brokerSessionID);
        ps.println("session ID: " + this.sessionId);
        if (this.sessionReader != null) {
            this.sessionReader.dump(ps);
        }
        if (this.sessionQueue != null) {
            this.sessionQueue.dump(ps);
        }
        if (this.unAckedMessageQueue != null) {
            ps.println("Number of Unacked messages: " + this.unAckedMessageQueue.size());
        }
        ps.println("# of message consumers: " + this.consumers.size());
        Enumeration enum2 = this.consumers.elements();
        while (enum2.hasMoreElements()) {
            MessageConsumerImpl consumer = (MessageConsumerImpl)enum2.nextElement();
            consumer.dump(ps);
        }
        this.serverSessionRunner.dump(ps);
    }

    protected Hashtable getDebugState(boolean verbose) {
        ServerSessionRunner ssr;
        ConnectionConsumerImpl cc;
        SessionQueue ssq;
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("sessionId", String.valueOf(this.sessionId));
        ht.put("brokerSessionID", String.valueOf(this.brokerSessionID));
        ht.put("isTransacted", String.valueOf(this.isTransacted));
        ht.put("ackMode", String.valueOf(this.acknowledgeMode));
        ht.put("dupsOkLimit", String.valueOf(this.dupsOkLimit));
        ht.put("isAckLimited", String.valueOf(this.isAckLimited));
        ht.put("ackLimit", String.valueOf(this.ackLimit));
        ht.put("ackCounter", String.valueOf(this.ackCounter));
        ht.put("xaTxnMode", String.valueOf(this.xaTxnMode));
        ht.put("rxCount", String.valueOf(this.TEST_rxCount));
        ht.put("ackCount", String.valueOf(this.TEST_ackCount));
        ht.put("isStopped", String.valueOf(this.isStopped));
        ht.put("# Consumers", String.valueOf(this.consumers.size()));
        int n = 0;
        Enumeration enum2 = this.consumers.elements();
        while (enum2.hasMoreElements()) {
            MessageConsumerImpl consumer = (MessageConsumerImpl)enum2.nextElement();
            ht.put("Consumer[" + n + "]", consumer.getDebugState(verbose));
            ++n;
        }
        ht.put("# Producers", String.valueOf(this.producers.size()));
        MessageProducerImpl[] _producers = this.producers.toArray(new MessageProducerImpl[this.producers.size()]);
        for (int i = 0; i < _producers.length; ++i) {
            ht.put("Producer[" + i + "]", _producers[i].getDebugState(verbose));
        }
        ht.put("unAckedMessageQueueSize", this.unAckedMessageQueue.size());
        if (verbose) {
            ht.put("unAckedMessageQueue", this.unAckedMessageQueue);
        }
        if ((ssq = this.sessionQueue) != null) {
            ht.put("sessionQueue", ssq.getDebugState(verbose));
        }
        if ((cc = this.connectionConsumer) != null) {
            ht.put("connectionConsumer", cc.getDebugState(verbose));
        }
        if ((ssr = this.serverSessionRunner) != null) {
            ht.put("serverSessionRunner", ssr.getDebugState(verbose));
        }
        return ht;
    }

    private void checkClientAckMessage(MessageImpl message) throws JMSException {
        Long id;
        if (this.connection.getBrokerProtocolLevel() < 350 && !this.consumers.containsKey(id = Long.valueOf(message.getInterestID()))) {
            String errorString = AdministeredObject.cr.getKString("C4058");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4058");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void removeUnAckedMessages(Long interestId) throws JMSException {
        int size = this.unAckedMessageQueue.size();
        if (size > 0) {
            int i;
            Vector<UnAckedMessage> removeq = new Vector<UnAckedMessage>();
            long consumerID = interestId;
            for (i = 0; i < size; ++i) {
                UnAckedMessage msg = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
                if (msg.getConsumerID() != consumerID) continue;
                removeq.addElement(msg);
            }
            for (i = 0; i < removeq.size(); ++i) {
                if (this.debug) {
                    Debug.println("removing msg from unackq: " + removeq.elementAt(i));
                }
                this.removeMessageFromAckList((UnAckedMessage)removeq.elementAt(i));
            }
        }
    }

    public void logLifeCycle(String key) {
        if (sessionLogger.isLoggable(Level.FINE)) {
            sessionLogger.log(Level.FINE, key, this);
        }
    }

    public String toString() {
        return "ConnectionID=" + this.connection.getConnectionID() + ", SessionID=" + this.brokerSessionID;
    }

    protected void recreateConsumers() throws JMSException {
        this.recreateConsumers(false);
    }

    protected void recreateConsumers(boolean fromXAResourceImpl) throws JMSException {
        try {
            int i;
            sessionLogger.finest("Re-creating consumers for the session: " + this.sessionId);
            Object[] savedConsumers = this.consumers.values().toArray();
            this.stopSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.stop(false);
            }
            this.sessionQueue.clear();
            for (i = 0; i < savedConsumers.length; ++i) {
                ((MessageConsumerImpl)savedConsumers[i]).receiveQueue.clear();
                ((MessageConsumerImpl)savedConsumers[i]).deregisterInterest();
                ((MessageConsumerImpl)savedConsumers[i]).logLifeCycle("I301");
            }
            if (this.unAckedMessageQueue != null) {
                this.unAckedMessageQueue.removeAllElements();
            }
            this.consumers.clear();
            if (!fromXAResourceImpl && this.isTransacted) {
                this.transaction.rollback();
            }
            for (i = 0; i < savedConsumers.length; ++i) {
                ((MessageConsumerImpl)savedConsumers[i]).registerInterest();
                ((MessageConsumerImpl)savedConsumers[i]).logLifeCycle("I300");
            }
            this.resumeSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.start();
            }
            this.remore_broker_failed = false;
            sessionLogger.finest("Consumers recreated for the session: " + this.sessionId);
        }
        catch (JMSException jmse) {
            sessionLogger.log(Level.SEVERE, jmse.getMessage(), jmse);
            throw jmse;
        }
    }

    public boolean _appCheckRemoteException(JMSException jmse) {
        if (jmse instanceof RemoteAcknowledgeException) {
            return this.isRemoteException(jmse);
        }
        Exception e = jmse.getLinkedException();
        if (e == null || !(e instanceof RemoteAcknowledgeException)) {
            return false;
        }
        return this.isRemoteException((JMSException)e);
    }

    protected boolean isRemoteException(JMSException jmse) {
        boolean isRemoteFailed = false;
        String errcode = jmse.getErrorCode();
        if ("C4110".equals(errcode) || "C4107".equals(errcode) || "C4108".equals(errcode) || "C4109".equals(errcode)) {
            if (SessionImpl.matchConsumerIDs((RemoteAcknowledgeException)jmse, this.consumers, sessionLogger)) {
                isRemoteFailed = true;
            }
        }
        return isRemoteFailed;
    }

    protected static boolean matchConsumerIDs(RemoteAcknowledgeException rae, Hashtable cons, Logger logger) {
        Hashtable prop = rae.getProperties();
        if (prop == null) {
            return false;
        }
        String cvalue = (String)prop.get("JMQRemoteConsumerIDs");
        if (cvalue == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(cvalue);
        while (st.hasMoreTokens()) {
            String cidstr = st.nextToken();
            Long cid = new Long(cidstr);
            Object obj = cons.get(cid);
            if (obj == null) continue;
            logger.finest("SessionImpl.matchConsumerIDs: Consumer ID matches: " + cidstr);
            return true;
        }
        return false;
    }

    public void setIsMessageListenerThread(boolean bool) {
        this.isMessageListener.set(bool);
    }

    public boolean isIsMessageListenerThread() {
        Boolean value = this.isMessageListener.get();
        if (value == null) {
            return false;
        }
        return value;
    }

    private static class UnAckedMessage {
        private SysMessageID mid = null;
        private long cid = -1L;

        private UnAckedMessage(MessageImpl message) {
            this.mid = message.getMessageID();
            this.cid = message.getInterestID();
        }

        public SysMessageID getMessageID() {
            return this.mid;
        }

        public long getConsumerID() {
            return this.cid;
        }

        public String toString() {
            return "mid:[" + (this.mid != null ? this.mid.toString() : "") + "] cid:" + this.cid;
        }
    }

    private class AsyncSendTimerEventHandler
    implements TimerEventHandler {
        @Override
        public void handleOOMError(Throwable e) {
            sessionLogger.log(Level.WARNING, "OutOfMemoryError occurred in AsyncSendListenerProcessor thread[" + SessionImpl.this.toString() + "]", e);
        }

        @Override
        public void handleLogInfo(String msg) {
            sessionLogger.log(Level.FINE, msg + "[" + SessionImpl.this.toString() + "]");
        }

        @Override
        public void handleLogWarn(String msg, Throwable e) {
            sessionLogger.log(Level.WARNING, msg + "[" + SessionImpl.this.toString() + "]", e);
        }

        @Override
        public void handleLogError(String msg, Throwable e) {
            sessionLogger.log(Level.WARNING, msg + "[" + SessionImpl.this.toString() + "]", e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTimerExit(Throwable e) {
            if (SessionImpl.this.isClosed) {
                return;
            }
            Object object = SessionImpl.this.asyncSendLock;
            synchronized (object) {
                SessionImpl.this.noAsyncSendCBProcessor = true;
            }
            String emsg = AdministeredObject.cr.getKString("E702");
            sessionLogger.log(Level.SEVERE, emsg + "[" + SessionImpl.this.toString() + "]", e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long runTask() {
            sessionLogger.log(Level.FINEST, "asyncSendCBProcessor start runTask[" + SessionImpl.this.toString() + "]");
            long ret = 0L;
            AsyncSendCallback cb2 = null;
            ArrayList<AsyncSendCallback> calls = new ArrayList<AsyncSendCallback>();
            Object object = SessionImpl.this.asyncSendLock;
            synchronized (object) {
                if (SessionImpl.this.asyncSends.size() == 0) {
                    sessionLogger.log(Level.FINEST, "asyncSendCBProcessor end runTask[" + SessionImpl.this.toString() + "] ret=0L");
                    return 0L;
                }
                Iterator itr = SessionImpl.this.asyncSends.iterator();
                while (itr.hasNext() && (cb2 = (AsyncSendCallback)itr.next()).hasSendReturned()) {
                    if (cb2.isCompleted() || cb2.isExceptioned()) {
                        calls.add(cb2);
                        continue;
                    }
                    if (!cb2.isOnAckWait()) break;
                    ret = SessionImpl.this.connection.getAsyncSendCompletionWaitTimeout();
                    if (!cb2.isTimedout()) {
                        cb2.startTimeoutTimer();
                        break;
                    }
                    calls.add(cb2);
                }
            }
            for (AsyncSendCallback cb2 : calls) {
                cb2.callCompletionListener();
            }
            calls.clear();
            sessionLogger.log(Level.FINEST, "asyncSendCBProcessor end runTask[" + SessionImpl.this.toString() + "] ret=" + ret);
            return ret;
        }
    }
}

