/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.store.RequestTraceStoreInterface;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;

public final class RequestTraceStoreCleanupTask
implements Runnable {
    private final long timeLimit;
    private final RequestTraceStoreInterface requestTraceStore;

    RequestTraceStoreCleanupTask(long timeLimit, RequestTraceStoreInterface requestTraceStore) {
        this.timeLimit = timeLimit;
        this.requestTraceStore = requestTraceStore;
    }

    @Override
    public void run() {
        Collection<RequestTrace> traces = this.requestTraceStore.getTraces();
        for (RequestTrace event : traces) {
            long upTimeInSeconds = event.getStartTime().until(Instant.now(), ChronoUnit.SECONDS);
            if (upTimeInSeconds <= this.timeLimit) continue;
            traces.remove(event);
        }
    }
}

