/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm.cdi;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import fish.payara.security.annotations.CertificateAuthenticationMechanismDefinition;
import fish.payara.security.annotations.CertificateIdentityStoreDefinition;
import fish.payara.security.annotations.FileIdentityStoreDefinition;
import fish.payara.security.annotations.PamIdentityStoreDefinition;
import fish.payara.security.annotations.RealmIdentityStoreDefinition;
import fish.payara.security.annotations.RealmIdentityStoreDefinitions;
import fish.payara.security.annotations.SolarisIdentityStoreDefinition;
import fish.payara.security.realm.RealmUtil;
import fish.payara.security.realm.config.CertificateRealmIdentityStoreConfiguration;
import fish.payara.security.realm.config.FileRealmIdentityStoreConfiguration;
import fish.payara.security.realm.config.PamRealmIdentityStoreConfiguration;
import fish.payara.security.realm.config.RealmConfiguration;
import fish.payara.security.realm.config.SolarisRealmIdentityStoreConfiguration;
import fish.payara.security.realm.identitystores.CertificateRealmIdentityStore;
import fish.payara.security.realm.identitystores.FileRealmIdentityStore;
import fish.payara.security.realm.identitystores.PamRealmIdentityStore;
import fish.payara.security.realm.identitystores.RealmIdentityStore;
import fish.payara.security.realm.identitystores.SolarisRealmIdentityStore;
import fish.payara.security.realm.mechanisms.CertificateAuthenticationMechanism;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.identitystore.IdentityStore;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.soteria.cdi.CdiProducer;
import org.glassfish.soteria.cdi.CdiUtils;

public class RealmExtension
implements Extension {
    private Bean<HttpAuthenticationMechanism> authenticationMechanismBean;
    private final Set<String> realms = new HashSet<String>();
    private final List<Bean<IdentityStore>> identityStoreBeans = new ArrayList<Bean<IdentityStore>>();
    private SecurityService securityService;
    private static final Logger LOGGER = Logger.getLogger(RealmExtension.class.getName());
    private static final Pattern SIMPLE_TEXT_PATTERN = Pattern.compile("[^a-z0-9 ]", 2);

    protected void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        this.addAnnotatedType(RealmIdentityStore.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(FileRealmIdentityStore.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(CertificateRealmIdentityStore.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(CertificateAuthenticationMechanism.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(PamRealmIdentityStore.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(SolarisRealmIdentityStore.class, manager, beforeBeanDiscovery);
    }

    protected <T> void addAnnotatedType(Class<T> type, BeanManager manager, BeforeBeanDiscovery beforeBeanDiscovery) {
        beforeBeanDiscovery.addAnnotatedType(manager.createAnnotatedType(type), type.getName());
    }

    protected <T> void findRealmDefinitionAnnotation(@Observes ProcessBean<T> eventIn, BeanManager beanManager) {
        ProcessBean<T> event = eventIn;
        Class beanClass = event.getBean().getBeanClass();
        this.findRealmIdentityStoreDefinitions(beanManager, event, beanClass);
        this.findFileIdentityStoreDefinitions(beanManager, event, beanClass);
        this.findCertificateIdentityStoreDefinitions(beanManager, event, beanClass);
        this.findCertificateAuthenticationMechanismDefinition(beanManager, event, beanClass);
        this.findPamIdentityStoreDefinitions(beanManager, event, beanClass);
        this.findSolarisIdentityStoreDefinitions(beanManager, event, beanClass);
    }

    private <T> void findRealmIdentityStoreDefinitions(BeanManager beanManager, ProcessBean<T> event, Class<?> beanClass) {
        Optional optionalStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), RealmIdentityStoreDefinition.class);
        optionalStore.ifPresent(definition -> {
            this.validateDefinition((RealmIdentityStoreDefinition)definition);
            this.logActivatedIdentityStore(RealmIdentityStore.class, beanClass);
            this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId((Object)(RealmIdentityStore.class + "-" + definition.value())).create(e -> {
                RealmIdentityStore mechanism = (RealmIdentityStore)CDI.current().select(RealmIdentityStore.class, new Annotation[0]).get();
                mechanism.setConfiguration((RealmIdentityStoreDefinition)definition);
                return mechanism;
            }));
        });
        Optional optionalStores = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), RealmIdentityStoreDefinitions.class);
        optionalStores.ifPresent(definitions -> {
            for (RealmIdentityStoreDefinition definition : definitions.value()) {
                this.validateDefinition(definition);
                this.logActivatedIdentityStore(RealmIdentityStore.class, beanClass);
                this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId((Object)(RealmIdentityStore.class + "-" + definition.value())).create(e -> {
                    RealmIdentityStore mechanism = (RealmIdentityStore)CDI.current().select(RealmIdentityStore.class, new Annotation[0]).get();
                    mechanism.setConfiguration(definition);
                    return mechanism;
                }));
            }
        });
    }

    private <T> void findFileIdentityStoreDefinitions(BeanManager beanManager, ProcessBean<T> event, Class<?> beanClass) {
        Optional optionalStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), FileIdentityStoreDefinition.class);
        optionalStore.ifPresent(definition -> {
            this.validateDefinition(definition.value(), FileRealmIdentityStore.REALM_CLASS, definition.jaasContext());
            this.logActivatedIdentityStore(FileRealmIdentityStore.class, beanClass);
            FileRealmIdentityStoreConfiguration configuration = FileRealmIdentityStoreConfiguration.from(definition);
            Properties props = new Properties();
            props.put("file", configuration.getFile());
            props.put("jaas-context", configuration.getJaasContext());
            this.createRealm(configuration, FileRealmIdentityStore.REALM_CLASS, FileRealmIdentityStore.REALM_LOGIN_MODULE_CLASS, props);
            this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId(FileRealmIdentityStore.class).create(e -> {
                FileRealmIdentityStore mechanism = (FileRealmIdentityStore)CDI.current().select(FileRealmIdentityStore.class, new Annotation[0]).get();
                mechanism.init(configuration);
                return mechanism;
            }));
        });
    }

    private <T> void findCertificateIdentityStoreDefinitions(BeanManager beanManager, ProcessBean<T> event, Class<?> beanClass) {
        Optional optionalStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), CertificateIdentityStoreDefinition.class);
        optionalStore.ifPresent(definition -> {
            this.validateDefinition(definition.value(), CertificateRealmIdentityStore.REALM_CLASS, null);
            this.logActivatedIdentityStore(CertificateRealmIdentityStore.class, beanClass);
            CertificateRealmIdentityStoreConfiguration configuration = CertificateRealmIdentityStoreConfiguration.from(definition);
            this.createRealm(configuration, CertificateRealmIdentityStore.REALM_CLASS, CertificateRealmIdentityStore.REALM_LOGIN_MODULE_CLASS, new Properties());
            this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId(CertificateRealmIdentityStore.class).create(e -> {
                CertificateRealmIdentityStore mechanism = (CertificateRealmIdentityStore)CDI.current().select(CertificateRealmIdentityStore.class, new Annotation[0]).get();
                mechanism.init(configuration);
                return mechanism;
            }));
        });
    }

    private <T> void findCertificateAuthenticationMechanismDefinition(BeanManager beanManager, ProcessBean<T> event, Class<?> beanClass) {
        Optional optionalStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), CertificateAuthenticationMechanismDefinition.class);
        optionalStore.ifPresent(definition -> {
            this.logActivatedAuthenticationMechanism(CertificateAuthenticationMechanism.class, beanClass);
            this.authenticationMechanismBean = new CdiProducer().scope(ApplicationScoped.class).beanClass(HttpAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class}).addToId(CertificateAuthenticationMechanism.class).create(e -> (CertificateAuthenticationMechanism)CDI.current().select(CertificateAuthenticationMechanism.class, new Annotation[0]).get());
        });
    }

    private <T> void findPamIdentityStoreDefinitions(BeanManager beanManager, ProcessBean<T> event, Class<?> beanClass) {
        Optional optionalStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), PamIdentityStoreDefinition.class);
        optionalStore.ifPresent(definition -> {
            this.validateDefinition(definition.value(), PamRealmIdentityStore.REALM_CLASS, definition.jaasContext());
            this.logActivatedIdentityStore(PamRealmIdentityStore.class, beanClass);
            PamRealmIdentityStoreConfiguration configuration = PamRealmIdentityStoreConfiguration.from(definition);
            Properties props = new Properties();
            props.put("jaas-context", configuration.getJaasContext());
            this.createRealm(configuration, PamRealmIdentityStore.REALM_CLASS, PamRealmIdentityStore.REALM_LOGIN_MODULE_CLASS, props);
            this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId(PamRealmIdentityStore.class).create(e -> {
                PamRealmIdentityStore mechanism = (PamRealmIdentityStore)CDI.current().select(PamRealmIdentityStore.class, new Annotation[0]).get();
                mechanism.init(configuration);
                return mechanism;
            }));
        });
    }

    private <T> void findSolarisIdentityStoreDefinitions(BeanManager beanManager, ProcessBean<T> event, Class<?> beanClass) {
        Optional optionalStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), SolarisIdentityStoreDefinition.class);
        optionalStore.ifPresent(definition -> {
            this.validateDefinition(definition.value(), SolarisRealmIdentityStore.REALM_CLASS, definition.jaasContext());
            this.logActivatedIdentityStore(SolarisRealmIdentityStore.class, beanClass);
            SolarisRealmIdentityStoreConfiguration configuration = SolarisRealmIdentityStoreConfiguration.from(definition);
            Properties props = new Properties();
            props.put("jaas-context", configuration.getJaasContext());
            this.createRealm(configuration, SolarisRealmIdentityStore.REALM_CLASS, SolarisRealmIdentityStore.REALM_LOGIN_MODULE_CLASS, props);
            this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId(SolarisRealmIdentityStore.class).create(e -> {
                SolarisRealmIdentityStore mechanism = (SolarisRealmIdentityStore)CDI.current().select(SolarisRealmIdentityStore.class, new Annotation[0]).get();
                mechanism.init(configuration);
                return mechanism;
            }));
        });
    }

    private <T> T createRealm(RealmConfiguration configuration, Class<T> realmClass, Class loginModuleClass, Properties props) {
        try {
            if (!Realm.isValidRealm((String)configuration.getName())) {
                if (!configuration.getAssignGroups().isEmpty()) {
                    props.put("assign-groups", String.join((CharSequence)",", configuration.getAssignGroups()));
                }
                RealmUtil.createAuthRealm(configuration.getName(), realmClass.getName(), loginModuleClass.getName(), props);
            }
            return realmClass.cast(Realm.getInstance((String)configuration.getName()));
        }
        catch (NoSuchRealmException ex) {
            throw new IllegalStateException(configuration.getName(), ex);
        }
    }

    private void validateDefinition(RealmIdentityStoreDefinition definition) {
        boolean authRealmFound;
        String realmName = definition.value();
        if (realmName.isEmpty()) {
            realmName = this.getSecurityService().getDefaultRealm();
        }
        if (!(authRealmFound = this.getSecurityService().getAuthRealm().stream().map(authRealm -> authRealm.getName()).anyMatch(realmName::equals))) {
            throw new IllegalStateException(String.format("[%s] No such realm found.", realmName));
        }
        if (!this.realms.add(realmName)) {
            throw new IllegalStateException(String.format("Duplicate realm name [%s] defined in RealmIdentityStoreDefinition.", definition.value()));
        }
    }

    private void validateDefinition(String realmName, Class realmClass, String jaasContext) {
        for (AuthRealm authRealm : this.getSecurityService().getAuthRealm()) {
            if (!authRealm.getName().equals(realmName) || authRealm.getClassname().equals(realmClass.getName())) continue;
            throw new IllegalStateException(String.format("%s realm can't be created for realm class %s, as already registed with realm class %s.", realmName, realmClass.getName(), authRealm.getClassname()));
        }
        if (jaasContext != null && SIMPLE_TEXT_PATTERN.matcher(jaasContext).find()) {
            throw new IllegalStateException(String.format("Special character not allowed in jaasContext %s.", jaasContext));
        }
    }

    private SecurityService getSecurityService() {
        if (this.securityService == null) {
            ServiceLocator serviceLocator = Globals.getDefaultHabitat();
            this.securityService = (SecurityService)serviceLocator.getService(SecurityService.class, new Annotation[0]);
        }
        return this.securityService;
    }

    protected void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.identityStoreBeans.isEmpty()) {
            this.identityStoreBeans.forEach(arg_0 -> ((AfterBeanDiscovery)afterBeanDiscovery).addBean(arg_0));
        }
        if (this.authenticationMechanismBean != null) {
            afterBeanDiscovery.addBean(this.authenticationMechanismBean);
        }
    }

    private void logActivatedIdentityStore(Class<?> identityStoreClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} identity store from {1} class", new Object[]{identityStoreClass.getName(), beanClass.getName()});
    }

    private void logActivatedAuthenticationMechanism(Class<?> authenticationMechanismClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} authentication mechanism from {1} class", new Object[]{authenticationMechanismClass.getName(), beanClass.getName()});
    }
}

