/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    private static final String ABORT_PROCESSING = "____EnD___";
    private static final String COLON = "____CoLoN___";
    private static final String COMMA = "____CoMmA___";
    private static final String NULL = "____NuLl___";

    public static Object jsonToJava(String json) {
        return JSONUtil.replaceSpecial(JSONUtil.jsonToJava(new JsonChars(json)));
    }

    public static String javaToJSON(Object obj, int depth) {
        if (depth == 0) {
            return "";
        }
        if (depth == -1) {
            depth = 10;
        }
        String value = "";
        if (obj == null) {
            value = "null";
        } else if (obj instanceof String) {
            StringCharacterIterator it = new StringCharacterIterator((String)obj);
            char ch = it.first();
            StringBuilder builder = new StringBuilder(((String)obj).length() << 2);
            builder.append("\"");
            while (ch != '\uffff') {
                switch (ch) {
                    case '\t': {
                        builder.append("\\t");
                        break;
                    }
                    case '\n': {
                        builder.append("\\n");
                        break;
                    }
                    case '\r': {
                        builder.append("\\r");
                        break;
                    }
                    case '\b': {
                        builder.append("\\b");
                        break;
                    }
                    case '\f': {
                        builder.append("\\f");
                        break;
                    }
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '\\': 
                    case '{': 
                    case '}': {
                        builder.append("\\");
                        builder.append(ch);
                        break;
                    }
                    default: {
                        JSONUtil.appendUnicodeEscaped(ch, builder);
                    }
                }
                ch = it.next();
            }
            builder.append("\"");
            value = builder.toString();
        } else if (obj instanceof Boolean || obj instanceof Number) {
            value = obj.toString();
        } else if (obj instanceof Object[]) {
            StringBuilder builder = new StringBuilder("[");
            boolean first = true;
            for (Object element : (Object[])obj) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                if (depth == 1) {
                    builder.append(JSONUtil.javaToJSON(element.toString(), 1));
                    continue;
                }
                builder.append(JSONUtil.javaToJSON(element, depth - 1));
            }
            builder.append("]");
            value = builder.toString();
        } else if (obj instanceof Map) {
            StringBuilder builder = new StringBuilder("{");
            boolean first = true;
            Map map = (Map)obj;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                String key = it.next().toString();
                builder.append(JSONUtil.javaToJSON(key, 1)).append(":");
                if (depth == 1) {
                    builder.append(JSONUtil.javaToJSON(map.get(key).toString(), 1));
                    continue;
                }
                builder.append(JSONUtil.javaToJSON(map.get(key), depth - 1));
            }
            builder.append("}");
            value = builder.toString();
        } else if (obj instanceof Collection) {
            StringBuilder builder = new StringBuilder("[");
            boolean first = true;
            Iterator it = ((Collection)obj).iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                if (depth == 1) {
                    builder.append(JSONUtil.javaToJSON(it.next().toString(), 1));
                    continue;
                }
                builder.append(JSONUtil.javaToJSON(it.next(), depth - 1));
            }
            builder.append("]");
            value = builder.toString();
        } else {
            StringBuilder builder = new StringBuilder("{");
            boolean first = true;
            Iterator<String> it = JSONUtil.getGetters(obj).iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                String methodName = it.next();
                builder.append(JSONUtil.javaToJSON(methodName.substring(3), 1)).append(":");
                Object result = JSONUtil.invokeGetter(obj, methodName);
                if (result != null && depth == 1) {
                    builder.append(JSONUtil.javaToJSON(result.toString(), 1));
                    continue;
                }
                builder.append(JSONUtil.javaToJSON(result, depth - 1));
            }
            builder.append("}");
            value = builder.toString();
        }
        return value;
    }

    public static void appendUnicodeEscaped(char ch, StringBuilder builder) {
        if (ch > '~' || ch < ' ') {
            builder.append("\\u");
            String chStr = Integer.toHexString(ch);
            int len = chStr.length();
            for (int idx = 4; idx > len; --idx) {
                builder.append('0');
            }
            builder.append(chStr);
        } else {
            builder.append(ch);
        }
    }

    private static Object invokeGetter(Object obj, String methodName) {
        try {
            return obj.getClass().getMethod(methodName, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static List<String> getGetters(Object obj) {
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : obj.getClass().getMethods()) {
            if (!method.getName().startsWith("get") || (method.getModifiers() & 1) == 0 || method.getParameterTypes().length != 0 || method.getName().equals("getClass") || method.getReturnType() == Void.TYPE) continue;
            result.add(method.getName());
        }
        return result;
    }

    private static Object jsonToJava(JsonChars json) {
        Object value = null;
        block13: while (json.hasNext() && value == null) {
            char ch = json.next();
            switch (ch) {
                case '{': {
                    value = JSONUtil.readObject(json);
                    continue block13;
                }
                case '[': {
                    value = JSONUtil.readArray(json);
                    continue block13;
                }
                case ']': 
                case '}': {
                    if (json.isAtContextEnd()) {
                        value = ABORT_PROCESSING;
                        continue block13;
                    }
                    throw new IllegalArgumentException("Expected '" + json.peekContextEnd() + "' but found '" + json.current() + "' instead!");
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = JSONUtil.readNumber(json);
                    continue block13;
                }
                case '\"': 
                case '\'': {
                    value = JSONUtil.readString(json);
                    continue block13;
                }
                case 'T': 
                case 't': {
                    value = JSONUtil.readConstant(json, "true");
                    continue block13;
                }
                case 'F': 
                case 'f': {
                    value = JSONUtil.readConstant(json, "false");
                    continue block13;
                }
                case 'N': 
                case 'n': {
                    value = JSONUtil.readConstant(json, "null");
                    continue block13;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block13;
                }
                case ':': {
                    value = COLON;
                    continue block13;
                }
                case ',': {
                    value = COMMA;
                    continue block13;
                }
            }
            throw new IllegalArgumentException("Unexpected char '" + json.current() + "' near: " + json.getContext(30) + "!");
        }
        return value;
    }

    private static Map<String, Object> readObject(JsonChars json) {
        json.pushContextEnd('}');
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        Object tmp = null;
        Object key = null;
        Object value = null;
        while (!json.isAtContextEnd()) {
            key = JSONUtil.replaceSpecial(JSONUtil.jsonToJava(json));
            if (json.isAtContextEnd()) break;
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Object keys must be a String!");
            }
            if (!JSONUtil.jsonToJava(json).equals(COLON)) {
                throw new IllegalArgumentException("Object keys must be followed by a colon (:)!");
            }
            value = JSONUtil.replaceSpecial(JSONUtil.jsonToJava(json));
            tmp = JSONUtil.jsonToJava(json);
            if (!tmp.equals(COMMA) && !json.isAtContextEnd()) {
                throw new IllegalArgumentException("Expected comma (,) or end curly brace (}), but found (" + tmp + ") instead!  Near: (" + json.getContext(30) + ")");
            }
            map.put((String)key, value);
        }
        json.popContextEnd();
        return map;
    }

    private static List<Object> readArray(JsonChars json) {
        json.pushContextEnd(']');
        ArrayList<Object> list = new ArrayList<Object>(10);
        Object tmp = null;
        Object value = null;
        while (!json.isAtContextEnd()) {
            value = JSONUtil.replaceSpecial(JSONUtil.jsonToJava(json));
            if (!(json.isAtContextEnd() || (tmp = JSONUtil.jsonToJava(json)).equals(COMMA) || json.isAtContextEnd())) {
                throw new IllegalArgumentException("Expected comma (,) or end curly brace (}), but found (" + tmp + ") instead!");
            }
            if (value != null && value.equals(ABORT_PROCESSING)) continue;
            list.add(value);
        }
        json.popContextEnd();
        return list;
    }

    private static String readString(JsonChars json) {
        json.pushContextEnd(json.current());
        StringBuilder builder = new StringBuilder();
        int ch = json.next();
        block9: while (!json.isAtContextEnd()) {
            if (ch == 92) {
                ch = json.next();
                switch (ch) {
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 117: {
                        builder.appendCodePoint(Integer.parseInt("" + json.next() + json.next() + json.next() + json.next()));
                        continue block9;
                    }
                    case 34: 
                    case 39: 
                    case 47: 
                    case 92: {
                        break;
                    }
                }
            }
            builder.append((char)ch);
            ch = json.next();
        }
        json.popContextEnd();
        return builder.toString();
    }

    private static Object readNumber(JsonChars json) {
        StringBuilder builder = new StringBuilder();
        char ch = json.current();
        if (ch == '-') {
            builder.append('-');
            ch = json.next();
        }
        boolean hasDecimal = false;
        boolean hasExp = false;
        boolean done = false;
        block7: while (!done) {
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    builder.append(ch);
                    break;
                }
                case '.': {
                    if (hasDecimal) {
                        throw new IllegalArgumentException("Error while parsing number!  Found multiple decimal points.");
                    }
                    hasDecimal = true;
                    builder.append(ch);
                    break;
                }
                case 'E': 
                case 'e': {
                    if (hasExp) {
                        throw new IllegalArgumentException("An attempt was made to parse an Long value, however, it was malformed (had to exponents).");
                    }
                    hasExp = true;
                    builder.append(ch);
                    ch = json.next();
                    if (ch == '-' || ch == '+') {
                        builder.append(ch);
                        ch = json.next();
                    }
                    if (ch < '0' || ch > '9') {
                        throw new IllegalArgumentException("Required a digit after an exponent, however received: '" + ch + "'.");
                    }
                    builder.append(ch);
                    break;
                }
                default: {
                    done = true;
                    continue block7;
                }
            }
            try {
                ch = json.next();
            }
            catch (IndexOutOfBoundsException ioobe) {
                done = true;
            }
        }
        json.unread();
        return hasDecimal || hasExp ? (Number)Float.valueOf(builder.toString()) : (Number)Long.valueOf(builder.toString());
    }

    private static Object readConstant(JsonChars json, String constant) {
        byte[] good = constant.getBytes();
        int len = good.length;
        for (int idx = 1; idx < len; ++idx) {
            char ch = json.next();
            if (ch == good[idx]) continue;
            throw new IllegalArgumentException("Expected constant (" + constant + ")!");
        }
        return constant.equals("null") ? NULL : Boolean.valueOf(constant);
    }

    private static Object replaceSpecial(Object val) {
        if (val instanceof String) {
            String strVal;
            switch (strVal = (String)val) {
                case "____CoLoN___": {
                    val = Character.valueOf(':');
                    break;
                }
                case "____CoMmA___": {
                    val = Character.valueOf(',');
                    break;
                }
                case "____NuLl___": {
                    val = null;
                }
            }
        }
        return val;
    }

    static class JsonChars {
        private String string;
        private int len;
        private int loc = 0;
        private Deque<Character> endContext = new ArrayDeque<Character>();

        JsonChars(String json) {
            this.string = json;
            this.len = this.string.length();
        }

        char current() {
            return this.string.charAt(this.loc - 1);
        }

        char next() {
            return this.string.charAt(this.loc++);
        }

        void unread() {
            --this.loc;
        }

        String getContext(int width) {
            int after;
            int before = this.loc - width;
            if (this.loc < 0) {
                this.loc = 0;
            }
            if (before < 0) {
                before = 0;
            }
            if ((after = this.loc + width) > this.len) {
                after = this.len;
            }
            return this.string.substring(before, after - before);
        }

        int getLength() {
            return this.len;
        }

        boolean hasNext() {
            return this.loc < this.len;
        }

        boolean isAtContextEnd() {
            return !this.hasNext() || this.string.charAt(this.loc - 1) == this.endContext.peek().charValue();
        }

        void pushContextEnd(char end) {
            this.endContext.push(Character.valueOf(end));
        }

        char popContextEnd() {
            return this.endContext.pop().charValue();
        }

        char peekContextEnd() {
            return this.endContext.peek().charValue();
        }
    }
}

