/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.handlers.UtilHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

public class InstanceHandler {
    private static final String SELECTED = "selected";
    private static final String PROFILER = "profiler";
    static final String TARGET = "target";
    static final String MAX_VERSION = "maxVersion";
    static final String MIN_VERSION = "minVersion";
    static final String JVM_OPTION = "jvmOption";

    public static void getJvmOptionsValues(HandlerContext handlerCtx) {
        block3: {
            try {
                List<Map<String, String>> list = InstanceHandler.getJvmOptions(handlerCtx);
                ArrayList<HashMap<String, String>> optionValues = new ArrayList<HashMap<String, String>>();
                for (Map<String, String> item : list) {
                    HashMap<String, String> valueMap = new HashMap<String, String>(item);
                    valueMap.put(SELECTED, (String)((Object)Boolean.valueOf(false)));
                    optionValues.add(valueMap);
                }
                handlerCtx.setOutputValue("result", optionValues);
            }
            catch (Exception ex) {
                handlerCtx.setOutputValue("result", new ArrayList());
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getJvmOptionsValues") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static List<Map<String, String>> getJvmOptions(HandlerContext handlerCtx) {
        Map attrs;
        Map result;
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        if (!endpoint.endsWith(".json")) {
            endpoint = endpoint + ".json";
        }
        ArrayList list = (result = (Map)RestUtil.restRequest(endpoint, attrs = (Map)handlerCtx.getInputValue("attrs"), "get", handlerCtx, false).get("data")) == null ? new ArrayList() : (ArrayList)((Map)result.get("extraProperties")).get("leafList");
        return list;
    }

    public static void saveJvmOptionValues(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String target = (String)handlerCtx.getInputValue(TARGET);
        try {
            List options = (List)handlerCtx.getInputValue("options");
            ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>();
            for (Map oneRow : options) {
                HashMap newRow = new HashMap();
                oneRow.forEach((key, value) -> {
                    if (!SELECTED.equalsIgnoreCase((String)key)) {
                        newRow.put(key, value);
                    }
                });
                newList.add(newRow);
            }
            List<Map<String, String>> oldList = InstanceHandler.getJvmOptions(handlerCtx);
            if (newList.equals(oldList)) {
                return;
            }
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put(PROFILER, (String)handlerCtx.getInputValue(PROFILER));
            InstanceHandler.prepareJvmOptionPayload(payload, target, newList);
            RestUtil.restRequest(endpoint, payload, "POST", handlerCtx, false, true);
        }
        catch (Exception ex) {
            String deleteProfileEndpoint = (String)handlerCtx.getInputValue("deleteProfileEndpoint");
            if (!GuiUtil.isEmpty(deleteProfileEndpoint)) {
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                attrMap.put(TARGET, (String)handlerCtx.getInputValue(TARGET));
                RestUtil.restRequest(deleteProfileEndpoint, attrMap, "DELETE", handlerCtx, false, false);
            }
            List origList = (List)handlerCtx.getInputValue("origList");
            HashMap<String, Object> payload1 = new HashMap<String, Object>();
            if (endpoint.contains(PROFILER)) {
                payload1.put(PROFILER, "true");
            }
            if (origList != null && origList.size() > 0) {
                InstanceHandler.prepareJvmOptionPayload(payload1, target, origList);
                RestUtil.restRequest(endpoint, payload1, "POST", handlerCtx, false, false);
            }
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void prepareJvmOptionPayload(Map<String, Object> payload, String target, List<Map<String, Object>> options) {
        payload.put(TARGET, target);
        for (Map<String, Object> oneRow : options) {
            String jvmOptionUnescaped = new MiniXmlParser.JvmOption((String)oneRow.get(JVM_OPTION), (String)oneRow.get(MIN_VERSION), (String)oneRow.get(MAX_VERSION)).toString();
            String jvmOptionEscape = UtilHandlers.escapePropertyValue(jvmOptionUnescaped);
            ArrayList<String> kv = InstanceHandler.getKeyValuePair(jvmOptionEscape);
            payload.put(kv.get(0), kv.get(1));
        }
    }

    public static ArrayList<String> getKeyValuePair(String str) {
        ArrayList<String> list = new ArrayList<String>(2);
        int index = str.indexOf(61);
        String key = "";
        String value = "";
        if (index != -1) {
            key = str.substring(0, str.indexOf(61));
            value = str.substring(str.indexOf(61) + 1, str.length());
        } else {
            key = str;
        }
        if (key.startsWith("-XX:")) {
            key = "\"" + key + "\"";
        }
        list.add(0, key);
        list.add(1, value);
        return list;
    }
}

