/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.BaseAuthConfigImpl;
import com.sun.jaspic.config.helper.BaseAuthContextImpl;
import com.sun.jaspic.config.helper.EpochCarrier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;

public class ServerAuthConfigImpl
extends BaseAuthConfigImpl
implements ServerAuthConfig {
    private static final AuthStatus[] validateRequestSuccessValues = new AuthStatus[]{AuthStatus.SUCCESS, AuthStatus.SEND_SUCCESS};
    private static final AuthStatus[] secureResponseSuccessValues = new AuthStatus[]{AuthStatus.SEND_SUCCESS};
    private Map<String, Map<Integer, ServerAuthContext>> contextMap;
    private BaseAuthContextImpl authContextHelperHelper;

    protected ServerAuthConfigImpl(String loggerName, EpochCarrier providerEpoch, BaseAuthContextImpl authContextHelper, MessagePolicyDelegate policyDelegate, String layer, String appContext, CallbackHandler cbh) throws AuthException {
        super(loggerName, providerEpoch, policyDelegate, layer, appContext, cbh);
        this.authContextHelperHelper = authContextHelper;
        this.policyDelegate = policyDelegate;
    }

    @Override
    protected void initializeContextMap() {
        this.contextMap = new HashMap<String, Map<Integer, ServerAuthContext>>();
    }

    @Override
    protected <M> M createAuthContext(final String authContextID, final Map<String, ?> properties) throws AuthException {
        if (!this.authContextHelperHelper.isProtected(new ServerAuthModule[0], authContextID)) {
            return null;
        }
        return (M)new ServerAuthContext(){
            ServerAuthModule[] module = this.init();

            ServerAuthModule[] init() throws AuthException {
                ServerAuthModule[] serverAuthModules;
                try {
                    serverAuthModules = ServerAuthConfigImpl.this.authContextHelperHelper.getModules(new ServerAuthModule[0], authContextID);
                }
                catch (AuthException ae) {
                    ServerAuthConfigImpl.this.logIfLevel(Level.SEVERE, ae, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigImpl.this.getAppContext(), "unable to load server auth modules");
                    throw ae;
                }
                MessagePolicy requestPolicy = ServerAuthConfigImpl.this.policyDelegate.getRequestPolicy(authContextID, properties);
                MessagePolicy responsePolicy = ServerAuthConfigImpl.this.policyDelegate.getResponsePolicy(authContextID, properties);
                boolean noModules = true;
                for (int i = 0; i < serverAuthModules.length; ++i) {
                    if (serverAuthModules[i] == null) continue;
                    if (ServerAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigImpl.this.getAppContext(), "initializing module");
                    }
                    noModules = false;
                    ServerAuthConfigImpl.this.checkMessageTypes(serverAuthModules[i].getSupportedMessageTypes());
                    serverAuthModules[i].initialize(requestPolicy, responsePolicy, ServerAuthConfigImpl.this.callbackHandler, ServerAuthConfigImpl.this.authContextHelperHelper.getInitProperties(i, properties));
                }
                if (noModules) {
                    ServerAuthConfigImpl.this.logIfLevel(Level.WARNING, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigImpl.this.getAppContext(), "contains no Auth Modules");
                }
                return serverAuthModules;
            }

            @Override
            public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ServerAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigImpl.this.getAppContext(), "calling vaidateRequest on module");
                    }
                    status[i] = this.module[i].validateRequest(messageInfo, clientSubject, serviceSubject);
                    if (!ServerAuthConfigImpl.this.authContextHelperHelper.exitContext(validateRequestSuccessValues, i, status[i])) continue;
                    return ServerAuthConfigImpl.this.authContextHelperHelper.getReturnStatus(validateRequestSuccessValues, AuthStatus.SEND_FAILURE, status, i);
                }
                return ServerAuthConfigImpl.this.authContextHelperHelper.getReturnStatus(validateRequestSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            @Override
            public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ServerAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigImpl.this.getAppContext(), "calling secureResponse on module");
                    }
                    status[i] = this.module[i].secureResponse(messageInfo, serviceSubject);
                    if (!ServerAuthConfigImpl.this.authContextHelperHelper.exitContext(secureResponseSuccessValues, i, status[i])) continue;
                    return ServerAuthConfigImpl.this.authContextHelperHelper.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, i);
                }
                return ServerAuthConfigImpl.this.authContextHelperHelper.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            @Override
            public void cleanSubject(MessageInfo arg0, Subject arg1) throws AuthException {
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ServerAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigImpl.this.getAppContext(), "calling cleanSubject on module");
                    }
                    this.module[i].cleanSubject(arg0, arg1);
                }
            }
        };
    }

    @Override
    public ServerAuthContext getAuthContext(String authContextID, Subject subject, Map properties) throws AuthException {
        return (ServerAuthContext)super.getContext(this.contextMap, authContextID, subject, properties);
    }

    @Override
    public boolean isProtected() {
        return !this.authContextHelperHelper.returnsNullContexts() || this.policyDelegate.isProtected();
    }
}

