/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.factory;

import com.sun.jaspic.config.factory.EntryInfo;
import com.sun.jaspic.config.factory.RegistrationContextImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.config.AuthConfigFactory;

public final class RegStoreFileParser {
    private static final Logger logger = Logger.getLogger("enterprise.system.jaspic.security", "com.sun.logging.enterprise.system.jaspic.security.LogStrings");
    private static final String SEP = ":";
    private static final String CON_ENTRY = "con-entry";
    private static final String REG_ENTRY = "reg-entry";
    private static final String REG_CTX = "reg-ctx";
    private static final String LAYER = "layer";
    private static final String APP_CTX = "app-ctx";
    private static final String DESCRIPTION = "description";
    private static final String[] INDENT = new String[]{"", "  ", "    "};
    private final File configurationFile;
    private List<EntryInfo> entries;
    private List<EntryInfo> defaultEntries;

    public RegStoreFileParser(String pathParent, String pathChild, List<EntryInfo> defaultEntries) {
        this.configurationFile = new File(pathParent, pathChild);
        this.defaultEntries = defaultEntries == null ? new ArrayList() : defaultEntries;
        try {
            this.loadEntries();
        }
        catch (IOException ioe) {
            this.logWarningDefault(ioe);
        }
        catch (IllegalArgumentException iae) {
            this.logWarningDefault(iae);
        }
    }

    List<EntryInfo> getPersistedEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(String className, AuthConfigFactory.RegistrationContext registrationContext, Map<String, String> properties) {
        File file = this.configurationFile;
        synchronized (file) {
            if (this.checkAndAddToList(className, registrationContext, properties)) {
                try {
                    this.writeEntries();
                }
                catch (IOException ioe) {
                    this.logWarningUpdated(ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(AuthConfigFactory.RegistrationContext registrationContext) {
        File file = this.configurationFile;
        synchronized (file) {
            if (this.checkAndRemoveFromList(registrationContext)) {
                try {
                    this.writeEntries();
                }
                catch (IOException ioe) {
                    this.logWarningUpdated(ioe);
                }
            }
        }
    }

    private boolean checkAndAddToList(String className, AuthConfigFactory.RegistrationContext registrationContext, Map<String, String> properties) {
        EntryInfo newEntry;
        EntryInfo entry;
        if (properties != null && properties.isEmpty()) {
            properties = null;
        }
        if ((entry = this.getMatchingRegistrationEntry(newEntry = new EntryInfo(className, properties, registrationContext))) == null) {
            this.entries.add(newEntry);
            return true;
        }
        if (entry.getRegistrationContexts().contains(registrationContext)) {
            return false;
        }
        entry.getRegistrationContexts().add(new RegistrationContextImpl(registrationContext));
        return true;
    }

    private boolean checkAndRemoveFromList(AuthConfigFactory.RegistrationContext target) {
        boolean retValue = false;
        try {
            ListIterator<EntryInfo> lit = this.entries.listIterator();
            while (lit.hasNext()) {
                EntryInfo info = lit.next();
                if (info.isConstructorEntry()) continue;
                Iterator<AuthConfigFactory.RegistrationContext> iter = info.getRegistrationContexts().iterator();
                while (iter.hasNext()) {
                    AuthConfigFactory.RegistrationContext ctx = iter.next();
                    if (!ctx.equals(target)) continue;
                    iter.remove();
                    if (info.getRegistrationContexts().isEmpty()) {
                        lit.remove();
                    }
                    retValue = true;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retValue;
    }

    private EntryInfo getMatchingRegistrationEntry(EntryInfo target) {
        for (EntryInfo info : this.entries) {
            if (info.isConstructorEntry() || !info.matchConstructors(target)) continue;
            return info;
        }
        return null;
    }

    private void writeEntries() throws IOException {
        if (this.configurationFile.exists() && !this.configurationFile.canWrite() && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jaspic.factory_cannot_write_file", this.configurationFile.getPath());
        }
        this.clearExistingFile();
        PrintWriter out = new PrintWriter(this.configurationFile);
        int indent = 0;
        for (EntryInfo info : this.entries) {
            if (info.isConstructorEntry()) {
                this.writeConEntry(info, out, indent);
                continue;
            }
            this.writeRegEntry(info, out, indent);
        }
        out.close();
    }

    private void writeConEntry(EntryInfo info, PrintWriter out, int i) {
        out.println(INDENT[i++] + CON_ENTRY + " {");
        out.println(INDENT[i] + info.getClassName());
        Map<String, String> properties = info.getProperties();
        if (properties != null) {
            for (Map.Entry<String, String> val : properties.entrySet()) {
                out.println(INDENT[i] + val.getKey() + SEP + val.getValue());
            }
        }
        out.println(INDENT[--i] + "}");
    }

    private void writeRegEntry(EntryInfo info, PrintWriter out, int i) {
        out.println(INDENT[i++] + REG_ENTRY + " {");
        if (info.getClassName() != null) {
            this.writeConEntry(info, out, i);
        }
        for (AuthConfigFactory.RegistrationContext registrationContext : info.getRegistrationContexts()) {
            out.println(INDENT[i++] + REG_CTX + " {");
            if (registrationContext.getMessageLayer() != null) {
                out.println(INDENT[i] + LAYER + SEP + registrationContext.getMessageLayer());
            }
            if (registrationContext.getAppContext() != null) {
                out.println(INDENT[i] + APP_CTX + SEP + registrationContext.getAppContext());
            }
            if (registrationContext.getDescription() != null) {
                out.println(INDENT[i] + DESCRIPTION + SEP + registrationContext.getDescription());
            }
            out.println(INDENT[--i] + "}");
        }
        out.println(INDENT[--i] + "}");
    }

    private void clearExistingFile() throws IOException {
        boolean newCreation;
        boolean bl = newCreation = !this.configurationFile.exists();
        if (!newCreation && !this.configurationFile.delete()) {
            throw new IOException();
        }
        if (newCreation) {
            logger.log(Level.INFO, "jaspic.factory_creating_conf_file", this.configurationFile.getPath());
        }
        if (!this.configurationFile.createNewFile()) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntries() throws IOException {
        File file = this.configurationFile;
        synchronized (file) {
            this.entries = new ArrayList<EntryInfo>();
            if (this.configurationFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(this.configurationFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        String trimLine = line.trim();
                        if (trimLine.startsWith(CON_ENTRY)) {
                            this.entries.add(this.readConEntry(reader));
                        } else if (trimLine.startsWith(REG_ENTRY)) {
                            this.entries.add(this.readRegEntry(reader));
                        }
                        line = reader.readLine();
                    }
                }
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "jaspic.factory_file_not_found", this.configurationFile.getParent() + File.pathSeparator + this.configurationFile.getPath());
                }
                for (EntryInfo entry : this.defaultEntries) {
                    this.entries.add(new EntryInfo(entry));
                }
            }
        }
    }

    private EntryInfo readConEntry(BufferedReader reader) throws IOException {
        String className = reader.readLine();
        if (className != null) {
            className = className.trim();
        }
        return new EntryInfo(className, this.readProperties(reader));
    }

    private Map<String, String> readProperties(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        if ("}".equals(line)) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        while (!"}".equals(line)) {
            properties.put(line.substring(0, line.indexOf(SEP)), line.substring(line.indexOf(SEP) + 1, line.length()));
            line = reader.readLine();
            if (line == null) continue;
            line = line.trim();
        }
        return properties;
    }

    private EntryInfo readRegEntry(BufferedReader reader) throws IOException {
        String className = null;
        Map<String, String> properties = null;
        ArrayList<AuthConfigFactory.RegistrationContext> ctxs = new ArrayList<AuthConfigFactory.RegistrationContext>();
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (!"}".equals(line)) {
            if (line.startsWith(CON_ENTRY)) {
                EntryInfo conEntry = this.readConEntry(reader);
                className = conEntry.getClassName();
                properties = conEntry.getProperties();
            } else if (line.startsWith(REG_CTX)) {
                ctxs.add(this.readRegContext(reader));
            }
            if ((line = reader.readLine()) == null) continue;
            line = line.trim();
        }
        return new EntryInfo(className, properties, ctxs);
    }

    private AuthConfigFactory.RegistrationContext readRegContext(BufferedReader reader) throws IOException {
        String layer = null;
        String appCtx = null;
        String description = null;
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (!"}".equals(line)) {
            String value = line.substring(line.indexOf(SEP) + 1, line.length());
            if (line.startsWith(LAYER)) {
                layer = value;
            } else if (line.startsWith(APP_CTX)) {
                appCtx = value;
            } else if (line.startsWith(DESCRIPTION)) {
                description = value;
            }
            if ((line = reader.readLine()) == null) continue;
            line = line.trim();
        }
        return new RegistrationContextImpl(layer, appCtx, description, true);
    }

    private void logWarningUpdated(Exception exception) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jaspic.factory_could_not_persist", exception.toString());
        }
    }

    private void logWarningDefault(Exception exception) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jaspic.factory_could_not_read", exception.toString());
        }
    }
}

