/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing.jaxws;

import com.oracle.webservices.api.message.MessageContext;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTracingService;
import fish.payara.opentracing.jaxws.OpenTracingJaxwsCdiUtils;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.soap.SOAPException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.opentracing.Traced;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.webservices.monitoring.MonitorContext;
import org.glassfish.webservices.monitoring.MonitorFilter;
import org.jvnet.hk2.annotations.Service;

@Service(name="jaxws-opentracing-filter")
public class JaxwsContainerRequestTracingFilter
implements MonitorFilter {
    private static final Logger logger = Logger.getLogger(JaxwsContainerRequestTracingFilter.class.getName());
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private RequestTracingService requestTracing;
    @Inject
    private OpenTracingService openTracing;

    public void filterRequest(Packet pipeRequest, MonitorContext monitorContext) {
        if (this.isTraceInProgress()) {
            Traced tracedAnnotation = this.getTraceAnnotation(monitorContext);
            if (this.shouldTrace(pipeRequest) && this.shouldTrace(monitorContext, tracedAnnotation)) {
                Tracer tracer = this.getTracer();
                HttpServletRequest httpRequest = (HttpServletRequest)pipeRequest.get((Object)"javax.xml.ws.servlet.request");
                Tracer.SpanBuilder spanBuilder = tracer.buildSpan(this.determineOperationName(pipeRequest, monitorContext, tracedAnnotation)).withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.HTTP_METHOD.getKey(), httpRequest.getMethod()).withTag(Tags.HTTP_URL.getKey(), httpRequest.getRequestURL().toString()).withTag(Tags.COMPONENT.getKey(), "jaxws");
                SpanContext spanContext = null;
                try {
                    spanContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap(this.getHeaders(httpRequest)));
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, e.getMessage());
                }
                if (spanContext != null) {
                    spanBuilder.asChildOf(spanContext);
                }
                Scope scope = tracer.activateSpan(spanBuilder.start());
                httpRequest.setAttribute(Scope.class.getName(), (Object)scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void filterResponse(Packet pipeRequest, Packet pipeResponse, MonitorContext monitorContext) {
        try {
            if (!this.isTraceInProgress()) return;
            Traced tracedAnnotation = this.getTraceAnnotation(monitorContext);
            if (!this.shouldTrace(pipeRequest)) return;
            if (!this.shouldTrace(monitorContext, tracedAnnotation)) return;
            Span activeSpan = this.getTracer().scopeManager().activeSpan();
            if (activeSpan == null) {
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)pipeRequest.get((Object)"javax.xml.ws.servlet.request");
            try {
                Response.StatusType statusInfo = this.getResponseStatus(pipeRequest, pipeRequest);
                activeSpan.setTag(Tags.HTTP_STATUS.getKey(), (Number)statusInfo.getStatusCode());
                if (statusInfo.getFamily() != Response.Status.Family.CLIENT_ERROR) {
                    if (statusInfo.getFamily() != Response.Status.Family.SERVER_ERROR) return;
                }
                activeSpan.setTag(Tags.ERROR.getKey(), true);
                activeSpan.log(Collections.singletonMap("event", "error"));
                Message message = pipeResponse.getMessage();
                if (message == null) return;
                if (!message.isFault()) return;
                activeSpan.log(Collections.singletonMap("error.object", this.getErrorObject(message)));
                return;
            }
            finally {
                activeSpan.finish();
                Object scopeObj = httpRequest.getAttribute(Scope.class.getName());
                if (scopeObj != null && scopeObj instanceof Scope) {
                    try (Scope scope = (Scope)scopeObj;){
                        httpRequest.removeAttribute(Scope.class.getName());
                    }
                }
            }
        }
        finally {
            Object errorObject;
            Message message = pipeResponse.getMessage();
            if (message != null && message.isFault() && (errorObject = this.getErrorObject(message)) != null) {
                logger.log(Level.SEVERE, this.getErrorObject(message).toString());
            }
        }
    }

    private Object getErrorObject(Message message) {
        try {
            return message.copy().readAsSOAPMessage().getSOAPBody().getFault();
        }
        catch (SOAPException e) {
            logger.log(Level.SEVERE, "Error while reading fault from message ", e);
            return null;
        }
    }

    private String determineOperationName(Packet pipeRequest, MonitorContext monitorContext, Traced tracedAnnotation) {
        HttpServletRequest httpRequest = (HttpServletRequest)pipeRequest.get((Object)"javax.xml.ws.servlet.request");
        if (tracedAnnotation != null) {
            String operationName = OpenTracingJaxwsCdiUtils.getConfigOverrideValue(Traced.class, "operationName", monitorContext, String.class).orElse(tracedAnnotation.operationName());
            if (operationName.equals("")) {
                operationName = this.createFallbackName(httpRequest, monitorContext);
            }
            return operationName;
        }
        Config config = this.getConfig();
        Optional operationNameProviderOptional = config.getOptionalValue("mp.opentracing.server.operation-name-provider", String.class);
        if (operationNameProviderOptional.isPresent()) {
            String operationNameProvider = (String)operationNameProviderOptional.get();
            WebService classLevelAnnotation = monitorContext.getImplementationClass().getAnnotation(WebService.class);
            WebMethod methodLevelAnnotation = monitorContext.getCallInfo().getMethod().getAnnotation(WebMethod.class);
            if (operationNameProvider.equals("http-path") && classLevelAnnotation != null) {
                String operationName = httpRequest.getMethod() + ":";
                operationName = operationName + "/" + classLevelAnnotation.name();
                if (methodLevelAnnotation != null) {
                    operationName = operationName + "/" + methodLevelAnnotation.operationName();
                }
                return operationName;
            }
        }
        return this.createFallbackName(httpRequest, monitorContext);
    }

    private String createFallbackName(HttpServletRequest httpRequest, MonitorContext monitorContext) {
        return httpRequest.getMethod() + ":" + monitorContext.getImplementationClass().getCanonicalName() + "." + monitorContext.getCallInfo().getMethod().getName();
    }

    private boolean shouldTrace(Packet pipeRequest) {
        HttpServletRequest httpRequest = (HttpServletRequest)pipeRequest.get((Object)"javax.xml.ws.servlet.request");
        return this.shouldTrace(httpRequest.getContextPath());
    }

    private boolean shouldTrace(MonitorContext monitorContext, Traced tracedAnnotation) {
        if (tracedAnnotation == null) {
            return true;
        }
        return OpenTracingJaxwsCdiUtils.getConfigOverrideValue(Traced.class, "value", monitorContext, Boolean.TYPE).orElse(tracedAnnotation.value());
    }

    private boolean shouldTrace(String path) {
        Optional skipPatternOptional;
        String uriPath = "/" + path;
        if (uriPath.equals("/health") || uriPath.equals("/metrics") || uriPath.contains("/metrics/base") || uriPath.contains("/metrics/vendor") || uriPath.contains("/metrics/application")) {
            return false;
        }
        Config config = this.getConfig();
        if (config != null && (skipPatternOptional = config.getOptionalValue("mp.opentracing.server.skip-pattern", String.class)).isPresent()) {
            for (String skipPattern : ((String)skipPatternOptional.get()).split("\\|")) {
                if (!uriPath.matches(skipPattern)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isTraceInProgress() {
        return this.requestTracing != null && this.requestTracing.isRequestTracingEnabled() && this.requestTracing.isTraceInProgress();
    }

    private Response.StatusType getResponseStatus(Packet pipeRequest, Packet pipeResponse) {
        Integer statusCode = (Integer)pipeResponse.get((Object)"javax.xml.ws.http.response.code");
        if (statusCode == null || statusCode.equals(0)) {
            HttpServletResponse httpResponse = (HttpServletResponse)pipeRequest.get((Object)"javax.xml.ws.servlet.response");
            statusCode = httpResponse.getStatus();
        }
        return Response.Status.fromStatusCode((int)statusCode);
    }

    private Throwable getResponseException(MonitorContext monitorContext, Packet pipeResponse) {
        return monitorContext.getSeiModel().getDatabinding().deserializeResponse((MessageContext)pipeResponse.copy(true), monitorContext.getCallInfo()).getException();
    }

    private Traced getTraceAnnotation(MonitorContext monitorContext) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            return OpenTracingJaxwsCdiUtils.getAnnotation(beanManager, Traced.class, monitorContext);
        }
        return null;
    }

    private BeanManager getBeanManager() {
        try {
            return CDI.current().getBeanManager();
        }
        catch (IllegalStateException ise) {
            logger.log(Level.FINE, "Error getting Bean Manager, presumably due to this application not using CDI", ise);
            return null;
        }
    }

    private Config getConfig() {
        try {
            return ConfigProvider.getConfig();
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.INFO, "No config could be found", ex);
            return null;
        }
    }

    private Tracer getTracer() {
        return this.openTracing.getTracer(this.openTracing.getApplicationName((InvocationManager)this.serviceLocator.getService(InvocationManager.class, new Annotation[0])));
    }

    private MultivaluedMap<String, String> getHeaders(HttpServletRequest httpRequest) {
        MultivaluedHashMap headerMap = new MultivaluedHashMap();
        for (String headerName : Collections.list(httpRequest.getHeaderNames())) {
            headerMap.addAll((Object)headerName, Collections.list(httpRequest.getHeaders(headerName)));
        }
        return headerMap;
    }

    private class MultivaluedMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, List<V>>> mapIterator;
        private Map.Entry<K, List<V>> mapEntry;
        private Iterator<V> mapEntryIterator;

        public MultivaluedMapIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
            this.mapIterator = multiValuesEntrySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mapEntryIterator != null && this.mapEntryIterator.hasNext() || this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.mapEntry == null || !this.mapEntryIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.mapEntryIterator = this.mapEntry.getValue().iterator();
            }
            if (this.mapEntryIterator.hasNext()) {
                return new AbstractMap.SimpleImmutableEntry<K, V>(this.mapEntry.getKey(), this.mapEntryIterator.next());
            }
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, String> map;

        public MultivaluedMapToTextMap(MultivaluedMap<String, String> map) {
            this.map = map;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultivaluedMapIterator<String, String>(this.map.entrySet());
        }

        public void put(String key, String value) {
            this.map.add((Object)key, (Object)value);
        }
    }
}

