/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.exec.io.AbstractInbox;
import com.hazelcast.sql.impl.exec.io.InboundBatch;
import com.hazelcast.sql.impl.exec.io.flowcontrol.FlowControl;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;

public class StripedInbox
extends AbstractInbox {
    private final HashMap<UUID, Integer> memberToIdxMap = new HashMap();
    private final ArrayDeque<InboundBatch>[] queues;

    public StripedInbox(QueryOperationHandler operationHandler, QueryId queryId, int edgeId, boolean ordered, int rowWidth, UUID localMemberId, Collection<UUID> senderMemberIds, FlowControl flowControl) {
        super(operationHandler, queryId, edgeId, ordered, rowWidth, localMemberId, senderMemberIds.size(), flowControl);
        int memberIdx = 0;
        for (UUID senderMemberId : senderMemberIds) {
            this.memberToIdxMap.put(senderMemberId, memberIdx);
            ++memberIdx;
        }
        this.queues = new ArrayDeque[memberIdx];
        for (int i = 0; i < memberIdx; ++i) {
            this.queues[i] = new ArrayDeque();
        }
    }

    @Override
    public void onBatch0(InboundBatch batch) {
        int idx = this.memberToIdxMap.get(batch.getSenderId());
        ArrayDeque<InboundBatch> queue = this.queues[idx];
        queue.add(batch);
    }

    public int getStripeCount() {
        return this.queues.length;
    }

    public InboundBatch poll(int stripe) {
        InboundBatch batch = this.queues[stripe].poll();
        this.onBatchPolled(batch);
        return batch;
    }

    public String toString() {
        return "StripedInbox {queryId=" + this.queryId + ", edgeId=" + this.edgeId + "}";
    }
}

