/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.client.impl.protocol.util.ClientMessageEncoder;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.ascii.TextEncoder;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.nio.ByteBuffer;

public class UnifiedProtocolEncoder
extends OutboundHandler<Void, ByteBuffer> {
    private final ServerContext serverContext;
    private final HazelcastProperties props;
    private volatile String inboundProtocol;
    private boolean clusterProtocolBuffered;

    public UnifiedProtocolEncoder(ServerContext serverContext) {
        this.serverContext = serverContext;
        this.props = serverContext.properties();
    }

    @Override
    public void handlerAdded() {
        this.initDstBuffer(3);
        if (this.channel.isClientMode()) {
            this.inboundProtocol = "HZC";
        }
    }

    void signalProtocolEstablished(String inboundProtocol) {
        assert (!this.channel.isClientMode()) : "Signal protocol should only be made on channel in serverMode";
        this.inboundProtocol = inboundProtocol;
        this.channel.outboundPipeline().wakeup();
    }

    @Override
    public HandlerStatus onWrite() {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            if (this.inboundProtocol == null) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            if ("HZC".equals(this.inboundProtocol)) {
                if (!this.clusterProtocolBuffered) {
                    this.clusterProtocolBuffered = true;
                    ((ByteBuffer)this.dst).put(StringUtil.stringToBytes("HZC"));
                    HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                    return handlerStatus;
                }
                if (!this.isProtocolBufferDrained()) {
                    HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                    return handlerStatus;
                }
                this.initChannelForCluster();
            } else if ("CP2".equals(this.inboundProtocol)) {
                this.initChannelForClient();
            } else {
                this.initChannelForText();
            }
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            ((ByteBuffer)this.dst).flip();
        }
    }

    private boolean isProtocolBufferDrained() {
        return ((ByteBuffer)this.dst).position() == 0;
    }

    private void initChannelForCluster() {
        this.channel.options().setOption(ChannelOption.SO_SNDBUF, this.props.getInteger(ClusterProperty.SOCKET_SEND_BUFFER_SIZE) * 1024);
        TcpServerConnection connection = (TcpServerConnection)this.channel.attributeMap().get(ServerConnection.class);
        OutboundHandler[] handlers = this.serverContext.createOutboundHandlers(EndpointQualifier.MEMBER, connection);
        this.channel.outboundPipeline().replace(this, handlers);
    }

    private void initChannelForClient() {
        this.channel.options().setOption(ChannelOption.SO_SNDBUF, this.clientSndBuf());
        this.channel.outboundPipeline().replace(this, new ClientMessageEncoder());
    }

    private void initChannelForText() {
        this.channel.options().setOption(ChannelOption.SO_SNDBUF, this.clientSndBuf());
        TextEncoder encoder = (TextEncoder)this.channel.attributeMap().remove("textencoder");
        this.channel.outboundPipeline().replace(this, encoder);
    }

    private int clientSndBuf() {
        int sndBuf = this.props.getInteger(ClusterProperty.SOCKET_CLIENT_SEND_BUFFER_SIZE);
        if (sndBuf == -1) {
            sndBuf = this.props.getInteger(ClusterProperty.SOCKET_SEND_BUFFER_SIZE);
        }
        return sndBuf * 1024;
    }
}

