/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupFilenameManager;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupRestoreManager;
import com.sun.enterprise.backup.LoggerHelper;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.StringHelper;
import com.sun.enterprise.backup.ZipStorage;
import com.sun.enterprise.backup.util.BackupUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;
import java.util.List;

public class BackupManager
extends BackupRestoreManager {
    Status status;

    public BackupManager(BackupRequest req) throws BackupException {
        super(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String backup() throws BackupException {
        StringBuilder mesg = new StringBuilder();
        String statusString = this.writeStatus();
        if (!this.request.terse) {
            String backupTime = new Date(this.request.timestamp).toString();
            mesg.append(StringHelper.get("backup-res.SuccessfulBackup", this.request.domainName, backupTime));
        }
        boolean deleteBackup = false;
        try {
            try {
                ZipStorage zs = new ZipStorage(this.request);
                zs.store();
            }
            catch (BackupException backupException) {
                deleteBackup = true;
                LoggerHelper.severe("Could not create domain backup zip: " + this.request.backupFile.toString() + "\n{0}", backupException.getCause().toString());
                throw backupException;
            }
            BackupFilenameManager bfm = new BackupFilenameManager(this.getBackupDirectory(this.request), this.request.domainName);
            List<File> recycleFiles = bfm.getRecycleFiles(this.request.recycleLimit);
            if (recycleFiles.size() > 0 && this.request.verbose) {
                mesg.append("\n");
                mesg.append(StringHelper.get("backup-res.recycle", this.request.recycleLimit));
                mesg.append("\n");
            }
            for (File f : recycleFiles) {
                if (this.request.verbose) {
                    mesg.append(StringHelper.get("backup-res.recycleDelete", f));
                    mesg.append("\n");
                }
                if (f.delete()) continue;
                mesg.append(StringHelper.get("backup-res.recycleBadDelete", f));
                mesg.append("\n");
            }
            if (this.request.verbose) {
                mesg.append("\n\n");
                mesg.append(statusString);
            }
            String string = mesg.toString();
            return string;
        }
        finally {
            this.status.delete();
            if (deleteBackup) {
                try {
                    Files.deleteIfExists(this.request.backupFile.toPath());
                }
                catch (IOException ioException) {
                    LoggerHelper.severe("Could not delete corrupt domain backup zip: " + this.request.backupFile.toString() + "\n{0}", ioException.toString());
                }
            } else {
                BackupUtils.protect(this.request.backupFile);
            }
        }
    }

    @Override
    void init() throws BackupException {
        super.init();
        if (this.request.backupFile != null) {
            throw new BackupException("backup-res.InternalError", "No backupFilename may be specified for a backup -- it is reserved for restore operations only.");
        }
        if (!FileUtils.safeIsDirectory((File)this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        File backupDir = this.getBackupDirectory(this.request);
        if (!backupDir.mkdirs() && !FileUtils.safeIsDirectory((File)backupDir)) {
            throw new BackupException("backup-res.NoBackupDirCantCreate", backupDir);
        }
        BackupFilenameManager bfmgr = new BackupFilenameManager(backupDir, this.request.domainName);
        this.request.backupFile = bfmgr.next();
        if (this.request.description == null || this.request.description.length() <= 0) {
            this.request.description = bfmgr.getCustomizedDescription();
        }
    }

    private String writeStatus() {
        this.status = new Status();
        return this.status.write(this.request);
    }
}

