/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SseEventSubscription<T>
implements Subscription {
    private static final Logger LOG = Logger.getLogger(SseEventSubscription.class.getName());
    private static final Runnable EMPTY_ACTION = () -> {};
    private final AtomicLong requested = new AtomicLong();
    private final Subscriber<T> subscriber;
    private final Queue<T> events;
    private final int bufferSize;
    private volatile Throwable closedException;
    private volatile boolean closed;
    private final AtomicInteger wipCounter = new AtomicInteger();
    private final AtomicReference<Runnable> onTerminationAction;

    SseEventSubscription(Subscriber<T> subscriber, int bufferSize) {
        this.subscriber = subscriber;
        this.bufferSize = bufferSize;
        this.events = new ArrayBlockingQueue<T>(bufferSize);
        this.onTerminationAction = new AtomicReference();
    }

    void emit(T element) {
        if (this.closed || this.isCancelled()) {
            return;
        }
        if (element == null) {
            throw new NullPointerException("Reactive Streams Rule 2.13 violated: The received element is `null`");
        }
        if (this.events.size() == this.bufferSize) {
            LOG.log(Level.INFO, "Dropping SSE element '%s' due to lack of subscriber requests", this.events.poll());
        }
        this.events.offer(element);
        this.drain();
    }

    public void request(long n) {
        if (n > 0L) {
            this.addSubscriptionRequest(this.requested, n);
            this.drain();
        } else {
            this.cancel();
            this.subscriber.onError((Throwable)new IllegalArgumentException("Request must be positive number " + n));
        }
    }

    public final void cancel() {
        this.cleanup();
    }

    private boolean isCancelled() {
        return this.onTerminationAction.get() == EMPTY_ACTION;
    }

    void onCompletion() {
        this.closed = true;
        this.drain();
    }

    void onError(Throwable t) {
        if (this.closed || this.isCancelled()) {
            return;
        }
        if (t == null) {
            throw new NullPointerException("Reactive Streams Rule 2.13 violated: The received error is `null`");
        }
        this.closedException = t;
        this.closed = true;
        this.drain();
    }

    private void cleanup() {
        Runnable action = this.onTerminationAction.getAndSet(EMPTY_ACTION);
        if (action != null && action != EMPTY_ACTION) {
            action.run();
        }
    }

    private void sendCompletionToSubscriber() {
        if (this.isCancelled()) {
            return;
        }
        try {
            this.subscriber.onComplete();
        }
        finally {
            this.cleanup();
        }
    }

    private void sendErrorToSubscriber(Throwable t) {
        if (t == null) {
            throw new NullPointerException("Reactive Streams Rule 2.13 violated, The received error is `null`");
        }
        if (this.isCancelled()) {
            return;
        }
        try {
            this.subscriber.onError(t);
        }
        finally {
            this.cleanup();
        }
    }

    private long addSubscriptionRequest(AtomicLong requested, long amount) {
        long updated;
        long current;
        do {
            if ((current = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            updated = current + amount;
            if (updated >= 0L) continue;
            updated = Long.MAX_VALUE;
        } while (!requested.compareAndSet(current, updated));
        return current;
    }

    private long producedSubscriptionRequest(AtomicLong requested, long emitted) {
        long updated;
        long current;
        do {
            if ((current = requested.get()) == 0L || current == Long.MAX_VALUE) {
                return current;
            }
            updated = current - emitted;
            if (updated >= 0L) continue;
            updated = 0L;
        } while (!requested.compareAndSet(current, updated));
        return updated;
    }

    private void drain() {
        if (this.wipCounter.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            long emitted;
            long requests = this.requested.get();
            for (emitted = 0L; emitted != requests; ++emitted) {
                boolean empty;
                if (this.isCancelled()) {
                    this.events.clear();
                    return;
                }
                T element = this.events.poll();
                boolean bl = empty = element == null;
                if (this.closed && empty) {
                    if (this.closedException != null) {
                        this.sendErrorToSubscriber(this.closedException);
                    } else {
                        this.sendCompletionToSubscriber();
                    }
                    return;
                }
                if (empty) break;
                try {
                    this.subscriber.onNext(element);
                    continue;
                }
                catch (Throwable t) {
                    this.cancel();
                }
            }
            if (emitted == requests) {
                if (this.isCancelled()) {
                    this.events.clear();
                    return;
                }
                if (this.closed && this.events.isEmpty()) {
                    if (this.closedException != null) {
                        this.sendErrorToSubscriber(this.closedException);
                    } else {
                        this.sendCompletionToSubscriber();
                    }
                    return;
                }
            }
            if (emitted <= 0L) continue;
            this.producedSubscriptionRequest(this.requested, emitted);
        } while ((missed = this.wipCounter.addAndGet(-missed)) != 0);
    }
}

