/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.internal.guava.Preconditions;
import org.glassfish.jersey.microprofile.restclient.RestClientUriBuilder;

public class RestClientWebTarget
extends JerseyWebTarget {
    RestClientWebTarget(String uri, JerseyClient parent) {
        super(RestClientUriBuilder.fromUri((String)uri), parent.getConfiguration());
    }

    RestClientWebTarget(URI uri, JerseyClient parent) {
        super(RestClientUriBuilder.fromUri(uri), parent.getConfiguration());
    }

    RestClientWebTarget(UriBuilder uriBuilder, JerseyClient parent) {
        super(uriBuilder.clone(), parent.getConfiguration());
    }

    RestClientWebTarget(Link link, JerseyClient parent) {
        super(RestClientUriBuilder.fromUri(link.getUri()), parent.getConfiguration());
    }

    protected RestClientWebTarget(UriBuilder uriBuilder, JerseyWebTarget that) {
        super(uriBuilder, that.getConfiguration());
    }

    public JerseyWebTarget path(String path) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)path, (Object)"path is 'null'.");
        return new RestClientWebTarget(this.getUriBuilder().path(path), this);
    }

    public JerseyWebTarget matrixParam(String name, Object ... values) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)name, (Object)"Matrix parameter name must not be 'null'.");
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return new RestClientWebTarget(this.getUriBuilder().replaceMatrixParam(name, (Object[])null), this);
        }
        RestClientWebTarget.checkForNullValues((String)name, (Object[])values);
        return new RestClientWebTarget(this.getUriBuilder().matrixParam(name, values), this);
    }

    public JerseyWebTarget queryParam(String name, Object ... values) throws NullPointerException {
        this.checkNotClosed();
        UriBuilder uriBuilder = this.getUriBuilder();
        if (uriBuilder instanceof RestClientUriBuilder && ((RestClientUriBuilder)uriBuilder).getQueryParamStyle() == null) {
            QueryParamStyle paramStyle = (QueryParamStyle)this.getConfiguration().getProperty(QueryParamStyle.class.getSimpleName());
            ((RestClientUriBuilder)uriBuilder).setQueryParamStyle(paramStyle);
        }
        return new RestClientWebTarget(RestClientWebTarget.setQueryParam((UriBuilder)uriBuilder, (String)name, (Object[])values), this);
    }

    public JerseyWebTarget resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)name, (Object)"name is 'null'.");
        Preconditions.checkNotNull((Object)value, (Object)"value is 'null'.");
        return new RestClientWebTarget(this.getUriBuilder().resolveTemplate(name, value, encodeSlashInPath), this);
    }

    public JerseyWebTarget resolveTemplateFromEncoded(String name, Object value) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)name, (Object)"name is 'null'.");
        Preconditions.checkNotNull((Object)value, (Object)"value is 'null'.");
        return new RestClientWebTarget(this.getUriBuilder().resolveTemplateFromEncoded(name, value), this);
    }

    public JerseyWebTarget resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws NullPointerException {
        this.checkNotClosed();
        this.checkTemplateValues(templateValues);
        if (templateValues.isEmpty()) {
            return this;
        }
        return new RestClientWebTarget(this.getUriBuilder().resolveTemplates(templateValues, encodeSlashInPath), this);
    }

    public JerseyWebTarget resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws NullPointerException {
        this.checkNotClosed();
        this.checkTemplateValues(templateValues);
        if (templateValues.isEmpty()) {
            return this;
        }
        return new RestClientWebTarget(this.getUriBuilder().resolveTemplatesFromEncoded(templateValues), this);
    }
}

