/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.logging;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Loggable {
    private static final String FORMAT_PREFIX = "[{0}:{1}]";
    private String id;
    private Object[] args;
    private Throwable thrown;
    private Logger logger;
    private Level level;

    private static Throwable getThrowable(Object[] args) {
        Object throwableCandidate;
        if (args == null) {
            return null;
        }
        int candidateIndex = args.length - 1;
        if (candidateIndex >= 0 && (throwableCandidate = args[candidateIndex]) instanceof Throwable) {
            return (Throwable)throwableCandidate;
        }
        return null;
    }

    public Loggable(Level level, String id, Object[] args, Logger logger) {
        this.level = level;
        this.id = id;
        this.args = args;
        this.thrown = Loggable.getThrowable(this.args);
        this.logger = logger;
    }

    public String log() {
        LogRecord rec = new LogRecord(this.level, this.getMessage(false, false));
        if (this.thrown != null) {
            rec.setThrown(this.thrown);
        }
        this.logger.log(rec);
        return this.id;
    }

    public String getMessageBody() {
        return this.getMessage(true, false);
    }

    private String getMessage(boolean prefix, boolean addTrace) {
        StringBuilder sb = new StringBuilder();
        if (prefix) {
            Object[] preArgs = new Object[]{this.getSubSystem(), this.id};
            sb.append(MessageFormat.format(FORMAT_PREFIX, preArgs));
        }
        sb.append(MessageFormat.format(this.getBody(), this.args));
        if (addTrace && this.thrown != null) {
            sb.append("\n");
            sb.append(this.throwable2StackTrace(this.thrown));
        }
        return sb.toString();
    }

    private Object throwable2StackTrace(Throwable th) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        th.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }

    private String getBody() {
        return this.logger.getResourceBundle().getString(this.id);
    }

    private String getSubSystem() {
        return this.logger.getName();
    }

    public String getMessage() {
        return this.getMessage(true, true);
    }

    public String getMessageText() {
        return this.getMessage(false, true);
    }

    public String getId() {
        return this.id;
    }
}

