/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment.analysis;

import java.time.Clock;
import java.time.Instant;

public class TraceContext {
    private final TraceContext parent;
    private final Level level;
    private final String name;
    private final Clock clock;
    private final Instant start;
    private Instant finish;

    TraceContext(TraceContext parent, Level level, String name, Clock clock) {
        this.start = clock.instant();
        this.parent = parent;
        this.level = level;
        this.name = name;
        this.clock = clock;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getFinish() {
        return this.finish;
    }

    public Level getLevel() {
        return this.level;
    }

    public TraceContext getParent() {
        return this.parent;
    }

    public boolean is(Level level) {
        return level == null || level == this.level;
    }

    public boolean isWithin(Level level) {
        return level == this.level || this.parent != null && this.parent.isWithin(level);
    }

    public String getName() {
        return this.name;
    }

    public String getLevelName(Level level) {
        if (level == this.level) {
            return this.name;
        }
        if (this.parent != null) {
            return this.parent.getLevelName(level);
        }
        return "";
    }

    void close() {
        if (this.finish == null) {
            this.finish = this.clock.instant();
        }
    }

    TraceContext pop() {
        this.close();
        return this.parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    void toString(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.toString(sb);
            sb.append(" > ");
        }
        sb.append((Object)this.level).append(" ").append(this.name);
    }

    public static enum Level {
        APPLICATION,
        MODULE,
        CONTAINER,
        ENGINE;

    }
}

