/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment.analysis;

import org.glassfish.internal.deployment.analysis.DeploymentSpan;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;

public class SpanSequence
implements AutoCloseable {
    private final StructuredDeploymentTracing tracing;
    private DeploymentSpan currentSpan;

    SpanSequence(StructuredDeploymentTracing tracing, DeploymentSpan initialSpan) {
        this.tracing = tracing;
        this.currentSpan = initialSpan;
    }

    public SpanSequence start(Enum<?> action) {
        return this.start(action, null);
    }

    public SpanSequence finish() {
        this.currentSpan.close();
        return this;
    }

    public SpanSequence start(Enum<?> action, String componentName) {
        this.currentSpan.close();
        this.currentSpan = this.tracing.startSpan(action, componentName);
        return this;
    }

    public SpanSequence start(String componentName) {
        return this.start(this.currentSpan.getAction(), componentName);
    }

    public DeploymentSpan nest(Enum<?> action) {
        return this.nest(action, null);
    }

    public DeploymentSpan nest(Enum<?> action, String componentName) {
        return this.tracing.startSpan(action, componentName);
    }

    @Override
    public void close() {
        this.currentSpan.close();
    }
}

