/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModulesRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;

public abstract class GenericSniffer
implements Sniffer {
    @Inject
    protected ModulesRegistry modulesRegistry;
    @Inject
    protected ServiceLocator habitat;
    private final String containerName;
    private final String appStigma;
    private final String urlPattern;
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private HK2Module[] modules;

    public GenericSniffer(String containerName, String appStigma, String urlPattern) {
        this.containerName = containerName;
        this.appStigma = appStigma;
        this.urlPattern = urlPattern;
    }

    public boolean handles(DeploymentContext context) {
        ArchiveType archiveType = (ArchiveType)this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        if (archiveType != null) {
            context.getSource().setExtraData(ArchiveType.class, (Object)archiveType);
        }
        return this.handles(context.getSource());
    }

    public String[] getAnnotationNames(DeploymentContext context) {
        ArrayList<String> annotationNames = new ArrayList<String>();
        for (Class<? extends Annotation> annotationType : this.getAnnotationTypes()) {
            annotationNames.add(annotationType.getName());
        }
        return annotationNames.toArray(new String[annotationNames.size()]);
    }

    public boolean handles(ReadableArchive location) {
        if (this.appStigma != null) {
            try {
                if (location.exists(this.appStigma)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public String[] getURLPatterns() {
        if (this.urlPattern != null) {
            return new String[]{this.urlPattern};
        }
        return null;
    }

    public String getModuleType() {
        return this.containerName;
    }

    public synchronized HK2Module[] setup(String containerHome, Logger logger) throws IOException {
        if (this.modules != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "GenericSniffer", "setup", "{0} has already setup {1} container, so just returning.", new Object[]{this, this.containerName});
            }
            return this.modules;
        }
        ArrayList<HK2Module> tmp = new ArrayList<HK2Module>();
        for (String moduleName : this.getContainerModuleNames()) {
            HK2Module m = this.modulesRegistry.makeModuleFor(moduleName, null);
            if (m == null) {
                throw new RuntimeException("Unable to set up module " + moduleName);
            }
            tmp.add(m);
        }
        this.modules = tmp.toArray(new HK2Module[tmp.size()]);
        return this.modules;
    }

    protected String[] getContainerModuleNames() {
        return new String[0];
    }

    public void tearDown() {
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[0];
    }

    public boolean isUserVisible() {
        return false;
    }

    public boolean isJavaEE() {
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof Sniffer) {
            Sniffer otherSniffer = (Sniffer)other;
            return this.getModuleType().equals(otherSniffer.getModuleType());
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.getModuleType() != null ? this.getModuleType().hashCode() : 0);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDeploymentConfigurations(ReadableArchive location) throws IOException {
        HashMap<String, String> deploymentConfigs = new HashMap<String, String>();
        if (location != null) {
            for (String path : this.getDeploymentConfigurationPaths()) {
                try (InputStream is = null;){
                    is = location.getEntry(path);
                    if (is == null) continue;
                    String dc = this.readDeploymentConfig(is);
                    deploymentConfigs.put(path, dc);
                }
            }
        }
        return deploymentConfigs;
    }

    protected List<String> getDeploymentConfigurationPaths() {
        return Collections.emptyList();
    }

    public String[] getIncompatibleSnifferTypes() {
        return null;
    }

    private String readDeploymentConfig(InputStream is) throws IOException {
        int bytesRead;
        String encoding = null;
        XMLEventReader rdr = null;
        try {
            is.mark(Integer.MAX_VALUE);
            rdr = xmlInputFactory.createXMLEventReader(new InputStreamReader(is));
            while (rdr.hasNext()) {
                XMLEvent ev = rdr.nextEvent();
                if (!ev.isStartDocument()) continue;
                StartDocument sd = (StartDocument)ev;
                encoding = sd.getCharacterEncodingScheme();
                break;
            }
        }
        catch (XMLStreamException e) {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (XMLStreamException inner) {
                    throw new IOException(e);
                }
            }
            throw new IOException(e);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        is.reset();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        try {
            rdr.close();
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        is.close();
        return new String(baos.toByteArray(), encoding);
    }
}

