/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ApplicationRegistry {
    private final Map<String, ApplicationInfo> apps = new LinkedHashMap<String, ApplicationInfo>();
    private final Map<String, Deployment.ApplicationDeployment> transientDeployments = new HashMap<String, Deployment.ApplicationDeployment>();

    public synchronized void add(String name, ApplicationInfo info) {
        this.apps.put(name, info);
    }

    public ApplicationInfo get(String name) {
        return this.apps.get(name);
    }

    public synchronized void remove(String name) {
        this.apps.remove(name);
    }

    public Set<String> getAllApplicationNames() {
        return this.apps.keySet();
    }

    public void addTransient(Deployment.ApplicationDeployment depl) {
        if (depl != null && depl.appInfo != null) {
            this.transientDeployments.put(depl.appInfo.getName(), depl);
        }
    }

    public void removeTransient(String appName) {
        this.transientDeployments.remove(appName);
    }

    public Deployment.ApplicationDeployment getTransient(String appName) {
        return this.transientDeployments.get(appName);
    }
}

