/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.ldap.admin;

import com.sun.enterprise.util.StringUtils;
import fish.payara.microprofile.config.extensions.ldap.LDAPConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.BaseSetConfigSourceConfigurationCommand;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="set-ldap-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-ldap-config-source-configuration", description="Configures LDAP Config Source")})
public class SetLDAPConfigSourceConfiguration
extends BaseSetConfigSourceConfigurationCommand<LDAPConfigSourceConfiguration> {
    @Param(name="url")
    private String url;
    @Param(name="authType", acceptableValues="simple,none", defaultValue="none")
    private String authType;
    @Param(name="startTLSEnabled", optional=true, defaultValue="false")
    private Boolean startTLSEnabled;
    @Param(name="bindDN", optional=true)
    private String bindDN;
    @Param(name="bindDNPassword", optional=true)
    private String bindDNPassword;
    @Param(name="searchBase", optional=true)
    private String searchBase;
    @Param(name="searchFilter", optional=true)
    private String searchFilter;
    @Param(name="searchScope", acceptableValues="subtree,onelevel,object", optional=true)
    private String searchScope;
    @Param(name="connectionTimeout", optional=true)
    private String connectionTimeout;
    @Param(name="readTimeout", optional=true)
    private String readTimeout;

    protected void applyValues(ActionReport report, LDAPConfigSourceConfiguration configuration) throws PropertyVetoException {
        if (!(!this.authType.equals("simple") || StringUtils.ok((String)this.bindDN) && StringUtils.ok((String)this.bindDNPassword))) {
            report.setMessage("bindDN and bindDNPassword param can not be empty for 'simple' auth type");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!(!this.authType.equals("none") || StringUtils.ok((String)this.searchBase) && StringUtils.ok((String)this.searchFilter))) {
            report.setMessage("searchBase and searchFilter param can not be empty for 'none' auth type");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        super.applyValues(report, (ConfigSourceConfiguration)configuration);
        if (this.url != null) {
            configuration.setUrl(this.url);
        }
        if (this.authType != null) {
            configuration.setAuthType(this.authType);
        }
        if (this.startTLSEnabled != null) {
            configuration.setStartTLSEnabled(Boolean.toString(this.startTLSEnabled));
        }
        if (this.bindDN != null) {
            configuration.setBindDN(this.bindDN);
        }
        if (this.bindDNPassword != null) {
            configuration.setBindDNPassword(this.bindDNPassword);
        }
        if (this.searchBase != null) {
            configuration.setSearchBase(this.searchBase);
        }
        if (this.searchFilter != null) {
            configuration.setSearchFilter(this.searchFilter);
        }
        if (this.searchScope != null) {
            configuration.setSearchScope(this.searchScope);
        }
        if (this.connectionTimeout != null) {
            configuration.setConnectionTimeout(this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            configuration.setReadTimeout(this.readTimeout);
        }
    }
}

