/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.ldap;

import fish.payara.microprofile.config.extensions.ldap.LDAPConfigSourceConfiguration;
import fish.payara.microprofile.config.extensions.ldap.LDAPConfigSourceHelper;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.ConfigProviderResolverImpl;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service(name="ldap-config-source")
public class LDAPConfigSource
extends ConfiguredExtensionConfigSource<LDAPConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(LDAPConfigSource.class.getName());
    private LDAPConfigSourceHelper ldapConfigSourceHelper;

    public void bootstrap() {
        this.ldapConfigSourceHelper = new LDAPConfigSourceHelper((LDAPConfigSourceConfiguration)this.configuration);
    }

    public void destroy() {
        this.ldapConfigSourceHelper = null;
    }

    public Map<String, String> getProperties() {
        if (this.ldapConfigSourceHelper == null) {
            LDAPConfigSource.printMisconfigurationMessage();
            return new HashMap<String, String>();
        }
        return this.ldapConfigSourceHelper.getAllConfigValues();
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public String getValue(String propertyName) {
        if (this.ldapConfigSourceHelper == null) {
            LDAPConfigSource.printMisconfigurationMessage();
            return null;
        }
        return this.ldapConfigSourceHelper.getConfigValue(propertyName);
    }

    public boolean deleteValue(String value) {
        return false;
    }

    public boolean setValue(String key, String value) {
        return false;
    }

    public String getSource() {
        return "ldap";
    }

    public String getName() {
        return "ldap";
    }

    public int getOrdinal() {
        return Integer.parseInt(((ConfigProviderResolverImpl)Globals.getDefaultHabitat().getService(ConfigProviderResolverImpl.class, new Annotation[0])).getMPConfig().getLdapOrdinality());
    }

    private static void printMisconfigurationMessage() {
        LOGGER.warning("LDAP Config Source isn't configured correctly.");
    }
}

