/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.permissionsxml;

import com.sun.enterprise.security.integration.PermissionCreator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PermissionsXMLParser {
    protected static final String PERMISSIONS_XML = "META-INF/permissions.xml";
    protected static final String RESTRICTED_PERMISSIONS_XML = "META-INF/restricted-permissions.xml";
    protected XMLStreamReader parser;
    private PermissionCollection permissions = new Permissions();
    private PermissionCollection permissionCollectionToBeRestricted;
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public PermissionsXMLParser(File permissionsXmlFile, PermissionCollection permissionCollectionToBeRestricted) throws XMLStreamException, FileNotFoundException {
        try (FileInputStream inputStream = new FileInputStream(permissionsXmlFile);){
            this.permissionCollectionToBeRestricted = permissionCollectionToBeRestricted;
            this.init(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PermissionsXMLParser(InputStream input, PermissionCollection permissionCollectionToBeRestricted) throws XMLStreamException, FileNotFoundException {
        this.permissionCollectionToBeRestricted = permissionCollectionToBeRestricted;
        this.init(input);
    }

    public PermissionCollection getPermissions() {
        return this.permissions;
    }

    private static XMLInputFactory getXMLInputFactory() {
        return xmlInputFactory;
    }

    private void read(InputStream input) throws XMLStreamException {
        this.parser = PermissionsXMLParser.getXMLInputFactory().createXMLStreamReader(input);
        int event = 0;
        String classname = null;
        String target = null;
        String actions = null;
        while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
            String name;
            if (event == 1) {
                name = this.parser.getLocalName();
                if ("permission".equals(name)) {
                    classname = null;
                    target = null;
                    actions = null;
                    continue;
                }
                if ("class-name".equals(name)) {
                    classname = this.parser.getElementText();
                    continue;
                }
                if ("name".equals(name)) {
                    target = this.parser.getElementText();
                    continue;
                }
                if ("actions".equals(name)) {
                    actions = this.parser.getElementText();
                    continue;
                }
                if ("permissions".equals(name)) continue;
                this.skipSubTree(name);
                continue;
            }
            if (event != 2 || !"permission".equals(name = this.parser.getLocalName()) || classname == null || classname.isEmpty()) continue;
            this.addPermission(classname, target, actions);
        }
    }

    private void init(InputStream input) throws XMLStreamException {
        try {
            this.read(input);
        }
        finally {
            if (this.parser != null) {
                try {
                    this.parser.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void skipSubTree(String name) throws XMLStreamException {
        int event;
        do {
            if ((event = this.parser.next()) != 8) continue;
            throw new XMLStreamException("Unexpected element with name " + name);
        } while (event != 2 || !name.equals(this.parser.getLocalName()));
    }

    private void addPermission(String classname, String target, String actions) {
        try {
            Permission permission = PermissionCreator.getInstance((String)classname, (String)target, (String)actions);
            if (permission != null) {
                if (this.permissionCollectionToBeRestricted != null && this.permissionCollectionToBeRestricted.implies(permission)) {
                    throw new SecurityException("Restricted Permission Declared - fail deployment!");
                }
                this.permissions.add(permission);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SecurityException(e);
        }
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        xmlInputFactory.setXMLResolver((p, s, b, n) -> new ByteArrayInputStream(new byte[0]));
    }
}

