/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.context;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.util.Utility;
import fish.payara.appserver.context.JavaEEContextUtilImpl;
import java.util.List;
import java.util.Map;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.jboss.weld.context.bound.BoundRequestContext;

class ContextImpl {
    ContextImpl() {
    }

    public static class RequestContext
    implements JavaEEContextUtil.Context {
        private final JavaEEContextUtil.Context rootCtx;
        final BoundRequestContext ctx;
        final Map<String, Object> storage;

        public void close() {
            if (this.ctx != null) {
                this.ctx.deactivate();
                this.ctx.dissociate(this.storage);
            }
            this.rootCtx.close();
        }

        public RequestContext(JavaEEContextUtil.Context rootCtx, BoundRequestContext ctx, Map<String, Object> storage) {
            this.rootCtx = rootCtx;
            this.ctx = ctx;
            this.storage = storage;
        }

        public boolean isValid() {
            return this.rootCtx.isValid();
        }
    }

    public static class EmptyContext
    implements JavaEEContextUtil.Context {
        private final InvocationManager invocationManager;
        private final List<? extends ComponentInvocation> previousInvocations;

        EmptyContext(InvocationManager invocationManager) {
            this.invocationManager = invocationManager;
            this.previousInvocations = invocationManager.popAllInvocations();
        }

        public void close() {
            this.invocationManager.putAllInvocations(this.previousInvocations);
        }
    }

    public static class ClassLoaderContext
    implements JavaEEContextUtil.Context {
        private final ClassLoader oldClassLoader;
        private final boolean resetOldClassLoader;

        public ClassLoaderContext(ClassLoader oldClassLoader, boolean resetOldClassLoader) {
            this.oldClassLoader = oldClassLoader;
            this.resetOldClassLoader = resetOldClassLoader;
        }

        public void close() {
            if (this.resetOldClassLoader) {
                Utility.setContextClassLoader((ClassLoader)this.oldClassLoader);
            }
        }
    }

    public static class Context
    implements JavaEEContextUtil.Context {
        private final ComponentInvocation invocation;
        private final InvocationManager invMgr;
        private final ComponentEnvManager compEnvMgr;
        private final ClassLoader oldClassLoader;

        public void close() {
            if (this.invocation != null) {
                this.invMgr.postInvoke(this.invocation);
                Utility.setContextClassLoader((ClassLoader)this.oldClassLoader);
            }
        }

        public boolean isValid() {
            return this.invocation != null && !JavaEEContextUtilImpl.isLeaked(this.compEnvMgr, this.invocation, this.invocation.getComponentId());
        }

        public Context(ComponentInvocation invocation, InvocationManager invMgr, ComponentEnvManager compEnvMgr, ClassLoader oldClassLoader) {
            this.invocation = invocation;
            this.invMgr = invMgr;
            this.compEnvMgr = compEnvMgr;
            this.oldClassLoader = oldClassLoader;
        }
    }
}

