/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.api;

import com.sun.enterprise.repository.ResourceProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resources.api.JavaEEResource;
import org.glassfish.resources.api.ResourcePropertyImpl;

public abstract class JavaEEResourceBase
implements JavaEEResource,
Serializable {
    ResourceInfo resourceInfo;
    Map properties_;
    boolean enabled_;
    String description_;

    public JavaEEResourceBase(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
        this.properties_ = new HashMap();
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled_ = value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled_;
    }

    @Override
    public void setDescription(String value) {
        this.description_ = value;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public abstract int getType();

    @Override
    public Set getProperties() {
        HashSet<ResourceProperty> shallowCopy = new HashSet<ResourceProperty>();
        Collection collection = this.properties_.values();
        for (ResourceProperty next : collection) {
            shallowCopy.add(next);
        }
        return shallowCopy;
    }

    @Override
    public void addProperty(ResourceProperty property) {
        this.properties_.put(property.getName(), property);
    }

    @Override
    public boolean removeProperty(ResourceProperty property) {
        Object removedObj = this.properties_.remove(property.getName());
        return removedObj != null;
    }

    @Override
    public ResourceProperty getProperty(String propertyName) {
        return (ResourceProperty)this.properties_.get(propertyName);
    }

    @Override
    public JavaEEResource makeClone(ResourceInfo resourceInfo) {
        JavaEEResource clone = this.doClone(resourceInfo);
        Set entrySet = this.properties_.entrySet();
        for (Map.Entry next : entrySet) {
            ResourcePropertyImpl propClone = new ResourcePropertyImpl((String)next.getKey());
            propClone.setValue(next.getValue());
            clone.addProperty(propClone);
        }
        clone.setEnabled(this.isEnabled());
        clone.setDescription(this.getDescription());
        return clone;
    }

    protected String getPropsString() {
        StringBuilder propsBuffer = new StringBuilder();
        Set props = this.getProperties();
        if (!props.isEmpty()) {
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                if (propsBuffer.length() == 0) {
                    propsBuffer.append("[ ");
                } else {
                    propsBuffer.append(" , ");
                }
                ResourceProperty next = (ResourceProperty)iter.next();
                propsBuffer.append(next.getName()).append("=").append(next.getValue());
            }
            propsBuffer.append(" ]");
        }
        return propsBuffer.toString();
    }

    protected abstract JavaEEResource doClone(ResourceInfo var1);
}

