/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.payara;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.apache.commons.cli.ParseException;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.jakarta.JakartaTransformer;

public class JakartaNamespaceTransformer
extends Transformer {
    private final PayaraTransformOptions options;
    private final File output;
    private final boolean invert;
    private final Logger logger;

    public JakartaNamespaceTransformer(Logger logger, File input, boolean invert) throws IOException {
        super(System.out, System.err);
        String prefix = invert ? "JAVAX-" : "JAKARTA-";
        this.output = input.isDirectory() ? Files.createTempDirectory(input.getParentFile().toPath(), prefix + input.getName(), new FileAttribute[0]).toFile() : File.createTempFile(prefix, input.getName(), input.getParentFile());
        this.options = new PayaraTransformOptions(input, this.output, invert);
        this.logger = logger;
        this.invert = invert;
    }

    @Override
    public int run() {
        boolean loadedRules;
        try {
            this.setArgs(new String[]{"--" + Transformer.AppOption.INVERT.getLongTag(), String.valueOf(this.invert), "--" + Transformer.AppOption.OVERWRITE.getLongTag(), "true"});
            this.setParsedArgs();
        }
        catch (ParseException e) {
            this.errorPrint("Exception parsing command line arguments: %s", e);
            return 1;
        }
        try {
            this.options.setLogging(this.logger);
        }
        catch (TransformException e) {
            this.errorPrint("Logger settings error: %s", e);
            return 5;
        }
        this.setOptionDefaults(JakartaTransformer.class, JakartaTransformer.getOptionDefaults());
        try {
            loadedRules = this.options.setRules();
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            this.dual_error("Exception loading rules:", e);
            return 2;
        }
        if (!loadedRules) {
            this.dual_error("Transformation rules cannot be used", new Object[0]);
            return 2;
        }
        if (!this.options.setInput()) {
            return 3;
        }
        if (!this.options.setOutput()) {
            return 3;
        }
        if (!this.options.acceptAction()) {
            this.dual_error("No action selected", new Object[0]);
            return 4;
        }
        try {
            this.options.transform();
        }
        catch (TransformException e) {
            this.dual_error("Transform failure:", e);
            return 3;
        }
        catch (Throwable th) {
            this.dual_error("Unexpected failure:", th);
            return 3;
        }
        return 0;
    }

    public File getOutput() {
        return this.output;
    }

    class PayaraTransformOptions
    extends Transformer.TransformOptions {
        public PayaraTransformOptions(File input, File output, boolean invert) {
            this.inputFile = input;
            this.outputFile = output;
        }

        @Override
        public boolean setInput() {
            if (this.inputFile == null) {
                JakartaNamespaceTransformer.this.dual_error("No input file was specified", new Object[0]);
                return false;
            }
            if (!this.inputFile.exists()) {
                JakartaNamespaceTransformer.this.dual_error("Input does not exist [ %s ] [ %s ]", new Object[]{this.inputName, this.inputPath});
                return false;
            }
            this.inputName = this.inputFile.getName();
            this.inputPath = this.inputFile.getAbsolutePath();
            JakartaNamespaceTransformer.this.dual_info("Input     [ %s ]", this.inputName);
            JakartaNamespaceTransformer.this.dual_info("          [ %s ]", this.inputPath);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean setOutput() {
            boolean putIntoDirectory;
            String useOutputName;
            boolean isExplicit;
            boolean bl = isExplicit = this.outputFile != null;
            if (isExplicit) {
                useOutputName = this.outputFile.getName();
            } else {
                int indexOfLastSlash = this.inputName.lastIndexOf(47);
                if (indexOfLastSlash == -1) {
                    useOutputName = "output_" + this.inputName;
                } else {
                    String inputPrefix = this.inputName.substring(0, indexOfLastSlash + 1);
                    String inputSuffix = this.inputName.substring(indexOfLastSlash + 1);
                    useOutputName = inputPrefix + "output_" + inputSuffix;
                }
            }
            String useOutputPath = this.outputFile.getAbsolutePath();
            boolean bl2 = putIntoDirectory = this.inputFile.isFile() && this.outputFile.isDirectory();
            if (putIntoDirectory) {
                useOutputName = useOutputName + '/' + this.inputName;
                if (this.isVerbose) {
                    JakartaNamespaceTransformer.this.dual_info("Output generated using input name and output directory [ %s ]", useOutputName);
                }
                this.outputFile = new File(useOutputName);
                useOutputPath = this.outputFile.getAbsolutePath();
            }
            String outputCase = isExplicit ? (putIntoDirectory ? "Explicit directory" : "Explicit") : (putIntoDirectory ? "Directory generated from input" : "Generated from input");
            JakartaNamespaceTransformer.this.dual_info("Output    [ %s ] (%s)", useOutputName, outputCase);
            JakartaNamespaceTransformer.this.dual_info("          [ %s ]", useOutputPath);
            this.allowOverwrite = JakartaNamespaceTransformer.this.hasOption(Transformer.AppOption.OVERWRITE);
            if (this.allowOverwrite) {
                JakartaNamespaceTransformer.this.dual_info("Overwrite of output is enabled", new Object[0]);
            }
            if (this.outputFile.exists()) {
                if (!this.allowOverwrite) {
                    JakartaNamespaceTransformer.this.dual_error("Output already exists [ %s ]", new Object[]{useOutputPath});
                    return false;
                }
                JakartaNamespaceTransformer.this.dual_info("Output exists and will be overwritten [ %s ]", useOutputPath);
            } else if (this.allowOverwrite && this.isVerbose) {
                JakartaNamespaceTransformer.this.dual_info("Overwritten specified, but output [ %s ] does not exist", useOutputPath);
            }
            this.outputName = useOutputName;
            this.outputPath = useOutputPath;
            return true;
        }
    }
}

