/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.cli.ListDomainsCommand;
import com.sun.enterprise.admin.servermgmt.cli.StopDomainCommand;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-all-domains")
@PerLookup
public class StopAllDomainsCommand
extends StopDomainCommand {
    @Param(name="force", optional=true, defaultValue="true")
    Boolean force;
    @Param(optional=true, defaultValue="false")
    Boolean kill;
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListDomainsCommand.class);

    protected void prevalidate() throws CommandException {
        if (this.operands != null && this.operands.size() > 0) {
            throw new CommandException(strings.get("StopAllDomains.tooManyOperands"));
        }
        super.prevalidate();
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int executeCommand() throws CommandException {
        MultiException allExceptions = new MultiException();
        try {
            String[] domainsList;
            for (String domain : domainsList = this.getDomains()) {
                this.setConfig(domain);
                RemoteCLICommand cmd = new RemoteCLICommand("stop-domain", this.programOpts, this.env);
                logger.log(Level.FINE, "Stopping domain {0}", domain);
                try {
                    cmd.executeAndReturnOutput(new String[]{"stop-domain", "--force", this.force.toString()});
                }
                catch (Exception e) {
                    allExceptions.addError((Throwable)e);
                }
                logger.fine("Stopped domain");
            }
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            allExceptions.addError((Throwable)ex);
            int n = 1;
            return n;
        }
        finally {
            if (!allExceptions.getErrors().isEmpty()) {
                throw new CommandException(allExceptions.getMessage());
            }
        }
    }

    private String[] getDomains() throws DomainException, IOException {
        PEDomainsManager manager = new PEDomainsManager();
        File domainsDirFile = StopAllDomainsCommand.ok((String)this.domainDirParam) ? new File(this.domainDirParam) : DomainDirs.getDefaultDomainsDir();
        DomainConfig domainConfig = new DomainConfig(null, domainsDirFile.getAbsolutePath());
        String[] domainsList = manager.listDomains(domainConfig);
        if (domainsList.length == 0) {
            logger.fine(strings.get("NoDomainsToList"));
        }
        return domainsList;
    }

    private int setConfig(String domain) throws CommandException {
        this.setDomainName(domain);
        super.initDomain();
        if (this.isLocal()) {
            if (this.getServerDirs().getLocalPassword() == null) {
                return this.dasNotRunning();
            }
            this.programOpts.setHostAndPort(this.getAdminAddress());
            logger.log(Level.FINER, "Stopping local domain on port {0}", this.programOpts.getPort());
            this.programOpts.setInteractive(false);
            if (!this.isThisDAS(this.getDomainRootDir())) {
                return this.dasNotRunning();
            }
            logger.finer("It's the correct DAS");
        } else {
            if (!DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
                return this.dasNotRunning();
            }
            logger.finer("DAS is running");
            this.programOpts.setInteractive(false);
        }
        return 0;
    }

    @Override
    protected int dasNotRunning() throws CommandException {
        if (this.kill.booleanValue() && this.isLocal()) {
            return this.kill();
        }
        return 0;
    }
}

