/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class RadixTreeNode {
    private static final Logger LOGGER = SLogger.getLogger();
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(RadixTreeNode.class);
    private String key;
    private String value;
    private Map<Character, RadixTreeNode> childNodes;
    private RadixTreeNode parentNode;

    RadixTreeNode(String key, String value) {
        this.key = key;
        this.value = value;
    }

    String getKey() {
        return this.key;
    }

    void setKey(String key) {
        this.key = key;
    }

    String getValue() {
        return this.value;
    }

    void setValue(String value) {
        this.value = value;
    }

    RadixTreeNode getParentNode() {
        return this.parentNode;
    }

    Collection<RadixTreeNode> getChildNodes() {
        if (this.childNodes != null) {
            return this.childNodes.values();
        }
        return Collections.emptyList();
    }

    void addChildNode(RadixTreeNode node) {
        RadixTreeNode oldNode;
        if (node == null || node.key == null || node.key.isEmpty()) {
            throw new IllegalArgumentException(STRINGS.get("errorInEmptyNullKeyInstertion"));
        }
        char c = node.key.charAt(0);
        if (this.childNodes == null) {
            this.childNodes = new HashMap<Character, RadixTreeNode>();
        }
        if ((oldNode = this.childNodes.put(Character.valueOf(c), node)) != null) {
            LOGGER.log(Level.WARNING, "NCLS-SRVRMGMT-00035", new Object[]{this.toString(), oldNode.toString(), node.toString()});
            oldNode.parentNode = null;
        }
        node.parentNode = this;
    }

    void removeChildNode(RadixTreeNode node) {
        if (node == null || node.key == null || node.key.isEmpty()) {
            throw new IllegalArgumentException(STRINGS.get("invalidNodeKey"));
        }
        char c = node.key.charAt(0);
        if (this.childNodes != null) {
            RadixTreeNode matchedNode = this.childNodes.get(Character.valueOf(c));
            if (matchedNode == node) {
                node = this.childNodes.remove(Character.valueOf(c));
                node.parentNode = null;
            } else {
                throw new IllegalArgumentException(STRINGS.get("invalidChildNode", new Object[]{node, this}));
            }
        }
    }

    RadixTreeNode getChildNode(char c) {
        return this.childNodes == null ? null : this.childNodes.get(Character.valueOf(c));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Node Key : ").append(this.key).append(", Value : ").append(this.value);
        return buffer.toString();
    }
}

