/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Logger;

public final class FileDeletionThread
extends Thread {
    private static final Logger LOG = Logger.getLogger(FileDeletionThread.class.getName());
    private static final int MAX_DELETION_ATTEMPTS = 3;
    private final Set<File> filesToDelete = new ConcurrentSkipListSet<File>();

    public void add(File file) {
        if (file != null) {
            this.filesToDelete.add(file);
        }
    }

    @Override
    public void run() {
        HashMap<File, Integer> deletionAttempts = new HashMap<File, Integer>();
        while (!this.filesToDelete.isEmpty()) {
            Iterator<File> fileIterator = this.filesToDelete.iterator();
            while (fileIterator.hasNext()) {
                File fileToDelete = fileIterator.next();
                boolean deletionSuccessful = this.delete(fileToDelete);
                if (!deletionSuccessful && deletionAttempts.compute(fileToDelete, (file, attempts) -> {
                    int n;
                    if (attempts == null) {
                        n = 1;
                    } else {
                        attempts = attempts + 1;
                        n = attempts;
                    }
                    return n;
                }) <= 3) continue;
                fileIterator.remove();
                deletionAttempts.remove(fileToDelete);
            }
        }
        deletionAttempts.clear();
    }

    private boolean delete(File file) {
        if (file.exists()) {
            try {
                return Files.walk(file.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).filter(f -> !f.delete()).count() == 0L;
            }
            catch (IOException e) {
                LOG.info("Cannot delete file " + file);
            }
        }
        return true;
    }
}

