/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.i18n;

import com.sun.enterprise.util.CULoggerInfo;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringManagerBase {
    private static final Logger LOGGER = CULoggerInfo.getLogger();
    private volatile ResourceBundle resourceBundle;
    private final String resourceBundleName;
    private final ClassLoader classLoader;
    private static final String NO_DEFAULT = "No local string defined";
    private static Map<String, StringManagerBase> managers = new HashMap<String, StringManagerBase>();

    protected StringManagerBase(String resourceBundleName, ClassLoader classLoader) {
        this.resourceBundleName = resourceBundleName;
        this.classLoader = classLoader;
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            try {
                this.resourceBundle = ResourceBundle.getBundle(this.resourceBundleName, Locale.getDefault(), this.classLoader);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-COMUTIL-00029", e);
            }
        }
        return this.resourceBundle;
    }

    public static synchronized StringManagerBase getStringManager(String resourceBundleName, ClassLoader classLoader) {
        StringManagerBase mgr = managers.get(resourceBundleName);
        if (mgr == null) {
            mgr = new StringManagerBase(resourceBundleName, classLoader);
            try {
                managers.put(resourceBundleName, mgr);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-COMUTIL-00027", e);
            }
        }
        return mgr;
    }

    public String getString(String key) {
        return this.getStringWithDefault(key, NO_DEFAULT);
    }

    public String getStringWithDefault(String key, String defaultValue) {
        String value = null;
        try {
            value = this.getResourceBundle().getString(key);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "No local string for: " + key, e);
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getStringWithDefault(String key, String defaultFormat, Object[] arguments) {
        String fmtStr;
        MessageFormat f = new MessageFormat(this.getStringWithDefault(key, defaultFormat));
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                arguments[i] = "null";
                continue;
            }
            if (arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date) continue;
            arguments[i] = arguments[i].toString();
        }
        try {
            fmtStr = f.format(arguments);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "NCLS-COMUTIL-00030", e);
            fmtStr = defaultFormat;
        }
        return fmtStr;
    }

    public String getString(String key, Object arg1) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1});
    }

    public String getString(String key, Object arg1, Object arg2) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2});
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2, arg3});
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2, arg3, arg4});
    }

    public String getString(String key, Object[] args) {
        return this.getStringWithDefault(key, NO_DEFAULT, args);
    }
}

