/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SortedLoggingProperties
extends Properties {
    private final List<Pattern> patterns;
    private final Properties properties;

    public SortedLoggingProperties(Properties properties) {
        this.properties = properties;
        this.patterns = Stream.of("handlers", "handlerServices", "java\\.util\\.logging\\.ConsoleHandler\\.formatter", "java\\.util\\.logging\\.FileHandler.*", "com\\.sun\\.enterprise\\.server\\.logging\\.GFFileHandler.*", "com\\.sun\\.enterprise\\.server\\.logging\\.SyslogHandler.*", "log4j\\.logger\\.org\\.hibernate\\.validator\\.util\\.Version", "com\\.sun\\.enterprise\\.server\\.logging\\.UniformLogFormatter.*", "fish\\.payara\\.enterprise\\.server\\.logging\\.PayaraNotificationFileHandler.*", "fish\\.payara\\.deprecated\\.jsonlogformatter\\.underscoreprefix", "(.*)?\\.level").map(Pattern::compile).collect(Collectors.toList());
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        ArrayList<Object> keys = Collections.list(this.properties.keys());
        List<Integer> keyPatternIndex = keys.stream().map(k -> this.defineIndex(k.toString())).collect(Collectors.toList());
        LoggingKeySorter keySorter = new LoggingKeySorter(keys, keyPatternIndex);
        keys.sort(keySorter);
        return Collections.enumeration(keys);
    }

    private Integer defineIndex(String key) {
        int result = Integer.MAX_VALUE;
        for (int idx = 0; idx < this.patterns.size(); ++idx) {
            if (!this.patterns.get(idx).matcher(key).matches()) continue;
            result = idx;
            break;
        }
        return result;
    }

    @Override
    public synchronized Object get(Object key) {
        return this.properties.get(key);
    }

    private static class LoggingKeySorter
    implements Comparator<Object> {
        private List<Object> keys;
        private List<Integer> keyPatternIndex;

        public LoggingKeySorter(List<Object> keys, List<Integer> keyPatternIndex) {
            this.keys = new ArrayList<Object>(keys);
            this.keyPatternIndex = keyPatternIndex;
        }

        @Override
        public int compare(Object k1, Object k2) {
            Integer v2;
            Integer v1 = this.keyPatternIndex.get(this.keys.indexOf(k1));
            int result = v1.compareTo(v2 = this.keyPatternIndex.get(this.keys.indexOf(k2)));
            if (result == 0) {
                result = k1.toString().compareTo(k2.toString());
            }
            return result;
        }
    }
}

