/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;

public class JQLAST
extends CommonAST {
    private static char SEPARATOR = (char)10;
    private static String INDENT = "  ";
    protected int line = 0;
    protected int column = 0;
    protected Type jqlType;
    protected RetrieveDesc rd;
    protected Object value;

    public JQLAST() {
    }

    public JQLAST(int type, String text, Type jqlType) {
        this.initialize(type, text, jqlType);
    }

    public JQLAST(int type, String text, Type jqlType, Object value) {
        this.initialize(type, text, jqlType, value);
    }

    public JQLAST(Token t) {
        this.initialize(t);
    }

    public JQLAST(JQLAST ast) {
        this.initialize(ast);
    }

    public void initialize(int type) {
        this.setType(type);
    }

    public void initialize(int type, String text) {
        this.setType(type);
        this.setText(text);
    }

    public void initialize(Token t) {
        this.setType(t.getType());
        this.setText(t.getText());
        this.setLine(t.getLine());
        this.setColumn(t.getColumn());
    }

    public void initialize(int type, String text, Type jqlType) {
        this.setType(type);
        this.setText(text);
        this.setJQLType(jqlType);
    }

    public void initialize(int type, String text, Type jqlType, Object value) {
        this.setType(type);
        this.setText(text);
        this.setJQLType(jqlType);
        this.setValue(value);
    }

    public void initialize(AST ast) {
        this.initialize((JQLAST)ast);
    }

    public void initialize(JQLAST ast) {
        this.setType(ast.getType());
        this.setText(ast.getText());
        this.setLine(ast.getLine());
        this.setColumn(ast.getColumn());
        this.setJQLType(ast.getJQLType());
        this.setValue(ast.getValue());
        this.setRetrieveDesc(ast.getRetrieveDesc());
        this.setValue(ast.getValue());
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public void setJQLType(Type jqlType) {
        this.jqlType = jqlType;
    }

    public Type getJQLType() {
        return this.jqlType;
    }

    public void setRetrieveDesc(RetrieveDesc rd) {
        this.rd = rd;
    }

    public RetrieveDesc getRetrieveDesc() {
        return this.rd;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        Type jqlType = this.getJQLType();
        RetrieveDesc rd = this.getRetrieveDesc();
        repr.append(this.getText() == null ? "null" : this.getText());
        repr.append(" [");
        repr.append(this.getType());
        repr.append(", (");
        repr.append(this.getLine() + "/" + this.getColumn());
        repr.append(")");
        repr.append(", ");
        repr.append(jqlType);
        repr.append(", ");
        repr.append(JQLAST.getRetrieveDescRepr(rd));
        repr.append("]");
        return repr.toString();
    }

    public String getTreeRepr(String title) {
        return title + this.getTreeRepr(0);
    }

    private String getTreeRepr(int level) {
        StringBuilder repr = new StringBuilder();
        repr.append(SEPARATOR);
        repr.append(this.getIndent(level));
        repr.append(this.toString());
        for (JQLAST node = (JQLAST)this.getFirstChild(); node != null; node = (JQLAST)node.getNextSibling()) {
            repr.append(node.getTreeRepr(level + 1));
        }
        return repr.toString();
    }

    public static String getRetrieveDescRepr(RetrieveDesc rd) {
        StringBuilder buf = new StringBuilder();
        buf.append("RD:");
        if (rd == null) {
            buf.append("null");
        } else {
            String pcClassName = rd.getPersistenceCapableClass().toString();
            if (pcClassName.startsWith("class ")) {
                buf.append(pcClassName.substring(6));
            } else {
                buf.append(pcClassName);
            }
            buf.append("@");
            buf.append(System.identityHashCode(rd));
        }
        return buf.toString();
    }

    private String getIndent(int level) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            buf.append(INDENT);
        }
        return buf.toString();
    }

    public static class Factory
    extends ASTFactory {
        private static Factory factory = new Factory();

        public static Factory getInstance() {
            return factory;
        }

        protected Factory() {
            this.theASTNodeTypeClass = JQLAST.class;
            this.theASTNodeType = this.theASTNodeTypeClass.getName();
        }

        public AST create() {
            return new JQLAST();
        }
    }
}

