/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.netbeans.modules.dbschema.ColumnElement;

public class LocalFieldDesc
extends FieldDesc {
    final ArrayList columnDescs;
    private Boolean primitiveMappedToNullableColumn;
    private final int primaryColumnType;
    private static final Class[] nonNullableNonScaledTypes = new Class[]{Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, Double.TYPE, Float.TYPE, BigInteger.class, BigDecimal.class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class};
    private static final Class[] nullableNonScaledTypes = new Class[]{BigInteger.class, BigDecimal.class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, Double.TYPE, Float.TYPE};
    private static final Class[] nonNullableScaledTypes = new Class[]{Double.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, BigDecimal.class, Double.class, BigInteger.class, Long.class, Integer.class, Short.class, Byte.class};
    private static final Class[] nullableScaledTypes = new Class[]{BigDecimal.class, Double.class, Float.class, BigInteger.class, Long.class, Integer.class, Short.class, Byte.class, Double.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE};

    LocalFieldDesc(ClassDesc config, ArrayList columnDescs) {
        super(config);
        this.columnDescs = columnDescs;
        this.primaryColumnType = this.getPrimaryColumn().getType();
        this.sqlProperties |= 8;
    }

    public boolean isPrimitiveMappedToNullableColumn() {
        if (this.primitiveMappedToNullableColumn == null) {
            boolean rc = this.getType().isPrimitive();
            Iterator iter = this.columnDescs.iterator();
            while (iter.hasNext() && rc) {
                ColumnElement c = (ColumnElement)iter.next();
                rc = c.isNullable();
            }
            this.primitiveMappedToNullableColumn = rc;
        }
        return this.primitiveMappedToNullableColumn;
    }

    public boolean isMappedToLob() {
        return this.primaryColumnType == 2004 || LocalFieldDesc.isCharLobType(this.primaryColumnType) || this.getEnumType() == 51;
    }

    public static boolean isCharLobType(int sqlType) {
        return sqlType == -1 || sqlType == 2005;
    }

    public static boolean isFixedCharType(int sqlType) {
        return sqlType == 1;
    }

    public ColumnElement getPrimaryColumn() {
        return (ColumnElement)this.columnDescs.get(0);
    }

    public Iterator getColumnElements() {
        return this.columnDescs.iterator();
    }

    public boolean isVersion() {
        return (this.sqlProperties & 0x200) > 0;
    }

    public void incrementValue(StateManager sm) {
        assert (this.isVersion());
        Long val = (Long)this.getValue(sm);
        long value = val != null ? val : 0L;
        this.setValue(sm, new Long(++value));
    }

    @Override
    protected void setupDesc(Field f) {
        super.setupDesc(f);
        if (this.isMappedToLob()) {
            this.sqlProperties &= 0xFFFFFFFE;
        }
        switch (this.getEnumType()) {
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: {
                this.sqlProperties &= 0xFFFFFFFE;
            }
        }
    }

    private static int lookupTypePrecedence(Class type, Class[] typePrecedence) {
        for (int i = 0; i < typePrecedence.length; ++i) {
            if (type != typePrecedence[i]) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private int computeTypePrecedence() {
        ColumnElement c = (ColumnElement)this.columnDescs.get(0);
        int sqlType = c.getType();
        Class type = this.getType();
        boolean isNullable = c.isNullable();
        int precedence = Integer.MAX_VALUE;
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (isNullable) {
                    precedence = LocalFieldDesc.lookupTypePrecedence(type, nullableNonScaledTypes);
                    break;
                }
                precedence = LocalFieldDesc.lookupTypePrecedence(type, nonNullableNonScaledTypes);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (isNullable) {
                    precedence = LocalFieldDesc.lookupTypePrecedence(type, nullableScaledTypes);
                    break;
                }
                precedence = LocalFieldDesc.lookupTypePrecedence(type, nonNullableScaledTypes);
                break;
            }
            case 2: 
            case 3: {
                int scale = -1;
                scale = c.getScale();
                if (scale == 0) {
                    if (isNullable) {
                        precedence = LocalFieldDesc.lookupTypePrecedence(type, nullableNonScaledTypes);
                        break;
                    }
                    precedence = LocalFieldDesc.lookupTypePrecedence(type, nonNullableNonScaledTypes);
                    break;
                }
                if (scale <= 0) break;
                if (isNullable) {
                    precedence = LocalFieldDesc.lookupTypePrecedence(type, nullableScaledTypes);
                    break;
                }
                precedence = LocalFieldDesc.lookupTypePrecedence(type, nonNullableScaledTypes);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (type != String.class) break;
                precedence = 0;
                break;
            }
            case 91: 
            case 93: {
                if (!Date.class.isAssignableFrom(type)) break;
                precedence = 0;
                break;
            }
            case -7: {
                if (type == Boolean.class) {
                    if (isNullable) {
                        precedence = 0;
                        break;
                    }
                    precedence = 1;
                    break;
                }
                if (type != Boolean.TYPE) break;
                precedence = isNullable ? 1 : 0;
            }
        }
        return precedence;
    }

    void computeTrackedPrimitiveFields() {
        for (int i = 0; i < this.classDesc.fields.size(); ++i) {
            FieldDesc tf = (FieldDesc)this.classDesc.fields.get(i);
            if (!(tf instanceof LocalFieldDesc) || this == tf || !LocalFieldDesc.compareColumns(this, tf)) continue;
            this.addTrackedField(tf);
        }
    }

    void computePrimaryTrackedPrimitiveField() {
        ArrayList trackedFields = null;
        trackedFields = this.getTrackedFields();
        if (trackedFields == null || (this.sqlProperties & 0x64) > 0) {
            return;
        }
        this.sqlProperties |= 0x40;
        FieldDesc primaryTrackedField = null;
        int currentPrecedence = Integer.MAX_VALUE;
        int precedence = 0;
        precedence = this.computeTypePrecedence();
        if (precedence < currentPrecedence) {
            primaryTrackedField = this;
            currentPrecedence = precedence;
        }
        for (int j = 0; j < trackedFields.size(); ++j) {
            FieldDesc tf = (FieldDesc)trackedFields.get(j);
            if (tf instanceof ForeignFieldDesc) continue;
            tf.sqlProperties |= 0x40;
            precedence = ((LocalFieldDesc)tf).computeTypePrecedence();
            if (precedence >= currentPrecedence) continue;
            primaryTrackedField = tf;
            currentPrecedence = precedence;
        }
        if (primaryTrackedField == null) {
            primaryTrackedField = this;
        }
        if (logger.isLoggable(300)) {
            logger.finest("sqlstore.model.classdesc.primarytrackedfield", (Object)primaryTrackedField.getName());
        }
        primaryTrackedField.sqlProperties |= 0x20;
        primaryTrackedField.sqlProperties &= 0xFFFFFFBF;
    }

    @Override
    void computeTrackedRelationshipFields() {
        if ((this.sqlProperties & 0x10) == 0 && (this.sqlProperties & 0x100) == 0) {
            return;
        }
        for (int k = 0; k < this.classDesc.foreignFields.size(); ++k) {
            ForeignFieldDesc tf = (ForeignFieldDesc)this.classDesc.foreignFields.get(k);
            if (!LocalFieldDesc.compareColumns(this, tf) || (this.sqlProperties & 0x100) > 0 && (tf.cardinalityUPB > 1 || tf.cardinalityLWB == 0)) continue;
            if (this.getTrackedFields() == null) {
                this.sqlProperties |= 0x20;
            }
            this.addTrackedField(tf);
            this.sqlProperties |= 0x80;
        }
    }

    void cleanupTrackedFields() {
        ArrayList trackedFields = this.getTrackedFields();
        if (trackedFields != null) {
            FieldDesc tf;
            int index;
            int j = 1;
            while ((index = trackedFields.size() - j) >= 0 && !((tf = (FieldDesc)trackedFields.get(index)) instanceof LocalFieldDesc)) {
                ArrayList foreignTrackedFields = tf.getTrackedFields();
                if (foreignTrackedFields != null) {
                    trackedFields.removeAll(foreignTrackedFields);
                }
                ++j;
            }
        }
    }
}

