/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ContainerHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerWrapper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ResourceBundle;
import javax.ejb.EJBContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.transaction.Transaction;
import org.glassfish.persistence.common.I18NHelper;

public class CMPHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", CMPHelper.class.getClassLoader());
    private static Logger logger = LogHelperPersistenceManager.getLogger();
    private static ContainerHelper containerHelper = null;
    private static long counter = System.currentTimeMillis();

    public static void registerContainerHelper(ContainerHelper h) {
        containerHelper = h;
    }

    public static synchronized long getNextId() {
        return ++counter;
    }

    public static Object getContainer(Object info) {
        return CMPHelper.getContainerHelper().getContainer(info);
    }

    public static EJBObject getEJBObject(Object pk, Object container) {
        return CMPHelper.getContainerHelper().getEJBObject(pk, container);
    }

    public static EJBLocalObject getEJBLocalObject(Object pk, Object container) {
        return CMPHelper.getContainerHelper().getEJBLocalObject(pk, container);
    }

    public static EJBLocalObject getEJBLocalObject(Object pk, Object container, EJBContext context) {
        return CMPHelper.getContainerHelper().getEJBLocalObject(pk, container, context);
    }

    public static void removeByEJBLocalObject(EJBLocalObject ejb, Object container) {
        CMPHelper.getContainerHelper().removeByEJBLocalObject(ejb, container);
    }

    public static void removeByPK(Object pk, Object container) {
        CMPHelper.getContainerHelper().removeByPK(pk, container);
    }

    public static void setCascadeDeleteAfterSuperEJBRemove(EntityContext context) {
        CMPHelper.getContainerHelper().setCascadeDeleteAfterSuperEJBRemove(context);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Object container) {
        return CMPHelper.getContainerHelper().getPersistenceManagerFactory(container);
    }

    public static void assertValidLocalObject(Object o, Object container) {
        CMPHelper.getContainerHelper().assertValidLocalObject(o, container);
    }

    public static void assertValidRemoteObject(Object o, Object container) {
        CMPHelper.getContainerHelper().assertValidRemoteObject(o, container);
    }

    public static void preSelect(Object container) {
        CMPHelper.getContainerHelper().preSelect(container);
    }

    public static int getNumericConverterPolicy(Object container) {
        return CMPHelper.getContainerHelper().getNumericConverterPolicy(container);
    }

    public static void beginInternalTransaction(PersistenceManager pm) {
        CMPHelper.getContainerHelper().beginInternalTransaction(pm);
    }

    public static void commitInternalTransaction(PersistenceManager pm) {
        CMPHelper.getContainerHelper().commitInternalTransaction(pm);
    }

    public static void rollbackInternalTransaction(PersistenceManager pm) {
        CMPHelper.getContainerHelper().rollbackInternalTransaction(pm);
    }

    public static Transaction suspendCurrentTransaction() {
        return CMPHelper.getContainerHelper().suspendCurrentTransaction();
    }

    public static void resumeCurrentTransaction(Transaction tx) {
        CMPHelper.getContainerHelper().resumeCurrentTransaction(tx);
    }

    public static void flush(PersistenceManager pm) {
        com.sun.jdo.api.persistence.support.Transaction tx = pm.currentTransaction();
        if (tx != null && tx.isActive()) {
            PersistenceManagerWrapper pmw = (PersistenceManagerWrapper)pm;
            PersistenceManagerImpl pmi = (PersistenceManagerImpl)pmw.getPersistenceManager();
            pmi.internalFlush();
        }
    }

    public static boolean isContainerReady() {
        return containerHelper != null;
    }

    private static ContainerHelper getContainerHelper() {
        if (containerHelper == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.cmphelper.nonmanaged"));
        }
        return containerHelper;
    }
}

