/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Rejar {
    public void rejar(File out, File modules) throws IOException {
        HashMap<String, ByteArrayOutputStream> metadata = new HashMap<String, ByteArrayOutputStream>();
        try (FileOutputStream fos = new FileOutputStream(out);){
            HashSet<String> names = new HashSet<String>();
            names.add(Attributes.Name.MAIN_CLASS.toString());
            try (JarOutputStream jos = new JarOutputStream((OutputStream)fos, this.getManifest());){
                this.processDirectory(jos, modules, names, metadata);
                File[] directories = modules.listFiles(pathname -> pathname.isDirectory());
                if (directories != null) {
                    for (File directory : directories) {
                        this.processDirectory(jos, directory, names, metadata);
                    }
                }
                for (Map.Entry entry : metadata.entrySet()) {
                    this.copy(((ByteArrayOutputStream)entry.getValue()).toByteArray(), (String)entry.getKey(), jos);
                }
                jos.flush();
            }
        }
    }

    protected Manifest getManifest() throws IOException {
        Manifest m = new Manifest();
        m.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        m.getMainAttributes().put(Attributes.Name.MAIN_CLASS, "com.sun.enterprise.glassfish.bootstrap.ASMain");
        return m;
    }

    protected void processDirectory(JarOutputStream jos, File directory, Set<String> names, Map<String, ByteArrayOutputStream> metadata) throws IOException {
        File[] jars = directory.listFiles(pathname -> pathname.getName().endsWith("jar"));
        if (jars != null) {
            for (File module : jars) {
                try (JarFile in = new JarFile(module);){
                    Enumeration<JarEntry> entries = in.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry je = entries.nextElement();
                        if (je.getName().endsWith("MANIFEST.MF") || names.contains(je.getName()) || je.isDirectory()) continue;
                        if (je.getName().startsWith("META-INF/inhabitants/") || je.getName().startsWith("META-INF/services/")) {
                            ByteArrayOutputStream stream = metadata.get(je.getName());
                            if (stream == null) {
                                stream = new ByteArrayOutputStream();
                                metadata.put(je.getName(), stream);
                            }
                            stream.write(("# from " + module.getName() + "\n").getBytes());
                            this.copy(in, je, stream);
                            continue;
                        }
                        names.add(je.getName());
                        this.copy(in, je, jos);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(JarFile in, JarEntry je, JarOutputStream jos) throws IOException {
        try {
            jos.putNextEntry(new JarEntry(je.getName()));
            this.copy(in, je, (OutputStream)jos);
        }
        finally {
            jos.flush();
            jos.closeEntry();
        }
    }

    protected void copy(JarFile in, JarEntry je, OutputStream os) throws IOException {
        this.copy(in, je, Channels.newChannel(os));
    }

    protected void copy(JarFile in, JarEntry je, WritableByteChannel out) throws IOException {
        try (ReadableByteChannel inChannel = Channels.newChannel(in.getInputStream(je));){
            ByteBuffer byteBuffer = ByteBuffer.allocate(Long.valueOf(je.getSize()).intValue());
            inChannel.read(byteBuffer);
            byteBuffer.rewind();
            out.write(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(byte[] bytes, String name, JarOutputStream jos) throws IOException {
        try {
            jos.putNextEntry(new JarEntry(name));
            jos.write(bytes);
        }
        finally {
            jos.closeEntry();
        }
    }
}

