/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.deployment.versioning.VersioningWildcardException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-application-ref")
@I18n(value="create.application.ref.command")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="create-application-ref"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="create-application-ref")})
public class CreateApplicationRefCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(optional=true, acceptableValues="true,false")
    public String lbenabled;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    VersioningService versioningService;
    @Inject
    @Named(value="default-instance-name")
    protected Server server;
    @Inject
    private ServiceLocator habitat;
    @Inject
    Events events;

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target), "create"));
        return accessChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        ArrayList<String> matchedVersions = null;
        if (this.enabled.booleanValue()) {
            try {
                VersioningUtils.checkIdentifier((String)this.name);
                matchedVersions = new ArrayList<String>(1);
                matchedVersions.add(this.name);
            }
            catch (VersioningWildcardException ex) {
                report.setMessage(localStrings.getLocalString("wildcard.not.allowed", "WARNING : version expression are available only with --enabled=false"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            catch (VersioningSyntaxException ex) {
                report.setMessage(ex.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.deployment.isRegistered(this.name)) {
                report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            try {
                matchedVersions = this.versioningService.getMatchedVersions(this.name, null);
            }
            catch (VersioningException e) {
                report.failure(logger, e.getMessage());
                return;
            }
            if (matchedVersions.isEmpty()) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        ActionReport.MessagePart part = report.getTopMessagePart();
        boolean isVersionExpression = VersioningUtils.isVersionExpression((String)this.name);
        for (String appName : matchedVersions) {
            ReadableArchive archive;
            Properties contextProps;
            Application applicationInfo = this.applications.getApplication(appName);
            List deploymentGroups = this.domain.getDeploymentGroupsForInstance(this.target);
            boolean isAppOnDeploymentGroupInstance = false;
            if (deploymentGroups != null && deploymentGroups.isEmpty()) {
                List applicationsInTarget = this.domain.getApplicationsInTarget(this.target);
                ArrayList<String> listOfApplications = new ArrayList<String>();
                for (Application application : applicationsInTarget) {
                    listOfApplications.add(application.getName());
                }
                if (listOfApplications.contains(appName)) {
                    isAppOnDeploymentGroupInstance = true;
                    break;
                }
            }
            if (isAppOnDeploymentGroupInstance) continue;
            ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(appName, this.target);
            if (applicationRef != null) {
                if (isVersionExpression) {
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", new Object[]{appName, this.target}));
                    continue;
                }
                report.setMessage(localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", new Object[]{this.name, this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Transaction t = new Transaction();
            if (applicationInfo.isLifecycleModule()) {
                this.handleLifecycleModule(context, t);
                return;
            }
            File file = null;
            DeployCommandParameters commandParams = null;
            Map modulePropsMap = null;
            ApplicationConfigInfo savedAppConfig = null;
            try {
                commandParams = applicationInfo.getDeployParameters(null);
                commandParams.origin = OpsParams.Origin.create_application_ref;
                commandParams.command = OpsParams.Command.create_application_ref;
                commandParams.target = this.target;
                commandParams.virtualservers = this.virtualservers;
                commandParams.enabled = this.enabled;
                if (this.lbenabled != null) {
                    commandParams.lbenabled = this.lbenabled;
                }
                commandParams.type = applicationInfo.archiveType();
                contextProps = applicationInfo.getDeployProperties();
                modulePropsMap = applicationInfo.getModulePropertiesMap();
                savedAppConfig = new ApplicationConfigInfo(applicationInfo);
                URI uri = new URI(applicationInfo.getLocation());
                file = new File(uri);
                if (!file.exists()) {
                    report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                archive = this.archiveFactory.openArchive(file);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                report.setMessage(localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                String runtimeAltDDLocation;
                String altDDLocation;
                ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(archive).build();
                Properties appProps = deploymentContext.getAppProps();
                appProps.putAll((Map<?, ?>)contextProps);
                String location = DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(applicationInfo.getLocation()));
                appProps.setProperty("location", location);
                String appLocation = appProps.getProperty("appLocation");
                appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(appLocation)));
                String planLocation = appProps.getProperty("deploymentPlanLocation");
                if (planLocation != null) {
                    appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(planLocation)));
                }
                if ((altDDLocation = appProps.getProperty("altDDLocation")) != null) {
                    appProps.setProperty("altDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(altDDLocation)));
                }
                if ((runtimeAltDDLocation = appProps.getProperty("runtimeAltDDLocation")) != null) {
                    appProps.setProperty("runtimeAltDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(runtimeAltDDLocation)));
                }
                savedAppConfig.store(appProps);
                if (modulePropsMap != null) {
                    deploymentContext.setModulePropsMap(modulePropsMap);
                }
                if (this.enabled.booleanValue()) {
                    this.versioningService.handleDisable(appName, this.target, deploymentContext.getActionReport(), context.getSubject());
                }
                if (this.domain.isCurrentInstanceMatchingTarget(this.target, appName, this.server.getName(), null)) {
                    this.deployment.deploy((Collection)this.deployment.getSniffersFromApp(applicationInfo), deploymentContext);
                } else {
                    this.events.send(new EventListener.Event(Deployment.APPLICATION_PREPARED, (Object)deploymentContext), false);
                }
                ArrayList<String> targets = new ArrayList<String>(Arrays.asList(commandParams.target.split(",")));
                ArrayList<String> deploymentTarget = new ArrayList<String>();
                for (String target : targets) {
                    if (!this.isDeploymentGroup(target)) continue;
                    List instances = this.domain.getDeploymentGroupNamed(target).getInstances();
                    for (Server instance : instances) {
                        List applications = this.domain.getApplicationsInTarget(instance.getName());
                        ArrayList<String> listOfApplications = new ArrayList<String>();
                        for (Application application : applications) {
                            listOfApplications.add(application.getName());
                        }
                        if (listOfApplications.contains(appName)) continue;
                        deploymentTarget.add(instance.getName());
                    }
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    try {
                        this.deployment.registerAppInDomainXML(null, (DeploymentContext)deploymentContext, t, true);
                    }
                    catch (TransactionFailure e) {
                        logger.warning("failed to create application ref for " + appName);
                    }
                }
                if (!isVersionExpression && DeploymentUtils.isDASTarget((String)this.target)) {
                    return;
                }
                ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap((DeploymentContext)deploymentContext);
                if (!deploymentTarget.isEmpty()) {
                    this.replicateCommand(deploymentTarget, context, paramMap);
                    continue;
                }
                this.replicateCommand(targets, context, paramMap);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error during creating application ref ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            finally {
                try {
                    archive.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
            }
        }
    }

    private void replicateCommand(List<String> targets, AdminCommandContext context, ParameterMap paramMap) {
        ClusterOperationUtil.replicateCommand((String)"_deploy", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (FailurePolicy)FailurePolicy.Ignore, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (ServiceLocator)this.habitat);
    }

    private boolean isDeploymentGroup(String target) {
        boolean isDeploymentGroup = false;
        List listOfDeploymentGroups = this.domain.getDeploymentGroups().getDeploymentGroup();
        for (DeploymentGroup deploymentGroup : listOfDeploymentGroups) {
            if (!deploymentGroup.getName().equals(target)) continue;
            isDeploymentGroup = true;
            break;
        }
        return isDeploymentGroup;
    }

    private void handleLifecycleModule(AdminCommandContext context, Transaction t) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        Application app = this.applications.getApplication(this.name);
        DeployCommandParameters commandParams = new DeployCommandParameters();
        commandParams.name = this.name;
        commandParams.target = this.target;
        commandParams.virtualservers = this.virtualservers;
        commandParams.enabled = this.enabled;
        DeploymentContextImpl lifecycleContext = new DeploymentContextImpl(report, null, (OpsParams)commandParams, null);
        try {
            this.deployment.registerAppInDomainXML(null, (DeploymentContext)lifecycleContext, t, true);
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
        if (!DeploymentUtils.isDASTarget((String)this.target)) {
            ParameterMap paramMap = new ParameterMap();
            paramMap.add((Object)"DEFAULT", (Object)this.name);
            paramMap.add((Object)"target", (Object)this.target);
            paramMap.add((Object)"enabled", (Object)this.enabled.toString());
            if (this.virtualservers != null) {
                paramMap.add((Object)"virtualservers", (Object)this.virtualservers);
            }
            Properties appProps = app.getDeployProperties();
            paramMap.set((Object)"appprops", (Object)DeploymentUtils.propertiesValue((Properties)appProps, (char)':'));
            ArrayList<String> targets = new ArrayList<String>();
            targets.add(this.target);
            ClusterOperationUtil.replicateCommand((String)"_lifecycle", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (FailurePolicy)FailurePolicy.Ignore, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (ServiceLocator)this.habitat);
        }
    }
}

