/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.deployment.admin;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.deployment.util.GAVConvertor;
import fish.payara.deployment.util.JavaArchiveUtils;
import fish.payara.deployment.util.URIUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="deploy-remote-archive")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.POST, path="deploy-remote-archive"), @RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="deploy-remote-archive", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="deploy-remote-archive", params={@RestParam(name="target", value="$parent")})})
public class DeployRemoteArchiveCommand
extends DeployCommandParameters
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(DeployRemoteArchiveCommand.class.getName());
    @Param(primary=true)
    private String path;
    @Param(name="additionalRepositories", optional=true, alias="additionalrepositories")
    private List<String> additionalRepositories;
    @Inject
    ServiceLocator serviceLocator;

    public void execute(AdminCommandContext context) {
        String fileName;
        CommandRunner commandRunner = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport actionReport = context.getActionReport();
        File fileToDeploy = null;
        String lowerPath = this.path.toLowerCase();
        if (lowerPath.startsWith("http://") || lowerPath.startsWith("https://")) {
            try {
                URI pathURI = new URI(this.path);
                fileToDeploy = URIUtils.convertToFile((URI)pathURI);
                fileName = new File(pathURI.getPath()).getName();
                if (this.name == null) {
                    this.name = JavaArchiveUtils.removeJavaArchiveExtension((String)fileName, (boolean)true);
                }
                if (this.contextroot == null) {
                    this.contextroot = "/" + JavaArchiveUtils.removeJavaArchiveExtension((String)fileName, (boolean)true);
                }
            }
            catch (IOException | URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage());
                actionReport.setMessage("Exception converting URI to File: " + this.path);
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        } else {
            try {
                logger.log(Level.FINE, "Path does not appear to be a URI, will attempt to read as GAV coordinate");
                Map.Entry artefactEntry = GAVConvertor.getArtefactMapEntry((String)this.path, this.additionalRepositories);
                fileToDeploy = URIUtils.convertToFile((URI)((URI)artefactEntry.getValue()));
                if (this.name == null) {
                    fileName = new File(((URI)artefactEntry.getValue()).getPath()).getName();
                    this.name = JavaArchiveUtils.removeJavaArchiveExtension((String)fileName, (boolean)true);
                }
                if (this.contextroot == null) {
                    this.contextroot = "/" + (String)artefactEntry.getKey();
                }
            }
            catch (IOException | URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage());
                actionReport.setMessage("Exception converting GAV to File: " + this.path);
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        if (fileToDeploy != null) {
            ActionReport subReport = actionReport.addSubActionsReport();
            CommandRunner.CommandInvocation commandInvocation = commandRunner.getCommandInvocation("deploy", subReport, context.getSubject());
            ParameterMap parameters = this.createAndPopulateParameterMap(fileToDeploy);
            commandInvocation.parameters(parameters);
            commandInvocation.execute();
        } else {
            actionReport.setMessage("Provided path does not appear to be a valid URI or GAV coordinate: " + this.path + "\nSee the server log for more details");
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private ParameterMap createAndPopulateParameterMap(File fileToDeploy) {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.add((Object)"name", (Object)this.name);
        parameterMap.add((Object)"path", (Object)fileToDeploy.getAbsolutePath());
        parameterMap.add((Object)"contextroot", (Object)this.contextroot);
        if (this.virtualservers != null) {
            parameterMap.add((Object)"virtualservers", (Object)this.virtualservers);
        }
        if (this.libraries != null) {
            parameterMap.add((Object)"libraries", (Object)this.libraries);
        }
        if (this.force != null) {
            parameterMap.add((Object)"force", (Object)this.force.toString());
        }
        if (this.precompilejsp != null) {
            parameterMap.add((Object)"precompilejsp", (Object)this.precompilejsp.toString());
        }
        if (this.verify != null) {
            parameterMap.add((Object)"verify", (Object)this.verify.toString());
        }
        if (this.retrieve != null) {
            parameterMap.add((Object)"retrieve", (Object)this.retrieve);
        }
        if (this.dbvendorname != null) {
            parameterMap.add((Object)"dbvendorname", (Object)this.dbvendorname);
        }
        if (this.createtables != null) {
            parameterMap.add((Object)"createtables", (Object)this.createtables.toString());
        }
        if (this.dropandcreatetables != null) {
            parameterMap.add((Object)"dropandcreatetables", (Object)this.dropandcreatetables.toString());
        }
        if (this.uniquetablenames != null) {
            parameterMap.add((Object)"uniquetablenames", (Object)this.uniquetablenames.toString());
        }
        if (this.deploymentplan != null) {
            parameterMap.add((Object)"deploymentplan", (Object)this.deploymentplan.getAbsolutePath());
        }
        if (this.altdd != null) {
            parameterMap.add((Object)"altdd", (Object)this.altdd.getAbsolutePath());
        }
        if (this.runtimealtdd != null) {
            parameterMap.add((Object)"runtimealtdd", (Object)this.runtimealtdd.getAbsolutePath());
        }
        if (this.enabled != null) {
            parameterMap.add((Object)"enabled", (Object)this.enabled.toString());
        }
        if (this.generatermistubs != null) {
            parameterMap.add((Object)"generatermistubs", (Object)this.generatermistubs.toString());
        }
        if (this.availabilityenabled != null) {
            parameterMap.add((Object)"availabilityenabled", (Object)this.availabilityenabled.toString());
        }
        if (this.asyncreplication != null) {
            parameterMap.add((Object)"asyncreplication", (Object)this.asyncreplication.toString());
        }
        if (this.target != null) {
            parameterMap.add((Object)"target", (Object)this.target);
        }
        if (this.keepreposdir != null) {
            parameterMap.add((Object)"keepreposdir", (Object)this.keepreposdir.toString());
        }
        if (this.keepfailedstubs != null) {
            parameterMap.add((Object)"keepfailedstubs", (Object)this.keepfailedstubs.toString());
        }
        if (this.isredeploy != null) {
            parameterMap.add((Object)"isredeploy", (Object)this.isredeploy.toString());
        }
        if (this.logReportedErrors != null) {
            parameterMap.add((Object)"logReportedErrors", (Object)this.logReportedErrors.toString());
        }
        if (this.properties != null) {
            String propertiesString = this.properties.toString();
            propertiesString = propertiesString.replaceAll(", ", ":");
            parameterMap.add((Object)"properties", (Object)propertiesString);
        }
        if (this.property != null) {
            String propertyString = this.property.toString();
            propertyString = propertyString.replaceAll(", ", ":");
            parameterMap.add((Object)"property", (Object)propertyString);
        }
        if (this.type != null) {
            parameterMap.add((Object)"type", (Object)this.type);
        }
        if (this.keepstate != null) {
            parameterMap.add((Object)"keepstate", (Object)this.keepstate.toString());
        }
        if (this.lbenabled != null) {
            parameterMap.add((Object)"lbenabled", (Object)this.lbenabled);
        }
        if (this.deploymentorder != null) {
            parameterMap.add((Object)"deploymentorder", (Object)this.deploymentorder.toString());
        }
        return parameterMap;
    }
}

