/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.config.SystemPropertiesConfiguration;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.xml.BeansXmlHandler;
import org.jboss.weld.xml.BeansXmlStreamParser;
import org.jboss.weld.xml.BeansXmlValidator;

public class BeansXmlParser {
    private final BeansXmlValidator beansXmlValidator = SystemPropertiesConfiguration.INSTANCE.isXmlValidationDisabled() ? null : new BeansXmlValidator();

    public BeansXml parse(URL beansXml) {
        BeansXmlHandler handler = this.getHandler(beansXml);
        if (this.beansXmlValidator != null) {
            this.beansXmlValidator.validate(beansXml, handler);
        }
        return handler != null ? new BeansXmlStreamParser(beansXml, text -> handler.interpolate((String)text)).parse() : new BeansXmlStreamParser(beansXml).parse();
    }

    public BeansXml parse(Iterable<URL> urls) {
        return this.parse(urls, false);
    }

    public BeansXml parse(Iterable<URL> urls, boolean removeDuplicates) {
        return BeansXmlParser.merge(urls, this::parse, removeDuplicates);
    }

    protected BeansXmlHandler getHandler(URL beansXml) {
        return null;
    }

    public static <T> BeansXml merge(Iterable<? extends T> items, Function<T, BeansXml> function, boolean removeDuplicates) {
        ArrayList<Metadata<String>> alternatives = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> alternativeStereotypes = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> decorators = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> interceptors = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<Filter>> includes = new ArrayList<Metadata<Filter>>();
        ArrayList<Metadata<Filter>> excludes = new ArrayList<Metadata<Filter>>();
        boolean isTrimmed = false;
        URL beansXmlUrl = null;
        for (T item : items) {
            BeansXml beansXml = function.apply(item);
            if (beansXml == null) continue;
            BeansXmlParser.addTo(alternatives, beansXml.getEnabledAlternativeClasses(), removeDuplicates);
            BeansXmlParser.addTo(alternativeStereotypes, beansXml.getEnabledAlternativeStereotypes(), removeDuplicates);
            BeansXmlParser.addTo(decorators, beansXml.getEnabledDecorators(), removeDuplicates);
            BeansXmlParser.addTo(interceptors, beansXml.getEnabledInterceptors(), removeDuplicates);
            includes.addAll(beansXml.getScanning().getIncludes());
            excludes.addAll(beansXml.getScanning().getExcludes());
            isTrimmed = beansXml.isTrimmed();
            beansXmlUrl = beansXml.getUrl();
        }
        return new BeansXmlImpl(alternatives, alternativeStereotypes, decorators, interceptors, new ScanningImpl(includes, excludes), beansXmlUrl, BeanDiscoveryMode.ALL, null, isTrimmed);
    }

    private static void addTo(List<Metadata<String>> list, List<Metadata<String>> listToAdd, boolean removeDuplicates) {
        if (removeDuplicates) {
            ArrayList<Metadata<String>> filteredListToAdd = new ArrayList<Metadata<String>>(listToAdd.size());
            for (Metadata<String> metadata : listToAdd) {
                if (BeansXmlParser.alreadyAdded(metadata, list)) continue;
                filteredListToAdd.add(metadata);
            }
            listToAdd = filteredListToAdd;
        }
        list.addAll(listToAdd);
    }

    private static boolean alreadyAdded(Metadata<String> metadata, List<Metadata<String>> list) {
        for (Metadata<String> existing : list) {
            if (!existing.getValue().equals(metadata.getValue())) continue;
            return true;
        }
        return false;
    }

    public static BeansXml mergeExisting(Iterable<? extends BeanDeploymentArchive> beanArchives, boolean removeDuplicates) {
        return BeansXmlParser.merge(beanArchives, bda -> bda.getBeansXml(), removeDuplicates);
    }

    public static BeansXml mergeExistingDescriptors(Iterable<BeansXml> beanArchives, boolean removeDuplicates) {
        return BeansXmlParser.merge(beanArchives, Function.identity(), removeDuplicates);
    }
}

