/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigFactory;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.server.logging.commands.ListLoggerLevels;
import com.sun.enterprise.server.logging.commands.TargetInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-log-attributes")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@PerLookup
@I18n(value="list.log.attributes")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-log-attributes", description="list-log-attributes")})
public class ListLogAttributes
implements AdminCommand {
    @Inject
    private LoggingConfigFactory loggingConfigFactory;
    @Param(primary=true, optional=true, defaultValue="server")
    String target;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    Clusters clusters;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLoggerLevels.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            HashMap props = null;
            TargetInfo targetInfo = new TargetInfo(this.domain, this.target);
            String targetConfigName = targetInfo.getConfigName();
            boolean isDas = targetInfo.isDas();
            if (targetConfigName != null && !targetConfigName.isEmpty()) {
                props = (HashMap)this.loggingConfigFactory.provide(targetConfigName).getLoggingProperties(false);
            } else if (isDas) {
                props = (HashMap)this.loggingConfigFactory.provide().getLoggingProperties(false);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", new Object[]{this.target});
                report.setMessage(msg);
                return;
            }
            ArrayList keys = new ArrayList();
            keys.addAll(props.keySet());
            Collections.sort(keys);
            Iterator it2 = keys.iterator();
            HashMap logAttributes = new HashMap();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                if (name.endsWith(".level") || name.equals(".level")) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(name + "\t<" + (String)props.get(name) + ">");
                logAttributes.put(name, props.get(name));
            }
            Properties restData = new Properties();
            restData.put("logAttributes", logAttributes);
            restData.put("defaultLoggingProperties", this.loggingConfigFactory.provide().getLoggingProperties());
            report.setExtraProperties(restData);
        }
        catch (IOException ex) {
            report.setMessage(localStrings.getLocalString("get.log.attribute.failed", "Could not get logging attributes for {0}.", new Object[]{this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

